/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ResourceLoader;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003$%&B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0086\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR2\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00030\u0003 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lai/platon/pulsar/common/SingleFiledLines;", "", "file", "", "preprocessor", "Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "wordsComparator", "Ljava/util/Comparator;", "(Ljava/lang/String;Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;Ljava/util/Comparator;)V", "getFile", "()Ljava/lang/String;", "isEmpty", "", "()Z", "isNotEmpty", "lines", "Lcom/google/common/collect/TreeMultiset;", "kotlin.jvm.PlatformType", "getPreprocessor", "()Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "size", "", "getSize", "()I", "getWordsComparator", "()Ljava/util/Comparator;", "contains", "text", "Lcom/google/common/collect/Multiset;", "load", "", "merge", "other", "save", "saveTo", "destFile", "Preprocessor", "RegexPreprocessor", "TextPreprocessor", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nSingleFiledLines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleFiledLines.kt\nai/platon/pulsar/common/SingleFiledLines\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n766#2:98\n857#2,2:99\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 SingleFiledLines.kt\nai/platon/pulsar/common/SingleFiledLines\n*L\n56#1:94\n56#1:95,3\n57#1:98\n57#1:99,2\n63#1:101,2\n*E\n"})
public final class SingleFiledLines {
    @NotNull
    private final String file;
    @NotNull
    private final Preprocessor preprocessor;
    @NotNull
    private final Comparator<String> wordsComparator;
    private final TreeMultiset<String> lines;

    public SingleFiledLines(@NotNull String file, @NotNull Preprocessor preprocessor, @NotNull Comparator<String> wordsComparator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)preprocessor, (String)"preprocessor");
        Intrinsics.checkNotNullParameter(wordsComparator, (String)"wordsComparator");
        this.file = file;
        this.preprocessor = preprocessor;
        this.wordsComparator = wordsComparator;
        this.lines = TreeMultiset.create();
        this.load();
    }

    public /* synthetic */ SingleFiledLines(String string, Preprocessor preprocessor, Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            preprocessor = new TextPreprocessor();
        }
        if ((n & 4) != 0) {
            comparator = SingleFiledLines::_init_$lambda$0;
        }
        this(string, preprocessor, comparator);
    }

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final Preprocessor getPreprocessor() {
        return this.preprocessor;
    }

    @NotNull
    public final Comparator<String> getWordsComparator() {
        return this.wordsComparator;
    }

    public final void merge(@NotNull SingleFiledLines other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.lines.addAll((Collection)other.lines());
    }

    public final boolean contains(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.lines.contains((Object)text);
    }

    @NotNull
    public final Multiset<String> lines() {
        TreeMultiset<String> treeMultiset = this.lines;
        Intrinsics.checkNotNullExpressionValue(treeMultiset, (String)"lines");
        return (Multiset)treeMultiset;
    }

    public final int getSize() {
        return this.lines.size();
    }

    public final boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public final boolean isNotEmpty() {
        TreeMultiset<String> treeMultiset = this.lines;
        Intrinsics.checkNotNullExpressionValue(treeMultiset, (String)"lines");
        return !((Collection)treeMultiset).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        if (StringsKt.isBlank((CharSequence)this.file)) {
            return;
        }
        Iterable $this$map$iv = ResourceLoader.INSTANCE.readAllLines(this.file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.preprocessor.process(it));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)((Collection)this.lines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveTo(@NotNull String destFile) {
        Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
        Closeable closeable = new PrintWriter(new FileWriter(destFile));
        Throwable throwable = null;
        try {
            PrintWriter pw = (PrintWriter)closeable;
            boolean bl = false;
            TreeMultiset<String> treeMultiset = this.lines;
            Intrinsics.checkNotNullExpressionValue(treeMultiset, (String)"lines");
            Iterable $this$forEach$iv = (Iterable)treeMultiset;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl2 = false;
                pw.println(line);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void save() {
        if (!this.lines.isEmpty()) {
            this.saveTo(this.file);
        }
    }

    private static final int _init_$lambda$0(String t, String t2) {
        Intrinsics.checkNotNullExpressionValue((Object)t2, (String)"t2");
        return t.compareTo(t2);
    }

    public SingleFiledLines() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "", "process", "", "line", "pulsar-common"})
    public static interface Preprocessor {
        @NotNull
        public String process(@NotNull String var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/SingleFiledLines$RegexPreprocessor;", "Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "()V", "process", "", "line", "pulsar-common"})
    public static final class RegexPreprocessor
    implements Preprocessor {
        @Override
        @NotNull
        public String process(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            String line2 = line;
            line2 = StringsKt.startsWith$default((String)line2, (String)"#", (boolean)false, (int)2, null) ? "" : ((Object)StringsKt.trim((CharSequence)line2)).toString();
            return line2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/SingleFiledLines$TextPreprocessor;", "Lai/platon/pulsar/common/SingleFiledLines$Preprocessor;", "()V", "process", "", "line", "pulsar-common"})
    public static final class TextPreprocessor
    implements Preprocessor {
        @Override
        @NotNull
        public String process(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            String line2 = line;
            line2 = StringsKt.startsWith$default((String)line2, (String)"#", (boolean)false, (int)2, null) ? "" : ((Object)StringsKt.trim((CharSequence)line2)).toString();
            return line2;
        }
    }
}

