/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.urls.PlainUrl;
import ai.platon.pulsar.common.urls.UrlAware;
import com.google.common.primitives.Ints;
import java.time.Duration;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\t\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lai/platon/pulsar/common/collect/DelayUrl;", "Ljava/util/concurrent/Delayed;", "url", "", "delay", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/time/Duration;)V", "Lai/platon/pulsar/common/urls/UrlAware;", "(Lai/platon/pulsar/common/urls/UrlAware;Ljava/time/Duration;)V", "getDelay", "()Ljava/time/Duration;", "delayExpireAt", "", "getDelayExpireAt", "()J", "startTime", "getStartTime$annotations", "()V", "getStartTime", "getUrl", "()Lai/platon/pulsar/common/urls/UrlAware;", "compareTo", "", "other", "unit", "Ljava/util/concurrent/TimeUnit;", "pulsar-common"})
public class DelayUrl
implements Delayed {
    @NotNull
    private final UrlAware url;
    @NotNull
    private final Duration delay;
    private final long delayExpireAt;

    public DelayUrl(@NotNull UrlAware url, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.url = url;
        this.delay = delay;
        this.delayExpireAt = System.currentTimeMillis() + this.delay.toMillis();
    }

    @NotNull
    public final UrlAware getUrl() {
        return this.url;
    }

    @NotNull
    public final Duration getDelay() {
        return this.delay;
    }

    public final long getDelayExpireAt() {
        return this.delayExpireAt;
    }

    public DelayUrl(@NotNull String url, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this(new PlainUrl(url, null, null, 6, null), delay);
    }

    public final long getStartTime() {
        return this.delayExpireAt;
    }

    @Deprecated(message="Inappropriate name", replaceWith=@ReplaceWith(expression="delayExpires", imports={}))
    public static /* synthetic */ void getStartTime$annotations() {
    }

    @Override
    public int compareTo(@NotNull Delayed other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Ints.saturatedCast((long)(this.delayExpireAt - ((DelayUrl)other).delayExpireAt));
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long diff = this.delayExpireAt - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }
}

