/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.http;

import ai.platon.pulsar.common.http.DefaultHttpStatusCode;
import ai.platon.pulsar.common.http.HttpStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0007H&J\b\u0010\t\u001a\u00020\u0007H&J\b\u0010\n\u001a\u00020\u0007H&J\b\u0010\u000b\u001a\u00020\u0007H&J\b\u0010\f\u001a\u00020\u0007H&J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0000H\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/common/http/HttpStatusCode;", "", "value", "", "getValue", "()I", "is1xxInformational", "", "is2xxSuccessful", "is3xxRedirection", "is4xxClientError", "is5xxServerError", "isError", "isSameCodeAs", "other", "valueOf", "code", "pulsar-common"})
public interface HttpStatusCode {
    public int getValue();

    public boolean is1xxInformational();

    public boolean is2xxSuccessful();

    public boolean is3xxRedirection();

    public boolean is4xxClientError();

    public boolean is5xxServerError();

    public boolean isError();

    public boolean isSameCodeAs(@NotNull HttpStatusCode var1);

    @NotNull
    public HttpStatusCode valueOf(int var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean isSameCodeAs(@NotNull HttpStatusCode $this, @NotNull HttpStatusCode other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return $this.getValue() == other.getValue();
        }

        @NotNull
        public static HttpStatusCode valueOf(@NotNull HttpStatusCode $this, int code) {
            HttpStatus status;
            if (!(100 <= code ? code < 1000 : false)) {
                boolean bl = false;
                String string = "Status code '" + code + "' should be a three-digit positive integer";
                throw new IllegalArgumentException(string.toString());
            }
            HttpStatus httpStatus = status = HttpStatus.Companion.resolve(code);
            return httpStatus != null ? (HttpStatusCode)httpStatus : (HttpStatusCode)new DefaultHttpStatusCode(code);
        }
    }
}

