/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.options;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004J \u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/common/options/OptionUtils;", "", "()V", "OPTION_REGEX", "", "getOPTION_REGEX", "()Ljava/lang/String;", "arity0ToArity1", "args", "search", "findOption", "optionName", "optionNames", "", "translateCommandline", "", "toProcess", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Options.kt\nai/platon/pulsar/common/options/OptionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,116:1\n1855#2,2:117\n107#3:119\n79#3,22:120\n*S KotlinDebug\n*F\n+ 1 Options.kt\nai/platon/pulsar/common/options/OptionUtils\n*L\n20#1:117,2\n107#1:119\n107#1:120,22\n*E\n"})
public final class OptionUtils {
    @NotNull
    public static final OptionUtils INSTANCE = new OptionUtils();
    @NotNull
    private static final String OPTION_REGEX = "\\s+([\\\\.\\-_a-zA-Z0-9]+)\\s?";

    private OptionUtils() {
    }

    @NotNull
    public final String getOPTION_REGEX() {
        return OPTION_REGEX;
    }

    @Nullable
    public final String findOption(@Nullable String args, @NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        String string = args;
        if (string == null) {
            return null;
        }
        String s2 = string;
        Object object = Regex.find$default((Regex)new Regex(optionName + OPTION_REGEX), (CharSequence)s2, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
    }

    @Nullable
    public final String findOption(@Nullable String args, @NotNull Iterable<String> optionNames) {
        Intrinsics.checkNotNullParameter(optionNames, (String)"optionNames");
        if (args == null) {
            return null;
        }
        Iterable<String> $this$forEach$iv = optionNames;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            String option = INSTANCE.findOption(args, it);
            if (option == null) continue;
            return option;
        }
        return null;
    }

    @NotNull
    public final List<String> translateCommandline(@NotNull String toProcess) {
        Intrinsics.checkNotNullParameter((Object)toProcess, (String)"toProcess");
        if (StringsKt.isBlank((CharSequence)toProcess)) {
            return CollectionsKt.emptyList();
        }
        int normal = 0;
        int inQuote = 1;
        int inDoubleQuote = 2;
        int state = normal;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        while (tok.hasMoreTokens()) {
            String nextTok;
            Intrinsics.checkNotNullExpressionValue((Object)tok.nextToken(), (String)"tok.nextToken()");
            int n = state;
            if (n == inQuote) {
                if (Intrinsics.areEqual((Object)"'", (Object)nextTok)) {
                    lastTokenHasBeenQuoted = true;
                    state = normal;
                    continue;
                }
                current.append(nextTok);
                continue;
            }
            if (n == inDoubleQuote) {
                if (Intrinsics.areEqual((Object)"\"", (Object)nextTok)) {
                    lastTokenHasBeenQuoted = true;
                    state = normal;
                    continue;
                }
                current.append(nextTok);
                continue;
            }
            if (Intrinsics.areEqual((Object)"'", (Object)nextTok)) {
                state = inQuote;
            } else if (Intrinsics.areEqual((Object)"\"", (Object)nextTok)) {
                state = inDoubleQuote;
            } else if (Intrinsics.areEqual((Object)" ", (Object)nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || ((CharSequence)current).length() > 0) {
            result.add(current.toString());
        }
        if (state == inQuote || state == inDoubleQuote) {
            throw new RuntimeException("unbalanced quotes in " + toProcess);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String arity0ToArity1(@NotNull String args, @NotNull String search) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        String args0 = args;
        int pos = StringsKt.indexOf$default((CharSequence)args0, (String)search, (int)0, (boolean)false, (int)6, null);
        if (pos != -1) {
            if ((pos += search.length()) == args0.length()) {
                args0 = StringsKt.replace$default((String)args0, (String)search, (String)(search + " true"), (boolean)false, (int)4, null);
            } else {
                String s2;
                void $this$trim$iv;
                String string = args0.substring(pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String string2 = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((s2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).charAt(0) == '-') {
                    args0 = StringsKt.replace$default((String)args0, (String)search, (String)(search + " true"), (boolean)false, (int)4, null);
                }
            }
        }
        return args0;
    }
}

