/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.sql;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0012\u00105\u001a\u00020\u00182\b\u00106\u001a\u0004\u0018\u00010\u0018H\u0002J\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\tH\u0002J\b\u0010;\u001a\u000208H\u0002J\b\u0010<\u001a\u000208H\u0002J\b\u0010=\u001a\u000208H\u0002J\b\u0010>\u001a\u000208H\u0002J\u0010\u0010?\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\tH\u0002J\b\u0010@\u001a\u000208H\u0002J\u0012\u0010A\u001a\u00020\u00182\b\u0010B\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010C\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u001e\u0010+\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010!R\u001e\u0010-\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010!R\u001e\u0010/\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010!R\u001a\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001702X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b3\u00104R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lai/platon/pulsar/common/sql/ResultSetFormatter;", "", "rs", "Ljava/sql/ResultSet;", "asList", "", "withHeader", "textOnly", "maxColumnLength", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/sql/ResultSet;ZZZILjava/lang/StringBuilder;)V", "boxVertical", "", "getBoxVertical", "()C", "setBoxVertical", "(C)V", "getBuffer", "()Ljava/lang/StringBuilder;", "columns", "", "", "fieldSeparator", "getFieldSeparator", "setFieldSeparator", "fieldSeparatorReplace", "getFieldSeparatorReplace", "setFieldSeparatorReplace", "maxRowBuffer", "getMaxRowBuffer", "()I", "setMaxRowBuffer", "(I)V", "meta", "Ljava/sql/ResultSetMetaData;", "kotlin.jvm.PlatformType", "numColumns", "<set-?>", "numFields", "getNumFields", "numNonBlankFields", "getNumNonBlankFields", "numNonNullFields", "getNumNonNullFields", "numRows", "getNumRows", "rows", "Ljava/util/ArrayList;", "getTextOnly$annotations", "()V", "abbreviateTextCell", "cellText", "format", "", "formatCell", "columnIndex", "formatCurrentRow", "formatResultAsList", "formatResultAsTable", "formatRows", "getFloatColumnFormat", "overflow", "sanitize", "value", "toString", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nResultSetFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResultSetFormatter.kt\nai/platon/pulsar/common/sql/ResultSetFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1549#2:211\n1620#2,3:212\n1855#2,2:216\n1549#2:218\n1620#2,3:219\n1855#2:222\n1864#2,3:223\n1856#2:226\n1#3:215\n*S KotlinDebug\n*F\n+ 1 ResultSetFormatter.kt\nai/platon/pulsar/common/sql/ResultSetFormatter\n*L\n36#1:211\n36#1:212,3\n94#1:216,2\n126#1:218\n126#1:219,3\n188#1:222\n189#1:223,3\n188#1:226\n*E\n"})
public final class ResultSetFormatter {
    @NotNull
    private final ResultSet rs;
    private final boolean asList;
    private final boolean withHeader;
    private final boolean textOnly;
    private final int maxColumnLength;
    @NotNull
    private final StringBuilder buffer;
    private final ResultSetMetaData meta;
    private final int numColumns;
    private int numRows;
    private int numNonBlankFields;
    private int numNonNullFields;
    private int numFields;
    private char fieldSeparator;
    private char fieldSeparatorReplace;
    private int maxRowBuffer;
    private char boxVertical;
    @NotNull
    private final ArrayList<List<String>> rows;
    @NotNull
    private final List<String> columns;

    /*
     * WARNING - void declaration
     */
    public ResultSetFormatter(@NotNull ResultSet rs, boolean asList, boolean withHeader, boolean textOnly, int maxColumnLength, @NotNull StringBuilder buffer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.rs = rs;
        this.asList = asList;
        this.withHeader = withHeader;
        this.textOnly = textOnly;
        this.maxColumnLength = maxColumnLength;
        this.buffer = buffer;
        this.meta = this.rs.getMetaData();
        this.numColumns = this.meta.getColumnCount();
        this.fieldSeparator = (char)44;
        this.fieldSeparatorReplace = (char)65292;
        this.maxRowBuffer = 5000;
        this.boxVertical = (char)124;
        this.rows = new ArrayList();
        Iterable iterable = (Iterable)new IntRange(1, this.numColumns);
        ResultSetFormatter resultSetFormatter = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            void it;
            String string2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = string2 = this.meta.getColumnLabel((int)it);
            if (string3 == null) {
                string = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"meta.getColumnLabel(it) ?: \"\"");
                string = string2;
            }
            collection.add(string);
        }
        resultSetFormatter.columns = (List)destination$iv$iv;
    }

    public /* synthetic */ ResultSetFormatter(ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, int n, StringBuilder stringBuilder, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 120;
        }
        if ((n2 & 0x20) != 0) {
            stringBuilder = new StringBuilder();
        }
        this(resultSet, bl, bl2, bl3, n, stringBuilder);
    }

    @Deprecated(message="Not used anymore")
    private static /* synthetic */ void getTextOnly$annotations() {
    }

    @NotNull
    public final StringBuilder getBuffer() {
        return this.buffer;
    }

    public final int getNumRows() {
        return this.numRows;
    }

    public final int getNumNonBlankFields() {
        return this.numNonBlankFields;
    }

    public final int getNumNonNullFields() {
        return this.numNonNullFields;
    }

    public final int getNumFields() {
        return this.numFields;
    }

    public final char getFieldSeparator() {
        return this.fieldSeparator;
    }

    public final void setFieldSeparator(char c) {
        this.fieldSeparator = c;
    }

    public final char getFieldSeparatorReplace() {
        return this.fieldSeparatorReplace;
    }

    public final void setFieldSeparatorReplace(char c) {
        this.fieldSeparatorReplace = c;
    }

    public final int getMaxRowBuffer() {
        return this.maxRowBuffer;
    }

    public final void setMaxRowBuffer(int n) {
        this.maxRowBuffer = n;
    }

    public final char getBoxVertical() {
        return this.boxVertical;
    }

    public final void setBoxVertical(char c) {
        this.boxVertical = c;
    }

    public final void format() {
        try {
            this.rs.beforeFirst();
            if (this.asList) {
                this.formatResultAsList();
            } else {
                this.formatResultAsTable();
            }
        }
        catch (SQLException e) {
            String cfr_ignored_0 = "(Exception)" + e.getMessage();
        }
    }

    @NotNull
    public String toString() {
        if (((CharSequence)this.buffer).length() == 0) {
            this.format();
        }
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void formatResultAsTable() throws SQLException {
        if (this.withHeader) {
            this.rows.add(this.columns);
        }
        int i = 0;
        while (this.rs.next()) {
            if (i++ > 0 && this.rows.isEmpty()) {
                this.buffer.setLength(0);
            }
            this.formatCurrentRow();
            int n = this.numRows;
            this.numRows = n + 1;
            if (n <= this.maxRowBuffer) continue;
            this.overflow();
        }
        this.formatRows();
    }

    private final void overflow() {
        this.formatRows();
        this.buffer.append("\n");
        this.rows.clear();
    }

    private final void formatResultAsList() throws SQLException {
        int i;
        int labelLength = 0;
        Object[] columns = new String[this.numColumns];
        int n = this.numColumns;
        for (i = 0; i < n; ++i) {
            String string;
            String it = string = this.meta.getColumnLabel(i + 1);
            boolean bl = false;
            columns[i] = it;
            String label = string;
            labelLength = RangesKt.coerceAtLeast((int)labelLength, (int)label.length());
        }
        while (this.rs.next()) {
            i = this.numRows;
            this.numRows = i + 1;
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.numColumns - 1);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i2 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (i2 > 0) {
                    this.buffer.append('\n');
                }
                String key = StringUtils.rightPad((String)((String)columns[i2] + ":"), (int)(15 + labelLength));
                String value = this.rs.getString(i2 + 1);
                ++this.numFields;
                if (value != null) {
                    ++this.numNonNullFields;
                    if (!StringsKt.isBlank((CharSequence)value)) {
                        ++this.numNonBlankFields;
                    }
                }
                String cellText = this.abbreviateTextCell(value);
                this.buffer.append(key).append(cellText);
            }
            this.buffer.append("\n");
        }
        if (this.numRows == 0) {
            ArraysKt.joinTo$default((Object[])columns, (Appendable)this.buffer, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
            this.buffer.append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void formatCurrentRow() throws SQLException {
        List list2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(1, this.numColumns);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.abbreviateTextCell(this.formatCell((int)it)));
        }
        List it = list2 = (List)destination$iv$iv;
        boolean bl = false;
        this.rows.add(it);
    }

    private final String abbreviateTextCell(String cellText) {
        String string = StringUtils.abbreviateMiddle((String)this.sanitize(cellText), (String)"...", (int)this.maxColumnLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abbreviateMiddle(sanitiz\u2026, \"...\", maxColumnLength)");
        return string;
    }

    private final String formatCell(int columnIndex) throws SQLException {
        String string;
        switch (this.rs.getMetaData().getColumnType(columnIndex)) {
            case 6: 
            case 7: 
            case 8: {
                String fmt = this.getFloatColumnFormat(columnIndex);
                double value = this.rs.getDouble(columnIndex);
                Object[] objectArray = new Object[]{value};
                String string2 = String.format(fmt, Arrays.copyOf(objectArray, objectArray.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                break;
            }
            case 2003: {
                Object array;
                Array array2 = this.rs.getArray(columnIndex);
                Object object = array = array2 != null ? array2.getArray() : null;
                if (array == null) {
                    string = "null";
                    break;
                }
                if (array instanceof Object[]) {
                    string = ArraysKt.joinToString$default((Object[])((Object[])array), (CharSequence)String.valueOf(this.fieldSeparator), (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(this){
                        final /* synthetic */ ResultSetFormatter this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@Nullable Object it) {
                            return ResultSetFormatter.access$sanitize(this.this$0, String.valueOf(it));
                        }
                    }), (int)24, null);
                    break;
                }
                string = array.toString();
                break;
            }
            default: {
                string = this.sanitize(this.rs.getString(columnIndex));
            }
        }
        return string;
    }

    private final String sanitize(String value) {
        if (value == null) {
            return "(null)";
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\n", (String)"\t", (boolean)false, (int)4, null), (char)this.fieldSeparator, (char)this.fieldSeparatorReplace, (boolean)false, (int)4, null);
    }

    private final String getFloatColumnFormat(int columnIndex) {
        int precision = RangesKt.coerceIn((int)this.rs.getMetaData().getPrecision(columnIndex), (int)6, (int)10);
        int scale = RangesKt.coerceIn((int)this.rs.getMetaData().getScale(columnIndex), (int)2, (int)6);
        return "%" + precision + "." + scale + "f";
    }

    /*
     * WARNING - void declaration
     */
    private final void formatRows() {
        int[] columnSizes = new int[this.numColumns];
        int n = this.numColumns;
        for (int i = 0; i < n; ++i) {
            int max = 0;
            for (List<String> list2 : this.rows) {
                max = RangesKt.coerceAtLeast((int)max, (int)list2.get(i).length());
            }
            if (this.numColumns > 1) {
                max = RangesKt.coerceAtMost((int)this.maxColumnLength, (int)max);
            }
            columnSizes[i] = max;
        }
        Iterable $this$forEach$iv = this.rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list3 = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = list3;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int j = n2;
                boolean bl2 = false;
                if (j > 0) {
                    this.buffer.append(' ').append(this.boxVertical).append(' ');
                }
                this.buffer.append((String)value);
                if (j < this.numColumns - 1) {
                    int n3 = columnSizes[j] - value.length();
                    int n4 = 0;
                    while (n4 < n3) {
                        int it = n4++;
                        boolean bl3 = false;
                        this.buffer.append(' ');
                    }
                }
                if (!(!StringsKt.isBlank((CharSequence)((CharSequence)value)))) continue;
                ++this.numNonBlankFields;
            }
            this.buffer.append("\n");
        }
    }

    public static final /* synthetic */ String access$sanitize(ResultSetFormatter $this, String value) {
        return $this.sanitize(value);
    }
}

