/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.urls.UrlUtils;
import java.net.MalformedURLException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/common/urls/TenantedUrl;", "", "tenantId", "", "url", "", "(ILjava/lang/String;)V", "getTenantId", "()I", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "checkTenant", "", "compareTo", "other", "equals", "", "hashCode", "reverseUrl", "toString", "unreverseUrl", "Companion", "pulsar-common"})
public final class TenantedUrl
implements Comparable<TenantedUrl> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int tenantId;
    @NotNull
    private String url;
    private static final char TENANT_ID_SEPERATOR = (char)45;

    public TenantedUrl(int tenantId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.tenantId = tenantId;
        this.url = url;
    }

    public final int getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final TenantedUrl reverseUrl() {
        this.url = UrlUtils.reverseUrl(this.url);
        return this;
    }

    @NotNull
    public final TenantedUrl unreverseUrl() {
        this.url = UrlUtils.unreverseUrl(this.url);
        return this;
    }

    public final boolean checkTenant(int tenantId) {
        return this.tenantId == tenantId;
    }

    @NotNull
    public String toString() {
        return Companion.combine(this.tenantId, this.url);
    }

    public int hashCode() {
        return this.tenantId + this.url.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other instanceof TenantedUrl && this.tenantId == ((TenantedUrl)other).tenantId && Intrinsics.areEqual((Object)this.url, (Object)((TenantedUrl)other).url);
    }

    @Override
    public int compareTo(@NotNull TenantedUrl other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(other.toString());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/common/urls/TenantedUrl$Companion;", "", "()V", "TENANT_ID_SEPERATOR", "", "getTENANT_ID_SEPERATOR", "()C", "combine", "", "tenantId", "", "untenantedUrl", "isTenanted", "", "url", "of", "Lai/platon/pulsar/common/urls/TenantedUrl;", "split", "stripTenant", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final char getTENANT_ID_SEPERATOR() {
            return TENANT_ID_SEPERATOR;
        }

        public final boolean isTenanted(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ((CharSequence)url).length() > 0 && Character.isDigit(url.charAt(0));
        }

        @NotNull
        public final TenantedUrl of(int tenantId, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new TenantedUrl(tenantId, url);
        }

        @NotNull
        public final TenantedUrl split(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (((CharSequence)url).length() == 0 || !Character.isDigit(url.charAt(0))) {
                return new TenantedUrl(0, url);
            }
            StringBuilder integerBuffer = new StringBuilder();
            int pos = 0;
            char ch = url.charAt(pos);
            while (pos < url.length() && Character.isDigit(ch)) {
                integerBuffer.append(ch);
                ch = url.charAt(++pos);
            }
            if (url.charAt(pos) != this.getTENANT_ID_SEPERATOR()) {
                throw new MalformedURLException("Url starts with numbers");
            }
            int n = Integer.parseInt(integerBuffer.toString());
            String string = url.substring(++pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return new TenantedUrl(n, string);
        }

        @NotNull
        public final String combine(int tenantId, @NotNull String untenantedUrl) {
            Intrinsics.checkNotNullParameter((Object)untenantedUrl, (String)"untenantedUrl");
            Validate.isTrue((!this.isTenanted(untenantedUrl) ? 1 : 0) != 0);
            if (tenantId == 0) {
                return untenantedUrl;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(tenantId);
            buf.append(this.getTENANT_ID_SEPERATOR());
            buf.append(untenantedUrl);
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
            return string;
        }

        @NotNull
        public final String stripTenant(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return this.split(url).getUrl();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

