/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.MessageWriter;
import ai.platon.pulsar.common.MultiSinkWriter;
import ai.platon.pulsar.common.config.ImmutableConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016J\b\u0010 \u001a\u00020\u001eH\u0002J\u0006\u0010!\u001a\u00020\u001eJ\u0016\u0010\"\u001a\n \u0011*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010#\u001a\n \u0011*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u001f\u001a\u00020\u0016J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%2\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007J\u0016\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0007J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lai/platon/pulsar/common/MultiSinkWriter;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_writers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lai/platon/pulsar/common/MessageWriter;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf$annotations", "()V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "reportDir", "getReportDir", "()Ljava/nio/file/Path;", "timeIdent", "", "getTimeIdent", "()Ljava/lang/String;", "writers", "", "getWriters", "()Ljava/util/Map;", "close", "", "filename", "closeIdleWriters", "flush", "getPath", "pathOf", "readAllLines", "", "write", "message", "file", "writeLine", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nMultiSinkWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiSinkWriter.kt\nai/platon/pulsar/common/MultiSinkWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,95:1\n1855#2,2:96\n215#3:98\n216#3:100\n215#3,2:108\n215#3,2:110\n1#4:99\n515#5:101\n500#5,6:102\n*S KotlinDebug\n*F\n+ 1 MultiSinkWriter.kt\nai/platon/pulsar/common/MultiSinkWriter\n*L\n72#1:96,2\n77#1:98\n77#1:100\n86#1:108,2\n87#1:110,2\n85#1:101\n85#1:102,6\n*E\n"})
public class MultiSinkWriter
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<Path, MessageWriter> _writers;
    @NotNull
    private final AtomicBoolean closed;
    private final Path reportDir;

    public MultiSinkWriter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(MultiSinkWriter.class));
        this._writers = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        this.reportDir = AppPaths.INSTANCE.getREPORT_DIR().resolve(this.getTimeIdent());
        Files.createDirectories(this.reportDir, new FileAttribute[0]);
    }

    public /* synthetic */ MultiSinkWriter(ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            immutableConfig = ImmutableConfig.Companion.getUNSAFE();
        }
        this(immutableConfig);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @Deprecated(message="Useless config")
    public static /* synthetic */ void getConf$annotations() {
    }

    private final String getTimeIdent() {
        return DateTimes.INSTANCE.formatNow("MMdd");
    }

    public final Path getReportDir() {
        return this.reportDir;
    }

    @NotNull
    public final Map<Path, MessageWriter> getWriters() {
        return this._writers;
    }

    public final Path getPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.pathOf(filename);
    }

    public final Path pathOf(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.reportDir.resolve(filename);
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list2 = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(path)");
            return list2;
        }
        return CollectionsKt.emptyList();
    }

    public final void write(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(filename)");
        this.write(message, path);
    }

    public final void write(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this._writers.computeIfAbsent(file.toAbsolutePath(), arg_0 -> MultiSinkWriter.write$lambda$0(write.1.INSTANCE, arg_0)).write(message);
        this.closeIdleWriters();
    }

    public final void writeLine(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(filename)");
        this.writeLine(message, path);
    }

    public final void writeLine(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MessageWriter messageWriter = this._writers.computeIfAbsent(file.toAbsolutePath(), arg_0 -> MultiSinkWriter.writeLine$lambda$1(writeLine.writer.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)messageWriter, (String)"_writers.computeIfAbsent\u2026()) { MessageWriter(it) }");
        MessageWriter writer2 = messageWriter;
        writer2.write(message);
        writer2.write("\n");
        this.closeIdleWriters();
    }

    public final void close(@NotNull String filename) {
        block0: {
            MessageWriter writer2;
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Path path = this.getPath(filename);
            MessageWriter messageWriter = writer2 = this._writers.remove(path);
            if (messageWriter == null) break block0;
            messageWriter.close();
        }
    }

    public final void flush() {
        Collection<MessageWriter> collection = this._writers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_writers.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageWriter it = (MessageWriter)element$iv;
            boolean bl = false;
            it.flush();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Map $this$forEach$iv = this._writers;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Object object2 = this;
                try {
                    MultiSinkWriter $this$close_u24lambda_u245_u24lambda_u243 = object2;
                    boolean bl2 = false;
                    ((MessageWriter)it.getValue()).close();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue;
                Object it2 = object = throwable;
                boolean bl3 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it2, null, null, 3, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeIdleWriters() {
        try {
            Map.Entry element$iv;
            Map idleWriters;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this._writers;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!((MessageWriter)it.getValue()).isIdle()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = idleWriters = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry it = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                this._writers.remove(it.getKey());
            }
            $this$forEach$iv = idleWriters;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                Object object2 = this;
                try {
                    MultiSinkWriter $this$closeIdleWriters_u24lambda_u2410_u24lambda_u248 = object2;
                    boolean bl2 = false;
                    ((MessageWriter)it.getValue()).close();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue;
                Object it2 = object = throwable;
                boolean bl3 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it2, null, null, 3, null));
            }
        }
        catch (Exception e) {
            this.logger.warn(ExceptionsKt.stringify$default(e, null, null, 3, null));
        }
    }

    private static final MessageWriter write$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessageWriter)$tmp0.invoke(p0);
    }

    private static final MessageWriter writeLine$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MessageWriter)$tmp0.invoke(p0);
    }

    public MultiSinkWriter() {
        this(null, 1, null);
    }
}

