/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.SParser;
import ai.platon.pulsar.common.config.KConfiguration;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertyResolverExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 b2\u00020\u0001:\u0001bB+\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0096\u0002J\u0019\u0010(\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0096\u0002J\u0016\u0010*\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0005J\u001e\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\"\u001a\u00020\u00032\n\u0010)\u001a\u0006\u0012\u0002\b\u00030,J:\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u0002H-0,\"\u0004\b\u0000\u0010-2\u0006\u0010\"\u001a\u00020\u00032\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u0002H-0,2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0,J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0003J\u0016\u00102\u001a\n \u001c*\u0004\u0018\u000103032\u0006\u00101\u001a\u00020\u0003J\u0016\u00104\u001a\u0002052\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u000205J\u0016\u00106\u001a\n \u001c*\u0004\u0018\u000107072\u0006\u0010\"\u001a\u00020\u0003J\u001e\u00106\u001a\n \u001c*\u0004\u0018\u000107072\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u000207J5\u00108\u001a\n \u001c*\u0004\u0018\u0001H9H9\"\u0010\b\u0000\u00109*\n\u0012\u0004\u0012\u0002H9\u0018\u00010:2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u0002H9\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\u00020=2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020=J\u001e\u0010>\u001a\n \u001c*\u0004\u0018\u00010?0?2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020?J\u0016\u0010@\u001a\u00020A2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020AJ\u0016\u0010B\u001a\n \u001c*\u0004\u0018\u00010C0C2\u0006\u0010\"\u001a\u00020\u0003JN\u0010D\u001aB\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c* \u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0018\u00010F0E2\u0006\u0010\"\u001a\u00020\u0003J\u0016\u0010G\u001a\u00020H2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020HJ\u001e\u0010I\u001a\n \u001c*\u0004\u0018\u00010J0J2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010K\u001a\u00020JJ\u0010\u0010L\u001a\u0004\u0018\u00010J2\u0006\u0010\"\u001a\u00020\u0003J\"\u0010M\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0016\u0010N\u001a\n \u001c*\u0004\u0018\u00010\u00160\u00162\u0006\u00101\u001a\u00020\u0003J2\u0010O\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0018\u00010Q0P2\u0006\u0010\"\u001a\u00020\u0003J7\u0010R\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c*\u0012\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00010\u00030\u00030S0S2\u0006\u0010\"\u001a\u00020\u0003\u00a2\u0006\u0002\u0010TJM\u0010R\u001a(\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c*\u0014\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0018\u00010S0S2\u0006\u0010\"\u001a\u00020\u00032\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u0003\u00a2\u0006\u0002\u0010UJ2\u0010V\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0018\u00010Q0P2\u0006\u0010\"\u001a\u00020\u0003J9\u0010W\u001a(\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003 \u001c*\u0014\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00010\u00030\u0003\u0018\u00010S0S2\u0006\u0010\"\u001a\u00020\u0003\u00a2\u0006\u0002\u0010TJ-\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00030S2\u0006\u0010\"\u001a\u00020\u00032\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030S\"\u00020\u0003\u00a2\u0006\u0002\u0010UJ\u0016\u0010X\u001a\u00020A2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020AJ\u0016\u0010Y\u001a\u00020H2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020HJ&\u0010Z\u001a\u00020[2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\u0010\u0010]\u001a\u00020^2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0006\u0010_\u001a\u00020AJ\b\u0010`\u001a\u00020\u0003H\u0016J\u0006\u0010a\u001a\u00020\nR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u001c\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010!\"\u0004\b$\u0010%R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010!R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lai/platon/pulsar/common/config/AbstractConfiguration;", "", "profile", "", "loadDefaults", "", "resources", "", "(Ljava/lang/String;ZLjava/lang/Iterable;)V", "conf", "Lai/platon/pulsar/common/config/KConfiguration;", "(Lai/platon/pulsar/common/config/KConfiguration;)V", "getConf", "()Lai/platon/pulsar/common/config/KConfiguration;", "environment", "Lorg/springframework/core/env/Environment;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "setEnvironment", "(Lorg/springframework/core/env/Environment;)V", "fullPathResources", "Ljava/util/LinkedHashSet;", "Ljava/net/URL;", "isDistributedFs", "()Z", "isDryRun", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mode", "getMode", "()Ljava/lang/String;", "name", "getName", "setName", "(Ljava/lang/String;)V", "<set-?>", "getProfile", "get", "defaultValue", "getBoolean", "getClass", "Ljava/lang/Class;", "U", "xface", "getConfResourceAsInputStream", "Ljava/io/InputStream;", "resource", "getConfResourceAsReader", "Ljava/io/Reader;", "getDouble", "", "getDuration", "Ljava/time/Duration;", "getEnum", "T", "", "(Ljava/lang/String;Ljava/lang/Enum;)Ljava/lang/Enum;", "getFloat", "", "getInstant", "Ljava/time/Instant;", "getInt", "", "getInts", "", "getKvs", "", "", "getLong", "", "getPath", "Ljava/nio/file/Path;", "elsePath", "getPathOrNull", "getRealResource", "getResource", "getStringCollection", "", "", "getStrings", "", "(Ljava/lang/String;)[Ljava/lang/String;", "(Ljava/lang/String;[Ljava/lang/String;)[Ljava/lang/String;", "getTrimmedStringCollection", "getTrimmedStrings", "getUint", "getUlong", "loadConfResources", "", "extraResources", "p", "Lai/platon/pulsar/common/SParser;", "size", "toString", "unbox", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nAbstractConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractConfiguration.kt\nai/platon/pulsar/common/config/AbstractConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,509:1\n1855#2,2:510\n1855#2,2:512\n1054#2:518\n1603#2,9:519\n1855#2:528\n1856#2:530\n1612#2:531\n11335#3:514\n11670#3,3:515\n1#4:529\n*S KotlinDebug\n*F\n+ 1 AbstractConfiguration.kt\nai/platon/pulsar/common/config/AbstractConfiguration\n*L\n92#1:510,2\n102#1:512,2\n113#1:518\n115#1:519,9\n115#1:528\n115#1:530\n115#1:531\n113#1:514\n113#1:515,3\n115#1:529\n*E\n"})
public abstract class AbstractConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @NotNull
    private final LinkedHashSet<String> resources;
    @NotNull
    private String name;
    @NotNull
    private String profile;
    @NotNull
    private final KConfiguration conf;
    @Nullable
    private Environment environment;
    @NotNull
    private final LinkedHashSet<URL> fullPathResources;
    @NotNull
    public static final String APPLICATION_SPECIFIED_RESOURCES = "pulsar-default.xml,pulsar-site.xml,pulsar-task.xml";
    @NotNull
    private static final LinkedHashSet<String> DEFAULT_RESOURCES = new LinkedHashSet();

    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getMode() {
        return this.isDistributedFs() ? "cluster" : "local";
    }

    @NotNull
    protected final KConfiguration getConf() {
        return this.conf;
    }

    @Nullable
    public final Environment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    public AbstractConfiguration(@NotNull String profile, boolean loadDefaults, @NotNull Iterable<String> resources) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.logger = LoggerFactory.getLogger(AbstractConfiguration.class);
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.fullPathResources = new LinkedHashSet();
        this.conf = new KConfiguration(loadDefaults);
        this.loadConfResources(profile, loadDefaults, resources);
    }

    public /* synthetic */ AbstractConfiguration(String string, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = System.getProperty("legacy.config.profile", "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(CapabilityTy\u2026EGACY_CONFIG_PROFILE, \"\")");
            string = string2;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            iterable = DEFAULT_RESOURCES;
        }
        this(string, bl, iterable);
    }

    public AbstractConfiguration(@NotNull KConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.logger = LoggerFactory.getLogger(AbstractConfiguration.class);
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.fullPathResources = new LinkedHashSet();
        this.conf = new KConfiguration(conf);
    }

    private final void loadConfResources(String profile, boolean loadDefaults, Iterable<String> extraResources) {
        Object it;
        Object element$iv;
        Iterable $this$forEach$iv;
        CollectionsKt.toCollection(extraResources, (Collection)this.resources);
        this.profile = profile;
        if (!loadDefaults) {
            return;
        }
        if (((CharSequence)profile).length() > 0) {
            this.conf.set("legacy.config.profile", profile);
        }
        String specifiedResources = System.getProperty("system.property.specified.resources", APPLICATION_SPECIFIED_RESOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)specifiedResources, (String)"specifiedResources");
        Object object = specifiedResources;
        Regex regex = new Regex(",");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            this.resources.add((String)it);
        }
        for (String name : this.resources) {
            String string = this.getMode();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            URL realResource = this.getRealResource(profile, string, name);
            if (realResource != null) {
                this.fullPathResources.add(realResource);
                continue;
            }
            this.logger.info("Resource not find: " + name);
        }
        $this$forEach$iv = this.fullPathResources;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (URL)element$iv;
            boolean bl = false;
            this.conf.addResource((URL)it);
        }
        this.logger.info(this.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final URL getRealResource(String profile, String mode, String name) {
        void $this$mapNotNullTo$iv$iv;
        Iterator iterator;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String prefix = "config/legacy";
        String suffix = mode + "/" + name;
        String[] stringArray = new String[]{prefix + "/" + suffix, prefix + "/" + profile + "/" + suffix, prefix + "/" + name, prefix + "/" + profile + "/" + name, name};
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            iterator = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"//", (String)"/", (boolean)false, (int)4, null));
        }
        Iterable $this$sortedByDescending$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedByDescending = false;
        List searchPaths = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.length());
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.length()));
            }
        });
        Iterable $this$mapNotNull$iv = searchPaths;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.getResource(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        URL resource = (URL)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        if (resource != null) {
            this.logger.info("Find legacy resource: " + resource);
        }
        return resource;
    }

    public final boolean isDryRun() {
        return this.getBoolean("pulsar.dry.run", false);
    }

    public final boolean isDistributedFs() {
        String fsName = this.get("fs.defaultFS");
        return fsName != null && StringsKt.startsWith$default((String)fsName, (String)"hdfs", (boolean)false, (int)2, null);
    }

    @NotNull
    public final KConfiguration unbox() {
        return this.conf;
    }

    public final int size() {
        return this.conf.size();
    }

    @Nullable
    public String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = System.getProperty(name);
        if (string == null) {
            Environment environment = this.environment;
            string = environment != null ? PropertyResolverExtensionsKt.get((PropertyResolver)((PropertyResolver)environment), (String)name) : null;
            if (string == null) {
                string = this.conf.get(name);
            }
        }
        return string;
    }

    @NotNull
    public String get(@NotNull String name, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public final int getInt(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getInt(defaultValue);
    }

    public final int[] getInts(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getInts();
    }

    public final long getLong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getLong(defaultValue);
    }

    public final float getFloat(@NotNull String name, float defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getFloat(defaultValue);
    }

    public final double getDouble(@NotNull String name, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getDouble(defaultValue);
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getBoolean(defaultValue);
    }

    public final <T extends Enum<T>> T getEnum(@NotNull String name, T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getEnum(defaultValue);
    }

    public final Collection<String> getStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getStringCollection();
    }

    @NotNull
    public final String[] getStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.p(name).getStrings();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public final String[] getStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getStrings(Arrays.copyOf(defaultValue, defaultValue.length));
    }

    public final Collection<String> getTrimmedStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getTrimmedStringCollection();
    }

    public final String[] getTrimmedStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getTrimmedStrings();
    }

    @NotNull
    public final String[] getTrimmedStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String[] stringArray = this.p(name).getTrimmedStrings(Arrays.copyOf(defaultValue, defaultValue.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"p(name).getTrimmedStrings(*defaultValue)");
        return stringArray;
    }

    public final int getUint(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int value = this.getInt(name, defaultValue);
        if (value < 0) {
            value = defaultValue;
        }
        return value;
    }

    public final long getUlong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long value = this.getLong(name, defaultValue);
        if (value < 0L) {
            value = defaultValue;
        }
        return value;
    }

    public final Duration getDuration(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getDuration();
    }

    public final Duration getDuration(@NotNull String name, @NotNull Duration defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getDuration(defaultValue);
    }

    public final Instant getInstant(@NotNull String name, @NotNull Instant defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.p(name).getInstant(defaultValue);
    }

    public final Path getPath(@NotNull String name, @NotNull Path elsePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elsePath, (String)"elsePath");
        return this.p(name).getPath(elsePath);
    }

    @Nullable
    public final Path getPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getPathOrNull();
    }

    public final Map<String, String> getKvs(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getKvs();
    }

    @NotNull
    public final InputStream getConfResourceAsInputStream(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        InputStream inputStream = SParser.wrap(resource).getResourceAsInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"wrap(resource).resourceAsInputStream");
        return inputStream;
    }

    public final Reader getConfResourceAsReader(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return SParser.wrap(resource).getResourceAsReader();
    }

    public final URL getResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return SParser.wrap(resource).getResource();
    }

    @NotNull
    public final Class<?> getClass(@NotNull String name, @NotNull Class<?> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Class<?> clazz = this.p(name).getClass(defaultValue);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"p(name).getClass(defaultValue)");
        return clazz;
    }

    @NotNull
    public final <U> Class<? extends U> getClass(@NotNull String name, @NotNull Class<? extends U> defaultValue, @NotNull Class<U> xface) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(xface, (String)"xface");
        Class<? extends U> clazz = this.p(name).getClass(defaultValue, xface);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"p(name).getClass(defaultValue, xface)");
        return clazz;
    }

    private final SParser p(String name) {
        return new SParser(this.get(name));
    }

    @NotNull
    public String toString() {
        return "profile: <" + this.profile + "> | " + this.conf;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/common/config/AbstractConfiguration$Companion;", "", "()V", "APPLICATION_SPECIFIED_RESOURCES", "", "DEFAULT_RESOURCES", "Ljava/util/LinkedHashSet;", "getDEFAULT_RESOURCES", "()Ljava/util/LinkedHashSet;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinkedHashSet<String> getDEFAULT_RESOURCES() {
            return DEFAULT_RESOURCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

