/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.proxy.ProxyEntry2;
import ai.platon.pulsar.common.urls.UrlUtils;
import com.google.common.collect.ConcurrentHashMultiset;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u00b1\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0006\u00b0\u0001\u00b1\u0001\u00b2\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0007\u0010\u0097\u0001\u001a\u000207J\u0013\u0010\u0098\u0001\u001a\u00020\u00052\u0007\u0010\u0099\u0001\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u009a\u0001\u001a\u0002072\n\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u009b\u0001H\u0096\u0002J\u0007\u0010\u009c\u0001\u001a\u00020\u0003J\t\u0010\u009d\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u009e\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u009f\u0001\u001a\u00020\u0005H\u0016J\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001J\b\u0010\u00a2\u0001\u001a\u00030\u00a1\u0001J\u0007\u0010\u00a3\u0001\u001a\u00020\u0003J\b\u0010\u00a4\u0001\u001a\u00030\u00a1\u0001J\b\u0010\u00a5\u0001\u001a\u00030\u00a1\u0001J\u0007\u0010\u00a6\u0001\u001a\u000207J\u001b\u0010\u00a6\u0001\u001a\u0002072\u0007\u0010\u00a7\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u00a8\u0001\u001a\u00020\"J\t\u0010\u00a9\u0001\u001a\u00020\u0003H\u0016J\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001J\u0010\u0010\u00ac\u0001\u001a\u0002072\u0007\u0010\u00ad\u0001\u001a\u00020\"J\u0010\u0010\u00ae\u0001\u001a\u0002072\u0007\u0010\u00af\u0001\u001a\u00020\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0019\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010 \"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0019\u00100\u001a\n #*\u0004\u0018\u00010\"0\"8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010%R\"\u00102\u001a\n #*\u0004\u0018\u00010\"0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010%\"\u0004\b4\u00105R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b6\u00108R\u0011\u00109\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b9\u00108R\u0011\u0010:\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u0011\u0010;\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b;\u00108R\u0011\u0010<\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b<\u00108R\u0011\u0010=\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b=\u00108R\u0011\u0010>\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b>\u00108R\u0011\u0010?\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b?\u00108R\u001a\u0010@\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00108\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bC\u00108R\"\u0010D\u001a\n #*\u0004\u0018\u00010\u00100\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0012\"\u0004\bF\u0010\u0014R\u001c\u0010G\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010 \"\u0004\bI\u0010(R\u0011\u0010J\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bK\u0010 R,\u0010L\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u0002070MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u0011\u0010W\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010VR\u0011\u0010Y\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010VR\u0011\u0010[\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010VR\u0011\u0010]\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010VR\u001a\u0010_\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010 \"\u0004\ba\u0010(R\u0011\u0010b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bc\u0010 R%\u0010d\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010g0f0e8F\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010 \"\u0004\bk\u0010(R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010-\"\u0004\bm\u0010/R\u0011\u0010n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bo\u0010 R\u0011\u0010p\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bq\u0010 R\u001a\u0010r\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u00108\"\u0004\bt\u0010BR\u001c\u0010u\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010 \"\u0004\bw\u0010(R\u0011\u0010x\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\by\u0010 R5\u0010z\u001a&\u0012\f\u0012\n #*\u0004\u0018\u00010\u00030\u0003 #*\u0012\u0012\f\u0012\n #*\u0004\u0018\u00010\u00030\u0003\u0018\u00010{0{\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010}R\u0019\u0010~\u001a\n #*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\u0012R%\u0010\u0080\u0001\u001a\u0013\u0012\u000e\u0012\f #*\u0005\u0018\u00010\u0082\u00010\u0082\u00010\u0081\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001R\u0015\u0010\u0085\u0001\u001a\u00030\u0086\u00018F\u00a2\u0006\b\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R$\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020\u00190eX\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0005\b\u008a\u0001\u0010i\"\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001b\u0010\u008d\u0001\u001a\n #*\u0004\u0018\u00010\u00100\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u008e\u0001\u0010\u0012R\u0015\u0010\u008f\u0001\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0007\u001a\u0005\b\u0090\u0001\u0010%R\u001e\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0091\u0001\u0010\u0092\u0001\"\u0006\b\u0093\u0001\u0010\u0094\u0001R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0095\u0001\u0010 \"\u0005\b\u0096\u0001\u0010(\u00a8\u0006\u00b3\u0001"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry2;", "", "host", "", "port", "", "username", "password", "type", "Ljava/net/Proxy$Type;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/net/Proxy$Type;)V", "accumResponseMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "getAccumResponseMillis", "()Ljava/util/concurrent/atomic/AtomicLong;", "availableTime", "Ljava/time/Instant;", "getAvailableTime", "()Ljava/time/Instant;", "setAvailableTime", "(Ljava/time/Instant;)V", "declaredTTL", "getDeclaredTTL", "setDeclaredTTL", "defaultTestUrl", "Ljava/net/URL;", "getDefaultTestUrl", "()Ljava/net/URL;", "setDefaultTestUrl", "(Ljava/net/URL;)V", "display", "getDisplay", "()Ljava/lang/String;", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "getHost", "setHost", "(Ljava/lang/String;)V", "hostPort", "getHostPort", "id", "getId", "()I", "setId", "(I)V", "idleTime", "getIdleTime", "idleTimeout", "getIdleTimeout", "setIdleTimeout", "(Ljava/time/Duration;)V", "isBanned", "", "()Z", "isExpired", "isFailed", "isFree", "isGone", "isIdle", "isReady", "isRetired", "isTestIp", "setTestIp", "(Z)V", "isWorking", "lastActiveTime", "getLastActiveTime", "setLastActiveTime", "lastTarget", "getLastTarget", "setLastTarget", "metadata", "getMetadata", "networkTester", "Lkotlin/Function2;", "Ljava/net/Proxy;", "getNetworkTester", "()Lkotlin/jvm/functions/Function2;", "setNetworkTester", "(Lkotlin/jvm/functions/Function2;)V", "numConnectionLosses", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumConnectionLosses", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numFailedPages", "getNumFailedPages", "numRunningTasks", "getNumRunningTasks", "numSuccessPages", "getNumSuccessPages", "numTests", "getNumTests", "outIp", "getOutIp", "setOutIp", "outSegment", "getOutSegment", "params", "", "Lkotlin/Pair;", "Ljava/io/Serializable;", "getParams", "()Ljava/util/List;", "getPassword", "setPassword", "getPort", "setPort", "protocol", "getProtocol", "readableState", "getReadableState", "rotatable", "getRotatable", "setRotatable", "rotateURL", "getRotateURL", "setRotateURL", "segment", "getSegment", "servedDomains", "Lcom/google/common/collect/ConcurrentHashMultiset;", "getServedDomains", "()Lcom/google/common/collect/ConcurrentHashMultiset;", "startTime", "getStartTime", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyEntry2$Status;", "getStatus", "()Ljava/util/concurrent/atomic/AtomicReference;", "testSpeed", "", "getTestSpeed", "()D", "testUrls", "getTestUrls", "setTestUrls", "(Ljava/util/List;)V", "ttl", "getTtl", "ttlDuration", "getTtlDuration", "getType", "()Ljava/net/Proxy$Type;", "setType", "(Ljava/net/Proxy$Type;)V", "getUsername", "setUsername", "canConnect", "compareTo", "other", "equals", "", "format", "formatDisplay", "formatMetadata", "hashCode", "refresh", "", "retire", "serialize", "setFree", "startWork", "test", "target", "timeout", "toString", "toURI", "Ljava/net/URI;", "willExpireAfter", "duration", "willExpireAt", "instant", "BanState", "Companion", "Status", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nProxyEntry2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyEntry2.kt\nai/platon/pulsar/common/proxy/ProxyEntry2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1#2:357\n1#2:368\n766#3:358\n857#3,2:359\n1855#3,2:361\n766#3:363\n857#3,2:364\n1611#3:366\n1855#3:367\n1856#3:369\n1612#3:370\n*S KotlinDebug\n*F\n+ 1 ProxyEntry2.kt\nai/platon/pulsar/common/proxy/ProxyEntry2\n*L\n316#1:368\n138#1:358\n138#1:359,2\n232#1:361,2\n288#1:363\n288#1:364,2\n316#1:366\n316#1:367\n316#1:369\n316#1:370\n*E\n"})
public class ProxyEntry2
implements Comparable<ProxyEntry2> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private String host;
    private int port;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @NotNull
    private Proxy.Type type;
    private int id;
    @NotNull
    private String outIp;
    @Nullable
    private Instant declaredTTL;
    private boolean rotatable;
    @Nullable
    private String rotateURL;
    @Nullable
    private String lastTarget;
    @NotNull
    private List<URL> testUrls;
    @NotNull
    private URL defaultTestUrl;
    private boolean isTestIp;
    private final Instant startTime;
    @NotNull
    private Function2<? super URL, ? super Proxy, Boolean> networkTester;
    @NotNull
    private final AtomicInteger numTests;
    @NotNull
    private final AtomicInteger numConnectionLosses;
    @NotNull
    private final AtomicLong accumResponseMillis;
    @NotNull
    private Instant availableTime;
    @NotNull
    private final AtomicInteger numFailedPages;
    @NotNull
    private final AtomicInteger numSuccessPages;
    private final ConcurrentHashMultiset<String> servedDomains;
    @NotNull
    private final AtomicReference<Status> status;
    @NotNull
    private final AtomicInteger numRunningTasks;
    private Instant lastActiveTime;
    private Duration idleTimeout;
    private static final Logger log;
    @NotNull
    private static final AtomicInteger instanceSequence;
    @NotNull
    private static final String META_DELIMITER = " ";
    private static final Duration PROXY_EXPIRED;
    private static final Duration MISSING_PROXY_DEAD_TIME;
    private static final int DEFAULT_PROXY_SERVER_PORT = 80;
    @NotNull
    public static final String PROXY_TEST_WEB_SITES_FILE = "proxy.test.web.sites.txt";
    @NotNull
    private static final URL DEFAULT_TEST_URL;
    @NotNull
    private static final List<URL> TEST_URLS;

    public ProxyEntry2(@NotNull String host, int port, @Nullable String username, @Nullable String password, @NotNull Proxy.Type type) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.type = type;
        this.id = instanceSequence.incrementAndGet();
        this.outIp = "";
        this.testUrls = CollectionsKt.toList((Iterable)TEST_URLS);
        this.defaultTestUrl = DEFAULT_TEST_URL;
        this.startTime = Instant.now();
        this.networkTester = networkTester.1.INSTANCE;
        this.numTests = new AtomicInteger();
        this.numConnectionLosses = new AtomicInteger();
        this.accumResponseMillis = new AtomicLong();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.availableTime = instant;
        this.numFailedPages = new AtomicInteger();
        this.numSuccessPages = new AtomicInteger();
        this.servedDomains = ConcurrentHashMultiset.create();
        this.status = new AtomicReference<Status>(Status.FREE);
        this.numRunningTasks = new AtomicInteger();
        this.lastActiveTime = Instant.now();
        this.idleTimeout = Duration.ofMinutes(10L);
    }

    public /* synthetic */ ProxyEntry2(String string, int n, String string2, String string3, Proxy.Type type, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            type = Proxy.Type.HTTP;
        }
        this(string, n, string2, string3, type);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(@Nullable String string) {
        this.username = string;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable String string) {
        this.password = string;
    }

    @NotNull
    public final Proxy.Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Proxy.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    @NotNull
    public final String getOutIp() {
        return this.outIp;
    }

    public final void setOutIp(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outIp = string;
    }

    @Nullable
    public final Instant getDeclaredTTL() {
        return this.declaredTTL;
    }

    public final void setDeclaredTTL(@Nullable Instant instant) {
        this.declaredTTL = instant;
    }

    public final boolean getRotatable() {
        return this.rotatable;
    }

    public final void setRotatable(boolean bl) {
        this.rotatable = bl;
    }

    @Nullable
    public final String getRotateURL() {
        return this.rotateURL;
    }

    public final void setRotateURL(@Nullable String string) {
        this.rotateURL = string;
    }

    @Nullable
    public final String getLastTarget() {
        return this.lastTarget;
    }

    public final void setLastTarget(@Nullable String string) {
        this.lastTarget = string;
    }

    @NotNull
    public final List<URL> getTestUrls() {
        return this.testUrls;
    }

    public final void setTestUrls(@NotNull List<URL> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.testUrls = list2;
    }

    @NotNull
    public final URL getDefaultTestUrl() {
        return this.defaultTestUrl;
    }

    public final void setDefaultTestUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.defaultTestUrl = uRL;
    }

    public final boolean isTestIp() {
        return this.isTestIp;
    }

    public final void setTestIp(boolean bl) {
        this.isTestIp = bl;
    }

    @NotNull
    public final String getProtocol() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                string = "http";
                break;
            }
            case 2: {
                string = "socks";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public final String getHostPort() {
        return this.host + ":" + this.port;
    }

    @NotNull
    public final String getSegment() {
        return StringsKt.substringBeforeLast$default((String)this.host, (String)".", null, (int)2, null);
    }

    @NotNull
    public final String getOutSegment() {
        return StringsKt.substringBeforeLast$default((String)this.outIp, (String)".", null, (int)2, null);
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    @NotNull
    public final String getDisplay() {
        return this.formatDisplay();
    }

    @NotNull
    public final String getMetadata() {
        return this.formatMetadata();
    }

    @NotNull
    public final Function2<URL, Proxy, Boolean> getNetworkTester() {
        return this.networkTester;
    }

    public final void setNetworkTester(@NotNull Function2<? super URL, ? super Proxy, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.networkTester = function2;
    }

    @NotNull
    public final AtomicInteger getNumTests() {
        return this.numTests;
    }

    @NotNull
    public final AtomicInteger getNumConnectionLosses() {
        return this.numConnectionLosses;
    }

    @NotNull
    public final AtomicLong getAccumResponseMillis() {
        return this.accumResponseMillis;
    }

    @NotNull
    public final Instant getAvailableTime() {
        return this.availableTime;
    }

    public final void setAvailableTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.availableTime = instant;
    }

    @NotNull
    public final AtomicInteger getNumFailedPages() {
        return this.numFailedPages;
    }

    @NotNull
    public final AtomicInteger getNumSuccessPages() {
        return this.numSuccessPages;
    }

    public final ConcurrentHashMultiset<String> getServedDomains() {
        return this.servedDomains;
    }

    @NotNull
    public final AtomicReference<Status> getStatus() {
        return this.status;
    }

    public final double getTestSpeed() {
        return (double)(this.accumResponseMillis.get() / (long)RangesKt.coerceAtLeast((int)this.numTests.get(), (int)1)) / 1000.0;
    }

    public final Instant getTtl() {
        Instant instant = this.declaredTTL;
        if (instant == null) {
            instant = this.availableTime.plus(PROXY_EXPIRED);
        }
        return instant;
    }

    @Nullable
    public final Duration getTtlDuration() {
        Duration duration;
        Duration it = duration = Duration.between(Instant.now(), this.getTtl());
        boolean bl = false;
        return !it.isNegative() ? duration : null;
    }

    public final boolean isExpired() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.willExpireAt(instant);
    }

    public final boolean isRetired() {
        return this.status.get() == Status.RETIRED;
    }

    public final boolean isFree() {
        return this.status.get() == Status.FREE;
    }

    public final boolean isWorking() {
        return this.status.get() == Status.WORKING;
    }

    public final boolean isBanned() {
        return this.isRetired() && !this.isExpired();
    }

    public final boolean isFailed() {
        return this.numConnectionLosses.get() >= 3;
    }

    public final boolean isGone() {
        return this.isRetired() || this.isFailed();
    }

    @NotNull
    public final AtomicInteger getNumRunningTasks() {
        return this.numRunningTasks;
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(Duration duration) {
        this.idleTimeout = duration;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.numRunningTasks.get() == 0 && this.getIdleTime().compareTo(this.idleTimeout) > 0;
    }

    public final boolean isReady() {
        return !this.isGone() && !this.isExpired() && !this.isRetired() && !this.isBanned();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getReadableState() {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"retired", (Object)this.isRetired()), TuplesKt.to((Object)"idle", (Object)this.isIdle()), TuplesKt.to((Object)"ready", (Object)this.isReady())};
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)META_DELIMITER, null, null, (int)0, null, (Function1)readableState.2.INSTANCE, (int)30, null);
    }

    @NotNull
    public final List<Pair<String, Serializable>> getParams() {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"ttl", (Object)this.declaredTTL), TuplesKt.to((Object)"at", (Object)this.availableTime), TuplesKt.to((Object)"st", this.status), TuplesKt.to((Object)"pg", (Object)this.numSuccessPages), TuplesKt.to((Object)"fpg", (Object)this.numFailedPages)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final URI toURI() {
        return new URI(this.getProtocol(), this.username + ":" + this.password, this.host, this.port, null, null, null);
    }

    public final boolean willExpireAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.getTtl().compareTo(instant) < 0;
    }

    public final boolean willExpireAfter(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return this.getTtl().compareTo(Instant.now().plus(duration)) < 0;
    }

    public final void setFree() {
        this.status.set(Status.FREE);
    }

    public final void startWork() {
        this.status.set(Status.WORKING);
    }

    public final void retire() {
        this.status.set(Status.RETIRED);
    }

    public final void refresh() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.lastActiveTime = this.availableTime = instant;
    }

    public final boolean canConnect() {
        return NetUtil.testTcpNetwork(this.host, this.port);
    }

    public final boolean test() {
        URL target = this.lastTarget != null ? new URL(this.lastTarget) : (URL)CollectionsKt.random((Collection)this.testUrls, (Random)((Random)Random.Default));
        boolean available = ProxyEntry2.test$default(this, target, null, 2, null);
        if (!(available || this.isGone() || Intrinsics.areEqual((Object)target, (Object)this.defaultTestUrl))) {
            available = ProxyEntry2.test$default(this, this.defaultTestUrl, null, 2, null);
            if (available) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Target unreachable via {} | {} | {}", objectArray);
            } else if (!this.isGone()) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Proxy connection lost {} | {} | {}", objectArray);
            }
        }
        return available;
    }

    public final boolean test(@NotNull URL target, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        boolean available = NetUtil.testTcpNetwork(this.host, this.port, timeout);
        if (available) {
            InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            long start2 = System.currentTimeMillis();
            available = (Boolean)this.networkTester.invoke((Object)target, (Object)proxy);
            long end = System.currentTimeMillis();
            this.numTests.incrementAndGet();
            this.accumResponseMillis.addAndGet(end - start2);
        }
        if (!available) {
            this.numConnectionLosses.incrementAndGet();
            if (this.isGone()) {
                log.warn("Proxy is gone after {} tests | {}", (Object)this.numTests, (Object)this);
            } else {
                log.info("Proxy is not available | " + this);
            }
        } else {
            this.numConnectionLosses.set(0);
            this.refresh();
        }
        return available;
    }

    public static /* synthetic */ boolean test$default(ProxyEntry2 proxyEntry2, URL uRL, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: test");
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(5)");
            duration = duration2;
        }
        return proxyEntry2.test(uRL, duration);
    }

    @NotNull
    public final String serialize() {
        URIBuilder uriBuilder = new URIBuilder(this.toURI());
        Iterable $this$forEach$iv = this.getParams();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            uriBuilder.addParameter((String)it.getFirst(), String.valueOf(it.getSecond()));
        }
        String string = uriBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.toString()");
        return string;
    }

    @NotNull
    public final String format() {
        return this.serialize();
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.getHostPort().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ProxyEntry2 && ((ProxyEntry2)other).type == this.type && Intrinsics.areEqual((Object)((ProxyEntry2)other).host, (Object)this.host) && ((ProxyEntry2)other).port == this.port && Intrinsics.areEqual((Object)((ProxyEntry2)other).username, (Object)this.username) && Intrinsics.areEqual((Object)((ProxyEntry2)other).password, (Object)this.password) && Intrinsics.areEqual((Object)((ProxyEntry2)other).outIp, (Object)this.outIp);
    }

    @NotNull
    public String toString() {
        return this.getDisplay() + META_DELIMITER + this.getMetadata();
    }

    @Override
    public int compareTo(@NotNull ProxyEntry2 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int c = this.outIp.compareTo(other.outIp);
        if (c == 0) {
            c = this.getHostPort().compareTo(other.getHostPort());
        }
        return c;
    }

    private final String formatDisplay() {
        String ban = this.isBanned() ? "[banned] " : "";
        Object object = this.getTtlDuration();
        if (object == null || (object = ((Duration)object).truncatedTo(ChronoUnit.SECONDS)) == null || (object = DateTimesKt.readable((Duration)object)) == null) {
            object = "0s";
        }
        Object ttlStr = object;
        return ban + "[" + this.getHostPort() + " => " + this.outIp + "](" + this.numFailedPages + "/" + this.numSuccessPages + "/" + (String)ttlStr + ")[" + this.getReadableState() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private final String formatMetadata() {
        void $this$filterTo$iv$iv;
        int nPages = this.numSuccessPages.get() + this.numFailedPages.get();
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"st", (Object)this.status.get().ordinal()), TuplesKt.to((Object)"pg", (Object)nPages), TuplesKt.to((Object)"fpg", (Object)this.numFailedPages.get()), TuplesKt.to((Object)"tt", (Object)this.numTests.get()), TuplesKt.to((Object)"ftt", (Object)this.numConnectionLosses.get())};
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object s2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        if (this.getTestSpeed() > 0.0) {
            s2 = (String)s2 + ", spd:" + this.getTestSpeed();
        }
        return s2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapNotNullTo$iv;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ProxyEntry2.class);
        instanceSequence = new AtomicInteger();
        PROXY_EXPIRED = Duration.ofSeconds(120L);
        MISSING_PROXY_DEAD_TIME = Duration.ofHours(1L);
        DEFAULT_TEST_URL = new URL("https://www.baidu.com");
        TEST_URLS = new ArrayList();
        Iterable iterable = ResourceLoader.INSTANCE.readAllLines(PROXY_TEST_WEB_SITES_FILE);
        Collection destination$iv = TEST_URLS;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (UrlUtils.getURLOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry2$BanState;", "", "(Ljava/lang/String;I)V", "isBanned", "", "()Z", "isOK", "OK", "SEGMENT", "HOST", "OTHER", "pulsar-common"})
    public static final class BanState
    extends Enum<BanState> {
        public static final /* enum */ BanState OK = new BanState();
        public static final /* enum */ BanState SEGMENT = new BanState();
        public static final /* enum */ BanState HOST = new BanState();
        public static final /* enum */ BanState OTHER = new BanState();
        private static final /* synthetic */ BanState[] $VALUES;

        public final boolean isOK() {
            return this == OK;
        }

        public final boolean isBanned() {
            return !this.isOK();
        }

        public static BanState[] values() {
            return (BanState[])$VALUES.clone();
        }

        public static BanState valueOf(String value) {
            return Enum.valueOf(BanState.class, value);
        }

        static {
            $VALUES = banStateArray = new BanState[]{BanState.OK, BanState.SEGMENT, BanState.HOST, BanState.OTHER};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry2$Companion;", "", "()V", "DEFAULT_PROXY_SERVER_PORT", "", "DEFAULT_TEST_URL", "Ljava/net/URL;", "getDEFAULT_TEST_URL", "()Ljava/net/URL;", "META_DELIMITER", "", "MISSING_PROXY_DEAD_TIME", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "PROXY_EXPIRED", "PROXY_TEST_WEB_SITES_FILE", "TEST_URLS", "", "getTEST_URLS", "()Ljava/util/List;", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "log", "Lorg/slf4j/Logger;", "deserialize", "Lai/platon/pulsar/common/proxy/ProxyEntry2;", "str", "parse", "pulsar-common"})
    @SourceDebugExtension(value={"SMAP\nProxyEntry2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyEntry2.kt\nai/platon/pulsar/common/proxy/ProxyEntry2$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1#2:357\n1549#3:358\n1620#3,3:359\n766#3:362\n857#3,2:363\n1179#3,2:365\n1253#3,4:367\n*S KotlinDebug\n*F\n+ 1 ProxyEntry2.kt\nai/platon/pulsar/common/proxy/ProxyEntry2$Companion\n*L\n343#1:358\n343#1:359,3\n344#1:362\n344#1:363,2\n344#1:365,2\n344#1:367,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL getDEFAULT_TEST_URL() {
            return DEFAULT_TEST_URL;
        }

        @NotNull
        public final List<URL> getTEST_URLS() {
            return TEST_URLS;
        }

        @Nullable
        public final ProxyEntry2 parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return this.deserialize(str);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final ProxyEntry2 deserialize(@NotNull String str) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List it;
            String[] stringArray;
            void $this$mapTo$iv$iv;
            Proxy.Type type;
            Object $this$deserialize_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Object object = this;
            try {
                $this$deserialize_u24lambda_u240 = object;
                boolean bl = false;
                $this$deserialize_u24lambda_u240 = Result.constructor-impl((Object)URI.create(str));
            }
            catch (Throwable bl) {
                $this$deserialize_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$deserialize_u24lambda_u240;
            URI uRI = (URI)(Result.isFailure-impl((Object)object) ? null : object);
            if (uRI == null) {
                return null;
            }
            URI uri = uRI;
            String username = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String string = uri.getUserInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.userInfo");
                username = StringsKt.substringBefore$default((String)string, (String)":", null, (int)2, null);
                String string2 = uri.getUserInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.userInfo");
                password = StringsKt.substringAfter$default((String)string2, (String)":", null, (int)2, null);
            }
            if ((bl = uri.getScheme()) == null) return null;
            int n = -1;
            switch (bl.hashCode()) {
                case 109610287: {
                    if (bl.equals("socks")) {
                        n = 1;
                    }
                    break;
                }
                case 3213448: {
                    if (bl.equals("http")) {
                        n = 2;
                    }
                    break;
                }
                case 99617003: {
                    if (bl.equals("https")) {
                        n = 2;
                    }
                    break;
                }
                case -897048347: {
                    if (bl.equals("socks4")) {
                        n = 1;
                    }
                    break;
                }
                case -897048346: {
                    if (bl.equals("socks5")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    type = Proxy.Type.HTTP;
                    break;
                }
                case 1: {
                    type = Proxy.Type.SOCKS;
                    break;
                }
                default: {
                    return null;
                }
            }
            Proxy.Type type2 = type;
            String string = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.host");
            ProxyEntry2 proxyEntry = new ProxyEntry2(string, uri.getPort(), username, password, type2);
            String string3 = uri.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"uri.query");
            String[] stringArray2 = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string3, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                stringArray = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (List)element$iv$iv;
                boolean bl = false;
                if (!(it.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                List it2 = (List)element$iv$iv;
                boolean bl = false;
                stringArray = TuplesKt.to(it2.get(0), it2.get(1));
                map.put(stringArray.getFirst(), stringArray.getSecond());
            }
            Map params = destination$iv$iv2;
            String string5 = (String)params.get("ttl");
            if (string5 != null) {
                String it3 = string5;
                boolean bl = false;
                proxyEntry.setDeclaredTTL(Instant.parse(it3));
            }
            String string6 = (String)params.get("at");
            if (string6 != null) {
                String it4 = string6;
                boolean bl = false;
                Instant instant = Instant.parse(it4);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(it)");
                proxyEntry.setAvailableTime(instant);
            }
            String string7 = (String)params.get("st");
            if (string7 != null) {
                String it5 = string7;
                boolean bl = false;
                proxyEntry.getStatus().set(Status.valueOf(it5));
            }
            String string8 = (String)params.get("pg");
            if (string8 != null) {
                String it6 = string8;
                boolean bl = false;
                proxyEntry.getNumSuccessPages().set(Integer.parseInt(it6));
            }
            String string9 = (String)params.get("fpg");
            if (string9 == null) return proxyEntry;
            String it7 = string9;
            boolean bl = false;
            proxyEntry.getNumFailedPages().set(Integer.parseInt(it7));
            return proxyEntry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry2$Status;", "", "(Ljava/lang/String;I)V", "FREE", "WORKING", "RETIRED", "EXPIRED", "GONE", "pulsar-common"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FREE = new Status();
        public static final /* enum */ Status WORKING = new Status();
        public static final /* enum */ Status RETIRED = new Status();
        public static final /* enum */ Status EXPIRED = new Status();
        public static final /* enum */ Status GONE = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FREE, Status.WORKING, Status.RETIRED, Status.EXPIRED, Status.GONE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

