/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.config.ImmutableConfig;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.function.Function;

public class ObjectCache {
    private static final WeakHashMap<ImmutableConfig, ObjectCache> CACHE = new WeakHashMap();
    private final HashMap<String, Object> objectMap = new HashMap();

    private ObjectCache() {
    }

    public static ObjectCache get(ImmutableConfig conf) {
        ObjectCache objectCache = CACHE.get(conf);
        if (objectCache == null) {
            objectCache = new ObjectCache();
            CACHE.put(conf, objectCache);
        }
        return objectCache;
    }

    public boolean hasBean(String key) {
        return this.objectMap.get(key) != null;
    }

    public Object getBean(String key) {
        return this.objectMap.get(key);
    }

    public <T> T getBean(String key, T defaultValue) {
        Object obj = this.objectMap.get(key);
        if (obj == null) {
            return defaultValue;
        }
        return (T)obj;
    }

    public <T> T getBean(Class<T> clazz) {
        return (T)this.objectMap.get(clazz.getName());
    }

    public <T> T computeIfAbsent(Class<T> clazz, Function<Class<T>, T> mappingFunction) {
        T value = this.getBean(clazz);
        if (value == null) {
            value = mappingFunction.apply(clazz);
            this.put(value);
        }
        return value;
    }

    public void put(String key, Object value) {
        this.objectMap.put(key, value);
    }

    public void put(Object obj) {
        this.objectMap.put(obj.getClass().getName(), obj);
    }
}

