/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.options.OptionUtils;
import ai.platon.pulsar.common.urls.ComparableUrlAware;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u00107\u001a\u00020\b2\u0006\u00108\u001a\u000209H\u0096\u0002J\u0013\u0010:\u001a\u00020\u001d2\b\u00108\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\bH\u0016J\b\u0010=\u001a\u00020\u0003H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000b\"\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u001a\u0010#\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000b\"\u0004\b%\u0010\rR\u001a\u0010&\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010(\"\u0004\b,\u0010*R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000b\"\u0004\b.\u0010\rR\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u0004\u0018\u0001008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000b\"\u0004\b6\u0010\r\u00a8\u0006>"}, d2={"Lai/platon/pulsar/common/urls/AbstractUrl;", "Lai/platon/pulsar/common/urls/ComparableUrlAware;", "url", "", "args", "referrer", "href", "priority", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "configuredUrl", "getConfiguredUrl", "country", "getCountry", "setCountry", "deadline", "Ljava/time/Instant;", "getDeadline", "()Ljava/time/Instant;", "district", "getDistrict", "setDistrict", "getHref", "setHref", "isNil", "", "()Z", "isPersistable", "isStandard", "label", "getLabel", "lang", "getLang", "setLang", "nMaxRetry", "getNMaxRetry", "()I", "setNMaxRetry", "(I)V", "getPriority", "setPriority", "getReferrer", "setReferrer", "toURL", "Ljava/net/URL;", "getToURL", "()Ljava/net/URL;", "toURLOrNull", "getToURLOrNull", "getUrl", "setUrl", "compareTo", "other", "Lai/platon/pulsar/common/urls/UrlAware;", "equals", "", "hashCode", "toString", "pulsar-common"})
public abstract class AbstractUrl
implements ComparableUrlAware {
    @NotNull
    private String url;
    @Nullable
    private String args;
    @Nullable
    private String referrer;
    @Nullable
    private String href;
    private int priority;
    private final boolean isPersistable;
    @NotNull
    private String lang;
    @NotNull
    private String country;
    @NotNull
    private String district;
    private int nMaxRetry;

    public AbstractUrl(@NotNull String url, @Nullable String args, @Nullable String referrer, @Nullable String href, int priority) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.args = args;
        this.referrer = referrer;
        this.href = href;
        this.priority = priority;
        this.isPersistable = true;
        this.lang = "*";
        this.country = "*";
        this.district = "*";
        this.nMaxRetry = 3;
    }

    public /* synthetic */ AbstractUrl(String string, String string2, String string3, String string4, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            string4 = null;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(string, string2, string3, string4, n);
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @Override
    @Nullable
    public String getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @Override
    @Nullable
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public void setReferrer(@Nullable String string) {
        this.referrer = string;
    }

    @Override
    @Nullable
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(@Nullable String string) {
        this.href = string;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    @NotNull
    public String getConfiguredUrl() {
        return UrlUtils.mergeUrlArgs(this.getUrl(), this.getArgs());
    }

    @Override
    public boolean isStandard() {
        return UrlUtils.isStandard(this.getUrl());
    }

    @Override
    @NotNull
    public URL getToURL() throws MalformedURLException {
        return new URL(this.getUrl());
    }

    @Override
    @Nullable
    public URL getToURLOrNull() {
        return UrlUtils.getURLOrNull(this.getUrl());
    }

    @Override
    public boolean isNil() {
        return Intrinsics.areEqual((Object)this.getUrl(), (Object)"http://internal.pulsar.platon.ai/nil");
    }

    @Override
    public boolean isPersistable() {
        return this.isPersistable;
    }

    @Override
    @NotNull
    public String getLabel() {
        Object[] objectArray = new String[]{"-l", "-label", "--label"};
        String string = OptionUtils.INSTANCE.findOption(this.getArgs(), CollectionsKt.listOf((Object[])objectArray));
        return string == null ? "" : string;
    }

    @Override
    @NotNull
    public Instant getDeadline() {
        Object object;
        Object object2 = new String[]{"-deadline", "-deadTime", "--dead-time"};
        Object object3 = OptionUtils.INSTANCE.findOption(this.getArgs(), CollectionsKt.listOf((Object[])object2));
        Object deadTime = object3 == null ? "" : object3;
        object3 = DateTimes.parseBestInstantOrNull((String)deadTime);
        if (object3 == null) {
            object2 = DateTimes.INSTANCE.getDoomsday();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DateTimes.doomsday");
            object = object2;
        } else {
            object = object3;
        }
        return object;
    }

    @Override
    @NotNull
    public String getLang() {
        return this.lang;
    }

    public void setLang(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lang = string;
    }

    @Override
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @Override
    @NotNull
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.district = string;
    }

    @Override
    public int getNMaxRetry() {
        return this.nMaxRetry;
    }

    public void setNMaxRetry(int n) {
        this.nMaxRetry = n;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        Object object = other;
        return object instanceof String ? Intrinsics.areEqual((Object)this.getUrl(), (Object)other) : (object instanceof URL ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((URL)other).toString()) : (object instanceof UrlAware ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((UrlAware)other).getUrl()) : false));
    }

    @Override
    public int compareTo(@NotNull UrlAware other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getUrl().compareTo(other.getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    @Override
    @NotNull
    public Instant getDeadTime() {
        return ComparableUrlAware.DefaultImpls.getDeadTime(this);
    }

    @Override
    @Nullable
    public String getReferer() {
        return ComparableUrlAware.DefaultImpls.getReferer(this);
    }
}

