/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.urls.TenantedUrl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J'\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f\"\u00020\u0004\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010#\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u0018H\u0007J\u001a\u0010%\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u0018H\u0007J\u001c\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u0018H\u0007J&\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*2\b\b\u0002\u0010$\u001a\u00020\u0018H\u0007J&\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010-\u001a\u00020\u00042\b\b\u0002\u0010.\u001a\u00020\u0018H\u0007J'\u0010/\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f\"\u00020\u0004\u00a2\u0006\u0002\u0010 J\u0018\u00100\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u001c\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\n\u00104\u001a\u000605j\u0002`6H\u0002J\u0010\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0007J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\tH\u0007J\u0018\u00109\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0012\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010=\u001a\u00020\u0004H\u0007J\u0014\u0010>\u001a\u0004\u0018\u00010\u00042\b\u0010?\u001a\u0004\u0018\u00010@H\u0007J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u0004H\u0007J\u0018\u0010C\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0012\u0010D\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007\u00a8\u0006E"}, d2={"Lai/platon/pulsar/common/urls/UrlUtils;", "", "()V", "decodeKeyLowerBound", "", "startKey", "decodeKeyUpperBound", "endKey", "fixPureQueryTargets", "Ljava/net/URL;", "base", "targetUrl", "getEndKey", "tenantId", "", "unreversedUrl", "getReversedHost", "reversedUrl", "getStartKey", "getURLOrNull", "spec", "getUrlWithoutParameters", "url", "isInternal", "", "isNotInternal", "isStandard", "str", "isValidUrl", "keepQueryParameters", "parameterNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "mergeUrlArgs", "args", "normalize", "ignoreQuery", "normalizeOrEmpty", "normalizeOrNull", "normalizeUrls", "", "urls", "", "normalizedUrlAndKey", "Lkotlin/Pair;", "originalUrl", "norm", "removeQueryParameters", "resolveURL", "reverseAppendSplits", "", "string", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reverseHost", "hostName", "reverseUrl", "reverseUrlOrEmpty", "reverseUrlOrNull", "splitUrlArgs", "configuredUrl", "toString", "utf8", "", "unreverseHost", "reversedHostName", "unreverseUrl", "unreverseUrlOrNull", "pulsar-common"})
public final class UrlUtils {
    @NotNull
    public static final UrlUtils INSTANCE = new UrlUtils();

    private UrlUtils() {
    }

    @JvmStatic
    public static final boolean isInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://internal.pulsar.platon.ai", (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean isNotInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return !UrlUtils.isInternal(url);
    }

    @JvmStatic
    @Nullable
    public static final URL getURLOrNull(@Nullable String spec) {
        Object object;
        CharSequence charSequence = spec;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            URL uRL = new URL(spec);
            boolean bl5 = false;
            object = Result.constructor-impl((Object)uRL);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl7 = false;
        return (URL)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    @Deprecated(message="Inappropriate name", replaceWith=@ReplaceWith(expression="UrlUtils.isStandard(str)", imports={}))
    @JvmStatic
    public static final boolean isValidUrl(@Nullable String str) {
        return UrlUtils.getURLOrNull(str) != null;
    }

    @JvmStatic
    public static final boolean isStandard(@Nullable String str) {
        return UrlUtils.getURLOrNull(str) != null;
    }

    @JvmStatic
    @NotNull
    public static final URL normalize(@NotNull String url, boolean ignoreQuery) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pair<String, String> pair = UrlUtils.splitUrlArgs(url);
        String url0 = (String)pair.component1();
        URIBuilder uriBuilder = new URIBuilder(url0);
        uriBuilder.setFragment(null);
        if (ignoreQuery) {
            uriBuilder.removeQuery();
        }
        URL uRL = uriBuilder.build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"uriBuilder.build().toURL()");
        return uRL;
    }

    public static /* synthetic */ URL normalize$default(String string, boolean bl, int n, Object object) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalize(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeOrEmpty(@NotNull String url, boolean ignoreQuery) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            normalize(\u2026ery).toString()\n        }");
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrEmpty$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrEmpty(string, bl);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeOrNull(@NotNull String url, boolean ignoreQuery) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrNull$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrNull(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> normalizeUrls(@NotNull Iterable<String> urls, boolean ignoreQuery) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable<String> $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable<String> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UrlUtils.normalizeOrNull(it, ignoreQuery) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List normalizeUrls$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeUrls(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$removeQueryParameters_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        Object object = uriBuilder.getQueryParams();
        boolean bl = false;
        boolean bl2 = false;
        List list = object;
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl3 = false;
        $this$removeQueryParameters_u24lambda_u2d3.removeIf(arg_0 -> UrlUtils.removeQueryParameters$lambda-3$lambda-2(parameterNames, arg_0));
        Unit unit = Unit.INSTANCE;
        uRIBuilder.setParameters((List)object);
        object = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uriBuilder.build().toString()");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String keepQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$keepQueryParameters_u24lambda_u2d5;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        Object object = uriBuilder.getQueryParams();
        boolean bl = false;
        boolean bl2 = false;
        List list = object;
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl3 = false;
        $this$keepQueryParameters_u24lambda_u2d5.removeIf(arg_0 -> UrlUtils.keepQueryParameters$lambda-5$lambda-4(parameterNames, arg_0));
        Unit unit = Unit.INSTANCE;
        uRIBuilder.setParameters((List)object);
        object = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uriBuilder.build().toString()");
        return object;
    }

    @JvmStatic
    @NotNull
    public static final URL resolveURL(@NotNull URL base, @NotNull String targetUrl) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        String string = targetUrl;
        boolean bl = false;
        String target = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null) ? INSTANCE.fixPureQueryTargets(base, target) : new URL(base, target);
    }

    private final URL fixPureQueryTargets(URL base, String targetUrl) {
        String string = targetUrl;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Object target = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            return new URL(base, (String)target);
        }
        String basePath = base.getPath();
        String baseRightMost = "";
        Intrinsics.checkNotNullExpressionValue((Object)basePath, (String)"basePath");
        int baseRightMostIdx = StringsKt.lastIndexOf$default((CharSequence)basePath, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (baseRightMostIdx != -1) {
            String string3 = basePath;
            int n = baseRightMostIdx + 1;
            boolean bl2 = false;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            baseRightMost = string4;
        }
        if (StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            target = baseRightMost + (String)target;
        }
        return new URL(base, (String)target);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<String, String> splitUrlArgs(@NotNull String configuredUrl) {
        int n;
        int n2;
        String url;
        int n3;
        block7: {
            Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
            CharSequence charSequence = configuredUrl;
            boolean bl = false;
            charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            String string = "[\\r\\n\\t]";
            boolean bl2 = false;
            string = new Regex(string);
            String string2 = "";
            n3 = 0;
            url = string.replace(charSequence, string2);
            CharSequence $this$indexOfFirst$iv = url;
            boolean $i$f$indexOfFirst = false;
            n3 = 0;
            n2 = $this$indexOfFirst$iv.length();
            while (n3 < n2) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl3 = false;
                if (CharsKt.isWhitespace((char)it)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = -1;
        }
        int pos = n;
        String args = "";
        if (pos >= 0) {
            String string = url;
            n3 = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            args = string4;
            string = url;
            n3 = 0;
            n2 = 0;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n3, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            url = string6;
        }
        String string = url;
        n3 = 0;
        String string7 = string;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = args;
        n3 = 0;
        String string8 = string;
        if (string8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)string7)).toString(), (Object)((Object)StringsKt.trim((CharSequence)string8)).toString());
    }

    @JvmStatic
    @NotNull
    public static final String mergeUrlArgs(@NotNull String url, @Nullable String args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = args;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = url;
            bl = false;
            object = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        } else {
            charSequence = url;
            bl = false;
            String string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            charSequence = args;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = string + " " + ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
        }
        return object;
    }

    public static /* synthetic */ String mergeUrlArgs$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UrlUtils.mergeUrlArgs(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String getUrlWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(url);
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> normalizedUrlAndKey(@NotNull String originalUrl, boolean norm) {
        String string;
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        String url = norm ? ((string = UrlUtils.normalizeOrNull$default(originalUrl, false, 2, null)) == null ? "" : string) : originalUrl;
        String key = UrlUtils.reverseUrlOrEmpty(url);
        return TuplesKt.to((Object)url, (Object)key);
    }

    public static /* synthetic */ Pair normalizedUrlAndKey$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizedUrlAndKey(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return UrlUtils.reverseUrl(new URL(url));
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrlOrEmpty(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String reverseUrlOrNull(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        String file = url.getFile();
        String protocol = url.getProtocol();
        int port = url.getPort();
        StringBuilder buf = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
        INSTANCE.reverseAppendSplits(host, buf);
        buf.append(':');
        buf.append(protocol);
        if (port != -1) {
            buf.append(':');
            buf.append(port);
        }
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        CharSequence charSequence = file;
        boolean bl = false;
        if (charSequence.length() > 0 && '/' != file.charAt(0)) {
            buf.append('/');
        }
        buf.append(file);
        charSequence = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"buf.toString()");
        return charSequence;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(int tenantId, @NotNull String unreversedUrl) {
        Intrinsics.checkNotNullParameter((Object)unreversedUrl, (String)"unreversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(unreversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.reverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        StringBuilder buf = new StringBuilder(reversedUrl.length() + 2);
        int pathBegin = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pathBegin == -1) {
            pathBegin = reversedUrl.length();
        }
        String string = reversedUrl;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sub = string2;
        String[] splits = StringUtils.splitPreserveAllTokens((String)sub, (char)':');
        buf.append(splits[1]);
        buf.append("://");
        String string3 = splits[0];
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"splits[0]");
        INSTANCE.reverseAppendSplits(string3, buf);
        if (splits.length == 3) {
            buf.append(':');
            buf.append(splits[2]);
        }
        string3 = reversedUrl;
        bl = false;
        String string4 = string3.substring(pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        buf.append(string4);
        string3 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"buf.toString()");
        return string3;
    }

    @JvmStatic
    @Nullable
    public static final String unreverseUrlOrNull(@NotNull String reversedUrl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            String string = UrlUtils.unreverseUrl(reversedUrl);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        return (String)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(int tenantId, @NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(reversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.unreverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId);
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(endKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId + 1);
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, endKey);
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyLowerBound(@NotNull String startKey) {
        Intrinsics.checkNotNullParameter((Object)startKey, (String)"startKey");
        String startKey2 = startKey;
        CharSequence charSequence = startKey2;
        String string = "\\\\u0001";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "\u0001";
        boolean bl2 = false;
        startKey2 = string.replace(charSequence, string2);
        charSequence = startKey2;
        string = "\\u0001";
        boolean bl3 = false;
        string = new Regex(string);
        String string3 = "\u0001";
        bl2 = false;
        startKey2 = string.replace(charSequence, string3);
        return startKey2;
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyUpperBound(@NotNull String endKey) {
        Intrinsics.checkNotNullParameter((Object)endKey, (String)"endKey");
        String endKey2 = endKey;
        CharSequence charSequence = endKey2;
        String string = "\\\\uFFFF";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "\uffff";
        boolean bl2 = false;
        endKey2 = string.replace(charSequence, string2);
        charSequence = endKey2;
        string = "\\uFFFF";
        boolean bl3 = false;
        string = new Regex(string);
        String string3 = "\uffff";
        bl2 = false;
        endKey2 = string.replace(charSequence, string3);
        return endKey2;
    }

    @JvmStatic
    @NotNull
    public static final String getReversedHost(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        String string = reversedUrl;
        int n = 0;
        int n2 = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)':', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private final void reverseAppendSplits(String string, StringBuilder buf) {
        String[] splits = StringUtils.split((String)string, (char)'.');
        Intrinsics.checkNotNullExpressionValue((Object)splits, (String)"splits");
        String[] stringArray = splits;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            int n = splits.length - 1;
            if (1 <= n) {
                do {
                    int i = n--;
                    buf.append(splits[i]);
                    buf.append('.');
                } while (1 <= n);
            }
            buf.append(splits[0]);
        } else {
            buf.append(string);
        }
    }

    @JvmStatic
    @NotNull
    public static final String reverseHost(@NotNull String hostName) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        StringBuilder buf = new StringBuilder();
        INSTANCE.reverseAppendSplits(hostName, buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String unreverseHost(@NotNull String reversedHostName) {
        Intrinsics.checkNotNullParameter((Object)reversedHostName, (String)"reversedHostName");
        return UrlUtils.reverseHost(reversedHostName);
    }

    @JvmStatic
    @Nullable
    public static final String toString(@Nullable CharSequence utf8) {
        return utf8 == null ? null : Strings.cleanField(((Object)utf8).toString());
    }

    private static final boolean removeQueryParameters$lambda-3$lambda-2(String[] $parameterNames, NameValuePair it) {
        Intrinsics.checkNotNullParameter((Object)$parameterNames, (String)"$parameterNames");
        return ArraysKt.contains((Object[])$parameterNames, (Object)it.getName());
    }

    private static final boolean keepQueryParameters$lambda-5$lambda-4(String[] $parameterNames, NameValuePair it) {
        Intrinsics.checkNotNullParameter((Object)$parameterNames, (String)"$parameterNames");
        return !ArraysKt.contains((Object[])$parameterNames, (Object)it.getName());
    }
}

