/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.queue;

import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlTopic;
import ai.platon.pulsar.common.collect.queue.DelayLoadingQueue;
import ai.platon.pulsar.common.urls.UrlAware;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/collect/queue/ConcurrentNonReentrantLoadingQueue;", "Lai/platon/pulsar/common/collect/queue/DelayLoadingQueue;", "loader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "topic", "Lai/platon/pulsar/common/collect/UrlTopic;", "ttl", "Ljava/time/Duration;", "transformer", "Lkotlin/Function1;", "Lai/platon/pulsar/common/urls/UrlAware;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/common/collect/UrlTopic;Ljava/time/Duration;Lkotlin/jvm/functions/Function1;)V", "historyHash", "Lorg/apache/commons/collections4/map/PassiveExpiringMap;", "", "countHistory", "url", "hashCode", "offer", "", "pulsar-common"})
public final class ConcurrentNonReentrantLoadingQueue
extends DelayLoadingQueue {
    @NotNull
    private final PassiveExpiringMap<Integer, Integer> historyHash;

    public ConcurrentNonReentrantLoadingQueue(@NotNull ExternalUrlLoader loader, @NotNull UrlTopic topic, @NotNull Duration ttl, @NotNull Function1<? super UrlAware, ? extends UrlAware> transformer) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        super(loader, topic, null, null, transformer, 12, null);
        this.historyHash = new PassiveExpiringMap(ttl.toMillis());
    }

    public /* synthetic */ ConcurrentNonReentrantLoadingQueue(ExternalUrlLoader externalUrlLoader, UrlTopic urlTopic, Duration duration, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofDays(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(1)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(externalUrlLoader, urlTopic, duration, (Function1<? super UrlAware, ? extends UrlAware>)function1);
    }

    public final synchronized int countHistory(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.countHistory(url.hashCode()) > 0 ? 1 : 0;
    }

    public final synchronized int countHistory(int hashCode) {
        Integer n = (Integer)this.historyHash.get((Object)hashCode);
        return n == null ? 0 : n;
    }

    @Override
    public synchronized boolean offer(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int hashCode = url.hashCode();
        if (this.countHistory(hashCode) == 0) {
            boolean bl;
            if (!url.isPersistable() || this.getFreeSlots() > 0) {
                Map map = (Map)this.historyHash;
                Integer n = hashCode;
                Integer n2 = 1;
                boolean bl2 = false;
                map.put(n, n2);
                bl = this.getCacheImplementation().add(url);
            } else {
                this.overflow(url);
                bl = true;
            }
            return bl;
        }
        return false;
    }
}

