/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/common/ResourceWalker;", "", "()V", "logger", "Lorg/slf4j/Logger;", "resourcePrefix", "", "getResourcePrefix", "()Ljava/lang/String;", "setResourcePrefix", "(Ljava/lang/String;)V", "collect", "", "Ljava/nio/file/Path;", "resourceBase", "maxDepth", "", "walk", "", "visitor", "Lkotlin/Function1;", "Companion", "pulsar-common"})
public final class ResourceWalker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LogsKt.getLogger(this);
    @NotNull
    private String resourcePrefix = "";
    @NotNull
    private static final String SPRING_PACKEDR_ESOURCE_PREFIX = "BOOT-INF/classes/";

    public ResourceWalker() {
        URI uri;
        URL uRL = ResourceLoader.INSTANCE.getResource(SPRING_PACKEDR_ESOURCE_PREFIX);
        URI uRI = uri = uRL == null ? null : uRL.toURI();
        if (uri != null && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jar")) {
            this.resourcePrefix = SPRING_PACKEDR_ESOURCE_PREFIX;
        }
    }

    @NotNull
    public final String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public final void setResourcePrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.resourcePrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void walk(@NotNull String resourceBase, int maxDepth, @NotNull Function1<? super Path, Unit> visitor) {
        Object path;
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)resourceBase, (String)"resourceBase");
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        URL uRL = ResourceLoader.INSTANCE.getResource(resourceBase);
        URI uRI2 = uRI = uRL == null ? null : uRL.toURI();
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        FileSystem fileSystem = null;
        try {
            Path path2;
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jar")) {
                HashMap env = new HashMap();
                fileSystem = FileSystems.newFileSystem(uri, (Map)env);
                path2 = fileSystem.getPath(this.resourcePrefix + resourceBase, new String[0]);
            } else {
                path2 = Paths.get(uri);
            }
            path = path2;
            Stream<Path> walk = Files.walk((Path)path, maxDepth, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                try {
                    Object t = it.next();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"it.next()");
                    visitor.invoke(t);
                }
                catch (Throwable t) {
                    this.logger.warn("Failed to visit path | " + (Path)path, t);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected failure to walk | " + resourceBase, t);
        }
        finally {
            path = fileSystem;
            if (path != null) {
                ((FileSystem)path).close();
            }
        }
    }

    @NotNull
    public final List<Path> collect(@NotNull String resourceBase, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)resourceBase, (String)"resourceBase");
        boolean bl = false;
        List paths = new ArrayList();
        this.walk(resourceBase, maxDepth, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>((List<Path>)paths){
            final /* synthetic */ List<Path> $paths;
            {
                this.$paths = $paths;
                super(1);
            }

            public final void invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$paths.add(it);
            }
        }));
        return paths;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/ResourceWalker$Companion;", "", "()V", "SPRING_PACKEDR_ESOURCE_PREFIX", "", "getSPRING_PACKEDR_ESOURCE_PREFIX", "()Ljava/lang/String;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSPRING_PACKEDR_ESOURCE_PREFIX() {
            return SPRING_PACKEDR_ESOURCE_PREFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

