/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Runtimes;
import java.awt.GraphicsEnvironment;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001OB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010F\u001a\u00020GJ\b\u0010H\u001a\u00020+H\u0002J\b\u0010I\u001a\u00020+H\u0002J\b\u0010J\u001a\u00020+H\u0002J\u0006\u0010K\u001a\u00020GJ\u0006\u0010L\u001a\u00020GJ\b\u0010M\u001a\u00020\u000bH\u0002J\u0006\u0010N\u001a\u00020GR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0019\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0019\u0010\u0014\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0019\u0010\u0016\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0019\u0010\u0018\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0019\u0010\u001a\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0019\u0010\u001c\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0019\u0010\u001e\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u001b\u0010 \u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b!\u0010\rR\u0019\u0010$\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010#\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010#\u001a\u0004\b0\u0010-R\u001b\u00102\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010#\u001a\u0004\b3\u0010-R\u0019\u00105\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u0019\u00107\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\rR\u0019\u00109\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\rR\u0019\u0010;\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\rR\u0011\u0010=\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010-R\u0011\u0010>\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010-R\u0016\u0010?\u001a\n \u0005*\u0004\u0018\u00010@0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010A\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010C0C0B\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006P"}, d2={"Lai/platon/pulsar/common/AppContext;", "", "()V", "APP_DATA_DIR", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getAPP_DATA_DIR", "()Ljava/nio/file/Path;", "APP_DATA_DIR_RT", "getAPP_DATA_DIR_RT", "APP_IDENT", "", "getAPP_IDENT", "()Ljava/lang/String;", "APP_IDENT_RT", "getAPP_IDENT_RT", "APP_NAME", "getAPP_NAME", "APP_NAME_RT", "getAPP_NAME_RT", "APP_PROC_TMP_DIR", "getAPP_PROC_TMP_DIR", "APP_PROC_TMP_DIR_RT", "getAPP_PROC_TMP_DIR_RT", "APP_TMP_DIR", "getAPP_TMP_DIR", "APP_TMP_DIR_RT", "getAPP_TMP_DIR_RT", "APP_TMP_SPECIFIED", "getAPP_TMP_SPECIFIED", "APP_TMP_SPECIFIED_RT", "getAPP_TMP_SPECIFIED_RT", "APP_VERSION", "getAPP_VERSION", "APP_VERSION$delegate", "Lkotlin/Lazy;", "HOST_NAME", "getHOST_NAME", "NCPU", "", "getNCPU", "()I", "OS_IS_LINUX_DESKTOP", "", "getOS_IS_LINUX_DESKTOP", "()Z", "OS_IS_LINUX_DESKTOP$delegate", "OS_IS_VIRT", "getOS_IS_VIRT", "OS_IS_VIRT$delegate", "OS_IS_WSL", "getOS_IS_WSL", "OS_IS_WSL$delegate", "TMP_DIR", "getTMP_DIR", "USER", "getUSER", "USER_DIR", "getUSER_DIR", "USER_HOME", "getUSER_HOME", "isActive", "isGUIAvailable", "logger", "Lorg/slf4j/Logger;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/AppContext$State;", "getState", "()Ljava/util/concurrent/atomic/AtomicReference;", "beginTermination", "", "checkIsLinuxDesktop", "checkIsWSL", "checkVirtualEnv", "endTermination", "shouldTerminate", "sniffVersion", "start", "State", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nAppContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppContext.kt\nai/platon/pulsar/common/AppContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1549#2:218\n1620#2,3:219\n223#2,2:222\n1549#2:225\n1620#2,3:226\n766#2:229\n857#2,2:230\n1747#2,3:232\n1#3:224\n*S KotlinDebug\n*F\n+ 1 AppContext.kt\nai/platon/pulsar/common/AppContext\n*L\n133#1:218\n133#1:219,3\n134#1:222,2\n209#1:225\n209#1:226,3\n209#1:229\n209#1:230,2\n209#1:232,3\n*E\n"})
public final class AppContext {
    @NotNull
    public static final AppContext INSTANCE = new AppContext();
    private static final Logger logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(AppContext.class));
    @NotNull
    private static final Lazy OS_IS_WSL$delegate = LazyKt.lazy((Function0)OS_IS_WSL.2.INSTANCE);
    @NotNull
    private static final Lazy OS_IS_VIRT$delegate = LazyKt.lazy((Function0)OS_IS_VIRT.2.INSTANCE);
    @NotNull
    private static final Lazy OS_IS_LINUX_DESKTOP$delegate = LazyKt.lazy((Function0)OS_IS_LINUX_DESKTOP.2.INSTANCE);
    @NotNull
    private static final Lazy APP_VERSION$delegate = LazyKt.lazy((Function0)APP_VERSION.2.INSTANCE);
    private static final String APP_NAME = INSTANCE.getAPP_NAME_RT();
    private static final String APP_IDENT = INSTANCE.getAPP_IDENT_RT();
    private static final String APP_TMP_SPECIFIED = INSTANCE.getAPP_TMP_SPECIFIED_RT();
    private static final Path APP_TMP_DIR = INSTANCE.getAPP_TMP_DIR_RT();
    private static final Path APP_PROC_TMP_DIR = INSTANCE.getAPP_PROC_TMP_DIR_RT();
    private static final Path APP_DATA_DIR = INSTANCE.getAPP_DATA_DIR_RT();
    @NotNull
    private static final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    private AppContext() {
    }

    public final int getNCPU() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final String getHOST_NAME() {
        return InetAddress.getLocalHost().getHostName();
    }

    public final String getUSER() {
        return SystemUtils.USER_NAME;
    }

    public final String getTMP_DIR() {
        return SystemUtils.JAVA_IO_TMPDIR;
    }

    public final String getUSER_DIR() {
        return SystemUtils.USER_DIR;
    }

    public final String getUSER_HOME() {
        return SystemUtils.USER_HOME;
    }

    public final boolean getOS_IS_WSL() {
        Lazy lazy = OS_IS_WSL$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getOS_IS_VIRT() {
        Lazy lazy = OS_IS_VIRT$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getOS_IS_LINUX_DESKTOP() {
        Lazy lazy = OS_IS_LINUX_DESKTOP$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isGUIAvailable() {
        return this.getOS_IS_LINUX_DESKTOP() ? true : (this.getOS_IS_WSL() ? false : !GraphicsEnvironment.isHeadless());
    }

    @NotNull
    public final String getAPP_VERSION() {
        Lazy lazy = APP_VERSION$delegate;
        return (String)lazy.getValue();
    }

    public final String getAPP_NAME_RT() {
        String string = System.getenv("app.name");
        if (string == null) {
            string = System.getProperty("app.name", "pulsar");
        }
        return string;
    }

    public final String getAPP_NAME() {
        return APP_NAME;
    }

    public final String getAPP_IDENT_RT() {
        String string = System.getenv("app.ident");
        if (string == null) {
            string = System.getProperty("app.ident", this.getUSER());
        }
        return string;
    }

    public final String getAPP_IDENT() {
        return APP_IDENT;
    }

    public final String getAPP_TMP_SPECIFIED_RT() {
        String string = System.getenv("app.tmp.dir");
        if (string == null) {
            string = System.getProperty("app.tmp.dir");
        }
        return string;
    }

    public final String getAPP_TMP_SPECIFIED() {
        return APP_TMP_SPECIFIED;
    }

    public final Path getAPP_TMP_DIR_RT() {
        return this.getAPP_TMP_SPECIFIED_RT() != null ? Paths.get(this.getAPP_TMP_SPECIFIED_RT(), new String[0]).resolve(this.getAPP_NAME_RT()) : Paths.get(this.getTMP_DIR(), new String[0]).resolve(this.getAPP_NAME_RT());
    }

    public final Path getAPP_TMP_DIR() {
        return APP_TMP_DIR;
    }

    public final Path getAPP_PROC_TMP_DIR_RT() {
        return this.getAPP_TMP_DIR_RT().resolveSibling(this.getAPP_NAME_RT() + "-" + this.getAPP_IDENT_RT());
    }

    public final Path getAPP_PROC_TMP_DIR() {
        return APP_PROC_TMP_DIR;
    }

    /*
     * WARNING - void declaration
     */
    public final Path getAPP_DATA_DIR_RT() {
        Object element$iv2;
        block2: {
            void $this$mapTo$iv$iv;
            Object[] objectArray = new String[]{this.getUSER_HOME(), this.getTMP_DIR()};
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Paths.get((String)it, new String[0]));
            }
            Iterable $this$first$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Path it = (Path)element$iv2;
                boolean bl = false;
                if (!Files.isWritable(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((Path)element$iv2).resolve("." + this.getAPP_NAME_RT());
    }

    public final Path getAPP_DATA_DIR() {
        return APP_DATA_DIR;
    }

    @NotNull
    public final AtomicReference<State> getState() {
        return state;
    }

    public final boolean isActive() {
        return state.get().ordinal() < State.TERMINATING.ordinal();
    }

    public final void start() {
        state.set(State.RUNNING);
    }

    public final void shouldTerminate() {
        if (state.get() != State.TERMINATED) {
            state.set(State.TERMINATING);
        }
    }

    public final void beginTermination() {
        state.set(State.TERMINATING);
    }

    public final void endTermination() {
        state.set(State.TERMINATED);
    }

    private final String sniffVersion() {
        String string;
        String version = System.getProperty("app.version");
        if (version == null) {
            String string2;
            Path path;
            Path path2;
            Path it = path2 = Paths.get(this.getUSER_DIR(), new String[0]).resolve("VERSION");
            boolean bl = false;
            Path path3 = path = Files.exists(it, new LinkOption[0]) ? path2 : null;
            if (path != null) {
                it = path;
                boolean bl2 = false;
                List<String> list2 = Files.readAllLines(it);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                string2 = (String)CollectionsKt.firstOrNull(list2);
            } else {
                string2 = version = null;
            }
        }
        if ((string = version) == null) {
            string = "unknown";
        }
        return string;
    }

    private final boolean checkIsLinuxDesktop() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        String env = System.getenv("XDG_SESSION_TYPE");
        return Intrinsics.areEqual((Object)env, (Object)"x11") || Intrinsics.areEqual((Object)env, (Object)"wayland");
    }

    private final boolean checkIsWSL() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        try {
            Path path = Paths.get("/proc/version", new String[0]);
            if (Files.isReadable(path)) {
                String version = Files.readString(path);
                logger.info("Version: " + version);
                Intrinsics.checkNotNull((Object)version);
                CharSequence charSequence = version;
                if (new Regex("microsoft-*-WSL").containsMatchIn(charSequence)) {
                    return true;
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Unexpected exception", t);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkVirtualEnv() {
        if (SystemUtils.IS_OS_WINDOWS) {
            logger.info("Not supported to check if a Windows OS running on a virtual machine");
            return false;
        }
        try {
            boolean bl;
            block8: {
                void $this$filterTo$iv$iv;
                String it;
                Iterable $this$mapTo$iv$iv;
                List<String> output = Runtimes.INSTANCE.exec("systemd-detect-virt");
                Iterable $this$map$iv = output;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)"none"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl4 = false;
                        boolean bl5 = !StringsKt.isBlank((CharSequence)it2);
                        if (!bl5) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (Throwable t) {
            logger.warn("Unexpected exception", t);
            return false;
        }
    }

    public static final /* synthetic */ boolean access$checkIsWSL(AppContext $this) {
        return $this.checkIsWSL();
    }

    public static final /* synthetic */ boolean access$checkVirtualEnv(AppContext $this) {
        return $this.checkVirtualEnv();
    }

    public static final /* synthetic */ boolean access$checkIsLinuxDesktop(AppContext $this) {
        return $this.checkIsLinuxDesktop();
    }

    public static final /* synthetic */ String access$sniffVersion(AppContext $this) {
        return $this.sniffVersion();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/common/AppContext$State;", "", "(Ljava/lang/String;I)V", "NEW", "RUNNING", "TERMINATING", "TERMINATED", "pulsar-common"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NEW = new State();
        public static final /* enum */ State RUNNING = new State();
        public static final /* enum */ State TERMINATING = new State();
        public static final /* enum */ State TERMINATED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NEW, State.RUNNING, State.TERMINATING, State.TERMINATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

