/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import com.google.common.base.Charsets;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiledLines {
    private static final Logger LOG = LoggerFactory.getLogger(FiledLines.class);
    private Comparator<String> wordsComparator = null;
    private Map<String, TreeMultiset<String>> file2Lines = new HashMap<String, TreeMultiset<String>>();
    private Preprocessor preprocessor = new DefaultPreprocessor();

    public FiledLines() {
    }

    public FiledLines(String ... files) {
        Validate.notNull((Object)files);
        try {
            this.load(files);
        }
        catch (IOException e) {
            LOG.error("{}, files : {}", (Object)e, Arrays.asList(files));
        }
    }

    public FiledLines(Path ... files) {
        Validate.notNull((Object)files);
        try {
            this.load(files);
        }
        catch (IOException e) {
            LOG.error("{}, files : {}", (Object)e, Arrays.asList(files));
        }
    }

    public FiledLines(Comparator<String> wordsComparator, String ... files) {
        this(files);
        this.wordsComparator = wordsComparator;
    }

    public Preprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public void setPreprocessor(Preprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Multiset<String> getLines(String file) {
        if (this.file2Lines.isEmpty()) {
            return TreeMultiset.create();
        }
        return (Multiset)this.file2Lines.get(file);
    }

    public Multiset<String> getLines(Path path) {
        if (this.file2Lines.isEmpty()) {
            return TreeMultiset.create();
        }
        return (Multiset)this.file2Lines.get(path.toString());
    }

    public Multiset<String> firstFileLines() {
        if (this.file2Lines.isEmpty()) {
            return TreeMultiset.create();
        }
        return (Multiset)this.file2Lines.values().iterator().next();
    }

    public boolean add(String file, String text) {
        Multiset<String> lines = this.getLines(file);
        return lines != null && lines.add((Object)text);
    }

    public boolean add(Path path, String text) {
        Multiset<String> lines = this.getLines(path.toString());
        return lines != null && lines.add((Object)text);
    }

    public boolean addAll(String file, Collection<String> texts) {
        Multiset<String> lines = this.getLines(file);
        return lines != null && lines.addAll(texts);
    }

    public boolean addAll(Path path, Collection<String> texts) {
        Multiset<String> lines = this.getLines(path.toString());
        return lines != null && lines.addAll(texts);
    }

    public boolean remove(String file, String text) {
        Multiset<String> lines = this.getLines(file);
        return lines != null && lines.remove((Object)text);
    }

    public boolean remove(Path path, String text) {
        Multiset<String> lines = this.getLines(path.toString());
        return lines != null && lines.remove((Object)text);
    }

    public void clear() {
        this.file2Lines.clear();
    }

    public boolean contains(String file, String text) {
        Multiset<String> conf = this.getLines(file);
        return conf != null && conf.contains((Object)text);
    }

    public void load(Path ... paths) throws IOException {
        for (Path path : paths) {
            TreeMultiset values = TreeMultiset.create(this.wordsComparator);
            List lines = Files.readLines((File)path.toFile(), (Charset)Charsets.UTF_8);
            for (String line : lines) {
                if ((line = this.preprocessor.process(line)) == null || line.isEmpty()) continue;
                values.add((Object)line);
            }
            this.file2Lines.put(path.toString(), (TreeMultiset<String>)values);
        }
    }

    public void load(String ... files) throws IOException {
        if (files.length == 0) {
            LOG.error("no file to load");
        }
        for (String file : files) {
            if (file != null && file.length() > 0) {
                TreeMultiset values = TreeMultiset.create(this.wordsComparator);
                List lines = Files.readLines((File)new File(file), (Charset)Charsets.UTF_8);
                for (String line : lines) {
                    if ((line = this.preprocessor.process(line)) == null || line.isEmpty()) continue;
                    values.add((Object)line);
                }
                this.file2Lines.put(file, (TreeMultiset<String>)values);
                continue;
            }
            LOG.error("bad file name");
        }
    }

    public void save(String file) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        for (String line : this.file2Lines.get(file).elementSet()) {
            pw.println(line);
        }
        pw.close();
    }

    public void saveAll() throws IOException {
        for (String file : this.file2Lines.keySet()) {
            this.save(file);
        }
    }

    public class DefaultPreprocessor
    implements Preprocessor {
        @Override
        public String process(String line) {
            return line.startsWith("#") ? "" : line.trim();
        }
    }

    public static interface Preprocessor {
        public String process(String var1);
    }
}

