/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.BinaryTreeNode;
import ai.platon.pulsar.common.Frequency;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u0015\u0010\u0006\u001a\u00060\u0007R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lai/platon/pulsar/common/FrequencyTree;", "", "frequency", "Lai/platon/pulsar/common/Frequency;", "", "(Lai/platon/pulsar/common/Frequency;)V", "root", "Lai/platon/pulsar/common/FrequencyTree$Node;", "getRoot", "()Lai/platon/pulsar/common/FrequencyTree$Node;", "print", "", "Node", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nFrequencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrequencyTree.kt\nai/platon/pulsar/common/FrequencyTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n766#2:65\n857#2,2:66\n1620#2,3:68\n*S KotlinDebug\n*F\n+ 1 FrequencyTree.kt\nai/platon/pulsar/common/FrequencyTree\n*L\n14#1:65\n14#1:66,2\n15#1:68,3\n*E\n"})
public final class FrequencyTree {
    @NotNull
    private final Node root;

    /*
     * WARNING - void declaration
     */
    public FrequencyTree(@NotNull Frequency<String> frequency) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(frequency, (String)"frequency");
        Iterable $this$filter$iv = frequency.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Multiset.Entry it = (Multiset.Entry)element$iv$iv;
            boolean bl = false;
            Object object = it.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getElement(...)");
            boolean bl2 = ((CharSequence)object).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new PriorityQueue();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Multiset.Entry entry = (Multiset.Entry)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Object object = it.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getElement(...)");
            collection.add(new Node(this, (String)object, it.getCount(), null, null, 12, null));
        }
        PriorityQueue queue = (PriorityQueue)destination$iv;
        while (queue.size() > 1) {
            Node most = (Node)queue.remove();
            Node nextMost = (Node)queue.remove();
            Node node = new Node(this, "", most.getFrequency() + nextMost.getFrequency(), null, null, 12, null);
            node.setLeft(most);
            node.setRight(nextMost);
            queue.add(node);
        }
        Object e = queue.remove();
        Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
        this.root = (Node)e;
    }

    @NotNull
    public final Node getRoot() {
        return this.root;
    }

    public final void print() {
        this.root.print(2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0018\u00010\u0000R\u00020\u0002\u0012\u000e\b\u0002\u0010\b\u001a\b\u0018\u00010\u0000R\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0018\u001a\u00020\u00062\n\u0010\u0019\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bJ\n\u0010\u001c\u001a\u00060\u0000R\u00020\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0006J\b\u0010 \u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0007\u001a\b\u0018\u00010\u0000R\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\b\u001a\b\u0018\u00010\u0000R\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015\u00a8\u0006!"}, d2={"Lai/platon/pulsar/common/FrequencyTree$Node;", "", "Lai/platon/pulsar/common/FrequencyTree;", "data", "", "frequency", "", "left", "right", "(Lai/platon/pulsar/common/FrequencyTree;Ljava/lang/String;ILai/platon/pulsar/common/FrequencyTree$Node;Lai/platon/pulsar/common/FrequencyTree$Node;)V", "getData", "()Ljava/lang/String;", "setData", "(Ljava/lang/String;)V", "getFrequency", "()I", "setFrequency", "(I)V", "getLeft", "()Lai/platon/pulsar/common/FrequencyTree$Node;", "setLeft", "(Lai/platon/pulsar/common/FrequencyTree$Node;)V", "getRight", "setRight", "compareTo", "other", "convert", "Lai/platon/pulsar/common/BinaryTreeNode;", "copy", "print", "", "margin", "toString", "pulsar-common"})
    public final class Node
    implements Comparable<Node> {
        @NotNull
        private String data;
        private int frequency;
        @Nullable
        private Node left;
        @Nullable
        private Node right;
        final /* synthetic */ FrequencyTree this$0;

        public Node(@NotNull FrequencyTree this$0, String data, @Nullable int frequency, @Nullable Node left, Node right) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.this$0 = this$0;
            this.data = data;
            this.frequency = frequency;
            this.left = left;
            this.right = right;
        }

        public /* synthetic */ Node(FrequencyTree frequencyTree, String string, int n, Node node, Node node2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                node = null;
            }
            if ((n2 & 8) != 0) {
                node2 = null;
            }
            this(frequencyTree, string, n, node, node2);
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        public final void setData(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.data = string;
        }

        public final int getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(int n) {
            this.frequency = n;
        }

        @Nullable
        public final Node getLeft() {
            return this.left;
        }

        public final void setLeft(@Nullable Node node) {
            this.left = node;
        }

        @Nullable
        public final Node getRight() {
            return this.right;
        }

        public final void setRight(@Nullable Node node) {
            this.right = node;
        }

        public final void print(int margin) {
            block1: {
                System.out.print((Object)StringsKt.repeat((CharSequence)"\t", (int)margin));
                System.out.println(this);
                Node node = this.left;
                if (node != null) {
                    node.print(2 + margin);
                }
                Node node2 = this.right;
                if (node2 == null) break block1;
                node2.print(2 + margin);
            }
        }

        public static /* synthetic */ void print$default(Node node, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 2;
            }
            node.print(n);
        }

        @NotNull
        public final Node copy() {
            Node node = this.left;
            Node node2 = this.right;
            return new Node(this.this$0, this.data, this.frequency, node != null ? node.copy() : null, node2 != null ? node2.copy() : null);
        }

        @NotNull
        public final BinaryTreeNode<String> convert() {
            Node node = this.left;
            Node node2 = this.right;
            return new BinaryTreeNode<String>(this.toString(), node != null ? node.convert() : null, node2 != null ? node2.convert() : null);
        }

        @Override
        public int compareTo(@NotNull Node other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.frequency - other.frequency;
        }

        @NotNull
        public String toString() {
            return ((CharSequence)this.data).length() == 0 ? String.valueOf(this.frequency) : this.data + ":" + this.frequency;
        }
    }
}

