/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.OpenMapAnyTableFormatter;
import ai.platon.pulsar.common.OpenMapTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u0006\u0010\u0012\u001a\u00020\u0006J$\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00160\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lai/platon/pulsar/common/OpenMapAnyTableFormatter;", "", "table", "Lai/platon/pulsar/common/OpenMapTable;", "(Lai/platon/pulsar/common/OpenMapTable;)V", "resultAsList", "", "getResultAsList", "()Ljava/lang/String;", "resultAsTable", "getResultAsTable", "rowCount", "", "getTable", "()Lai/platon/pulsar/common/OpenMapTable;", "format", "asList", "", "formatAsLine", "formatRows", "rows", "Ljava/util/ArrayList;", "", "numColumns", "toString", "Companion", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nOpenMapAnyTableFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenMapAnyTableFormatter.kt\nai/platon/pulsar/common/OpenMapAnyTableFormatter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n11065#2:140\n11400#2,3:141\n11065#2:147\n11400#2,3:148\n37#3,2:144\n37#3,2:151\n1855#4:146\n1856#4:154\n1855#4,2:155\n1#5:153\n*S KotlinDebug\n*F\n+ 1 OpenMapAnyTableFormatter.kt\nai/platon/pulsar/common/OpenMapAnyTableFormatter\n*L\n33#1:140\n33#1:141,3\n37#1:147\n37#1:148,3\n33#1:144,2\n38#1:151,2\n36#1:146\n36#1:154\n67#1:155,2\n*E\n"})
public final class OpenMapAnyTableFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenMapTable table;
    private int rowCount;
    private static int MAX_ROW_BUFFER = 5000;
    private static int MAX_COLUMN_LENGTH = 1000;
    private static char BOX_VERTICAL = (char)124;

    public OpenMapAnyTableFormatter(@NotNull OpenMapTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
    }

    @NotNull
    public final OpenMapTable getTable() {
        return this.table;
    }

    @JvmOverloads
    @NotNull
    public final String format(boolean asList) {
        Object object;
        try {
            object = asList ? this.getResultAsList() : this.getResultAsTable();
        }
        catch (SQLException e) {
            object = "(Exception)" + e.getMessage();
        }
        return object;
    }

    public static /* synthetic */ String format$default(OpenMapAnyTableFormatter openMapAnyTableFormatter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return openMapAnyTableFormatter.format(bl);
    }

    @NotNull
    public final String formatAsLine() {
        return this.format(true);
    }

    /*
     * WARNING - void declaration
     */
    private final String getResultAsTable() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        StringBuilder sb = new StringBuilder();
        OpenMapTable.Metadata metadata = this.table.getMetadata();
        int numColumns = metadata.getColumns().length;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        Object $this$map$iv = metadata.getColumns();
        boolean $i$f$map = false;
        OpenMapTable.Column[] columnArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((OpenMapTable.Column[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var14_16 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] columns = thisCollection$iv.toArray(new String[0]);
        rows.add(columns);
        Iterable $this$forEach$iv = this.table.getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String[] stringArray;
            void $this$toTypedArray$iv2;
            void $this$mapTo$iv$iv2;
            OpenMapTable.Row it = (OpenMapTable.Row)element$iv;
            boolean bl = false;
            Object $this$map$iv2 = it.getCells();
            boolean $i$f$map2 = false;
            OpenMapTable.Cell[] it2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(((OpenMapTable.Cell[])$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            int n2 = ((void)$this$mapTo$iv$iv2).length;
            for (int i = 0; i < n2; ++i) {
                void it3;
                void item$iv$iv;
                void var20_27 = item$iv$iv = $this$mapTo$iv$iv2[i];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = it3;
                if (string == null || (string = ((OpenMapTable.Cell)((Object)string)).toString()) == null) {
                    string = "null";
                }
                collection.add(StringUtils.abbreviate((String)string, (int)MAX_COLUMN_LENGTH));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] it4 = stringArray = thisCollection$iv2.toArray(new String[0]);
            boolean bl3 = false;
            rows.add(it4);
            ++this.rowCount;
            if (this.rowCount <= MAX_ROW_BUFFER) continue;
            sb.append(this.formatRows(rows, numColumns));
            sb.append("\n");
            rows.clear();
        }
        sb.append(this.formatRows(rows, numColumns));
        sb.append("\n");
        rows.clear();
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getResultAsList() {
        OpenMapTable.Metadata meta = this.table.getMetadata();
        int longestLabel = 0;
        int numColumns = meta.getColumns().length;
        List columns = new ArrayList();
        for (int i = 0; i < numColumns; ++i) {
            String name = meta.getColumns()[i + 1].getName();
            columns.set(i, name);
            longestLabel = Math.max(longestLabel, name.length());
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = this.table.getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenMapTable.Row it = (OpenMapTable.Row)element$iv;
            boolean bl = false;
            int n = this.rowCount;
            this.rowCount = n + 1;
            sb.setLength(0);
            if (this.rowCount > 1) {
                sb.append("");
            }
            for (int i = 0; i < numColumns; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(StringUtils.rightPad((String)(columns.get(i) + ":"), (int)(15 + longestLabel))).append(String.valueOf(it.get(i + 1)));
            }
            sb.append("\n");
        }
        if (this.rowCount == 0) {
            String s2 = CollectionsKt.joinToString$default((Iterable)columns, (CharSequence)"\n", null, null, (int)0, null, (Function1)resultAsList.s.1.INSTANCE, (int)30, null);
            sb.append(s2).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String formatRows(ArrayList<String[]> rows, int numColumns) {
        int[] columnSizes = new int[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int max = 0;
            for (String[] row : rows) {
                max = Math.max(max, row[i].length());
            }
            if (numColumns > 1) {
                max = Math.min(MAX_COLUMN_LENGTH, max);
            }
            columnSizes[i] = max;
        }
        StringBuilder buff = new StringBuilder();
        for (String[] row : rows) {
            for (int i = 0; i < numColumns; ++i) {
                if (i > 0) {
                    buff.append(' ').append(BOX_VERTICAL).append(' ');
                }
                String s2 = row[i];
                buff.append(s2);
                if (i >= numColumns - 1) continue;
                int n = columnSizes[i];
                for (int j = s2.length(); j < n; ++j) {
                    buff.append(' ');
                }
            }
            buff.append("\n");
        }
        String string = buff.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return OpenMapAnyTableFormatter.format$default(this, false, 1, null) + "Total " + this.rowCount + " rows";
    }

    @JvmOverloads
    @NotNull
    public final String format() {
        return OpenMapAnyTableFormatter.format$default(this, false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/common/OpenMapAnyTableFormatter$Companion;", "", "()V", "BOX_VERTICAL", "", "getBOX_VERTICAL", "()C", "setBOX_VERTICAL", "(C)V", "MAX_COLUMN_LENGTH", "", "getMAX_COLUMN_LENGTH", "()I", "setMAX_COLUMN_LENGTH", "(I)V", "MAX_ROW_BUFFER", "getMAX_ROW_BUFFER", "setMAX_ROW_BUFFER", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_ROW_BUFFER() {
            return MAX_ROW_BUFFER;
        }

        public final void setMAX_ROW_BUFFER(int n) {
            MAX_ROW_BUFFER = n;
        }

        public final int getMAX_COLUMN_LENGTH() {
            return MAX_COLUMN_LENGTH;
        }

        public final void setMAX_COLUMN_LENGTH(int n) {
            MAX_COLUMN_LENGTH = n;
        }

        public final char getBOX_VERTICAL() {
            return BOX_VERTICAL;
        }

        public final void setBOX_VERTICAL(char c) {
            BOX_VERTICAL = c;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

