/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ScoreEntry;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.math3.analysis.function.Sigmoid;

public class ScoreVector
implements Comparable<ScoreVector> {
    private final int dimension;
    private final ArrayList<ScoreEntry> entries;
    public static ScoreVector ZERO = new ScoreVector(0);

    public ScoreVector(int dimension) {
        this.dimension = dimension;
        this.entries = new ArrayList(dimension);
        for (int i = 0; i < dimension; ++i) {
            this.entries.add(new ScoreEntry("s" + i, i, 0, 0));
        }
    }

    public ScoreVector(String dimensionStr, int ... scores) {
        this(Integer.parseInt(dimensionStr), Ints.asList((int[])scores));
    }

    public ScoreVector(int dimension, Collection<Integer> scores) {
        Integer[] list2 = scores.toArray(new Integer[0]);
        if (dimension != list2.length) {
            throw new IllegalArgumentException("Illegal dimension");
        }
        this.dimension = dimension;
        this.entries = new ArrayList(dimension);
        for (int i = 0; i < dimension; ++i) {
            this.entries.add(new ScoreEntry("s" + i, i, list2[i], 0));
        }
    }

    public ScoreVector(int dimension, ScoreEntry ... scores) {
        if (dimension != scores.length) {
            throw new IllegalArgumentException("Illegal dimension");
        }
        this.dimension = dimension;
        this.entries = new ArrayList(dimension);
        this.entries.addAll(Arrays.asList(scores));
    }

    public ScoreVector(int dimension, List<ScoreEntry> scores) {
        if (dimension != scores.size()) {
            throw new IllegalArgumentException("Illegal dimension");
        }
        this.dimension = dimension;
        this.entries = new ArrayList<ScoreEntry>(scores);
    }

    public static ScoreVector create(ScoreVector template) {
        List<ScoreEntry> newEntries = template.entries.stream().map(ScoreEntry::clone).collect(Collectors.toList());
        newEntries.forEach(scoreEntry -> scoreEntry.setValue(0));
        return new ScoreVector(template.dimension, newEntries);
    }

    public static ScoreVector parse(String multiValueScore) throws IllegalFormatException {
        String[] parts = multiValueScore.split(",");
        ScoreVector score = new ScoreVector(parts.length);
        for (int i = 0; i < parts.length; ++i) {
            score.setValue(i, Integer.parseInt(parts[i]));
        }
        return score;
    }

    public static ScoreVector combine(ScoreVector s1, ScoreVector s2) {
        ArrayList<ScoreEntry> entries = new ArrayList<ScoreEntry>();
        entries.addAll(s1.entries);
        entries.addAll(s2.entries);
        return new ScoreVector(entries.size(), (List<ScoreEntry>)entries);
    }

    public static ScoreVector add(ScoreVector ... scores) {
        ArrayList<ScoreEntry> entries = new ArrayList<ScoreEntry>();
        for (ScoreVector score : scores) {
            entries.addAll(score.entries);
        }
        return new ScoreVector(entries.size(), (List<ScoreEntry>)entries);
    }

    public List<ScoreEntry> getEntries() {
        return this.entries;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getDigits() {
        return this.entries.stream().mapToInt(ScoreEntry::getDigits).sum();
    }

    public int size() {
        assert (this.dimension == this.entries.size());
        return this.entries.size();
    }

    public void setValue(int i, int value) {
        this.get(i).setValue(value);
    }

    public void setValue(int i, float value) {
        this.get(i).setValue((int)value);
    }

    public void setValue(int i, double value) {
        this.get(i).setValue((int)value);
    }

    public void setValue(int ... values) {
        for (int i = 0; i < values.length && i < this.entries.size(); ++i) {
            this.entries.get(i).setValue(values[i]);
        }
    }

    public ScoreEntry get(int i) {
        return this.entries.get(i);
    }

    public ScoreVector clone() {
        List<ScoreEntry> newEntries = this.entries.stream().map(ScoreEntry::clone).collect(Collectors.toList());
        return new ScoreVector(this.dimension, newEntries);
    }

    public double toDouble() {
        Sigmoid sig = new Sigmoid(0.0, 1.0);
        double sum = 0.0;
        for (ScoreEntry entry : this.entries) {
            double s2 = entry.getValue();
            s2 = sig.value(s2);
            s2 = (int)Math.min(100.0 * s2, 99.0);
            sum = 100.0 * sum + s2;
        }
        return sum;
    }

    @Override
    public int compareTo(@Nonnull ScoreVector other) {
        if (this.size() != other.size()) {
            return this.size() - other.size();
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            ScoreEntry v2;
            ScoreEntry v1 = this.entries.get(i);
            int comp = v1.compareTo(v2 = other.entries.get(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int hash = 1;
        for (ScoreEntry scoreEntry : this.entries) {
            hash = 31 * hash + scoreEntry.getValue();
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScoreVector)) {
            return false;
        }
        return this.compareTo((ScoreVector)other) == 0;
    }

    public String toString() {
        return this.entries.stream().map(ScoreEntry::getValue).map(String::valueOf).collect(Collectors.joining(","));
    }
}

