/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.ChainedDataCollector;
import ai.platon.pulsar.common.collect.ConcurrentLoadingIterable;
import ai.platon.pulsar.common.collect.DelayCacheCollector;
import ai.platon.pulsar.common.collect.DelayUrl;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.UrlFeeder;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.collect.collector.AbstractPriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollectorsFormatter;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.urls.UrlAware;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010/\u001a\u00020\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017J\u001a\u00101\u001a\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u0001J\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0002J\u000e\u00106\u001a\u0002042\u0006\u00105\u001a\u00020\u0002J\u0006\u00107\u001a\u000204J\u0010\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0006H\u0002J\u000e\u0010:\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0006J\u001a\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00162\u0006\u0010<\u001a\u00020\u000bJ \u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00162\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001J\u001a\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00162\u0006\u0010>\u001a\u00020?J\u001a\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00162\u0006\u0010<\u001a\u00020\u000bJ\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020BH\u0096\u0002J\u0014\u0010C\u001a\u00020\b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020DJ\u001a\u0010E\u001a\u00020\b2\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020D0&R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R\u001d\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00170&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006F"}, d2={"Lai/platon/pulsar/common/collect/UrlFeeder;", "", "Lai/platon/pulsar/common/urls/UrlAware;", "urlPool", "Lai/platon/pulsar/common/collect/UrlPool;", "lowerCacheSize", "", "enableDefaults", "", "(Lai/platon/pulsar/common/collect/UrlPool;IZ)V", "abstract", "", "getAbstract", "()Ljava/lang/String;", "cacheSize", "getCacheSize", "()I", "chainedDataCollector", "Lai/platon/pulsar/common/collect/ChainedDataCollector;", "getChainedDataCollector", "()Lai/platon/pulsar/common/collect/ChainedDataCollector;", "collectors", "", "Lai/platon/pulsar/common/collect/collector/PriorityDataCollector;", "getCollectors", "()Ljava/util/List;", "delayCollector", "Lai/platon/pulsar/common/collect/DelayCacheCollector;", "getEnableDefaults", "()Z", "loadingIterable", "Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable;", "getLoadingIterable", "()Lai/platon/pulsar/common/collect/ConcurrentLoadingIterable;", "logger", "Lorg/slf4j/Logger;", "getLowerCacheSize", "openCollectors", "", "getOpenCollectors", "()Ljava/util/Collection;", "realTimeCollector", "Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "report", "getReport", "getUrlPool", "()Lai/platon/pulsar/common/collect/UrlPool;", "addCollector", "collector", "addCollectors", "addDefaultCollectors", "addFirst", "", "url", "addLast", "clear", "doEstimatedOrder", "priority", "estimatedOrder", "findByName", "name", "names", "regex", "Lkotlin/text/Regex;", "findByNameLike", "iterator", "", "remove", "Lai/platon/pulsar/common/collect/collector/DataCollector;", "removeAll", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlFeeder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFeeder.kt\nai/platon/pulsar/common/collect/UrlFeeder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n1045#3:150\n1774#3,4:151\n1774#3,4:155\n766#3:159\n857#3,2:160\n1855#3,2:162\n766#3:164\n857#3,2:165\n766#3:167\n857#3,2:168\n766#3:170\n857#3,2:171\n*S KotlinDebug\n*F\n+ 1 UrlFeeder.kt\nai/platon/pulsar/common/collect/UrlFeeder\n*L\n46#1:150\n87#1:151,4\n90#1:155,4\n93#1:159\n93#1:160,2\n101#1:162,2\n118#1:164\n118#1:165,2\n122#1:167\n122#1:168,2\n126#1:170\n126#1:171,2\n*E\n"})
public final class UrlFeeder
implements Iterable<UrlAware>,
KMappedMarker {
    @NotNull
    private final UrlPool urlPool;
    private final int lowerCacheSize;
    private final boolean enableDefaults;
    @NotNull
    private final Logger logger;
    @NotNull
    private final UrlCacheCollector realTimeCollector;
    @NotNull
    private final DelayCacheCollector delayCollector;
    @NotNull
    private final ConcurrentLoadingIterable<UrlAware> loadingIterable;

    /*
     * WARNING - void declaration
     */
    public UrlFeeder(@NotNull UrlPool urlPool, int lowerCacheSize, boolean enableDefaults) {
        void $this$delayCollector_u24lambda_u241;
        AbstractPriorityDataCollector $this$realTimeCollector_u24lambda_u240;
        AbstractPriorityDataCollector abstractPriorityDataCollector;
        Intrinsics.checkNotNullParameter((Object)urlPool, (String)"urlPool");
        this.urlPool = urlPool;
        this.lowerCacheSize = lowerCacheSize;
        this.enableDefaults = enableDefaults;
        this.logger = LogsKt.getLogger(this);
        UrlCacheCollector urlCacheCollector = abstractPriorityDataCollector = new UrlCacheCollector(this.urlPool.getRealTimeCache());
        UrlFeeder urlFeeder = this;
        boolean bl = false;
        $this$realTimeCollector_u24lambda_u240.setName("FCC#RealTime");
        urlFeeder.realTimeCollector = abstractPriorityDataCollector;
        $this$realTimeCollector_u24lambda_u240 = abstractPriorityDataCollector = new DelayCacheCollector(this.urlPool.getDelayCache(), Priority13.HIGHER5);
        urlFeeder = this;
        boolean bl2 = false;
        $this$delayCollector_u24lambda_u241.setName("DelayCC#Delay");
        urlFeeder.delayCollector = abstractPriorityDataCollector;
        this.loadingIterable = new ConcurrentLoadingIterable(new ChainedDataCollector(null, 1, null), this.realTimeCollector, this.delayCollector, this.lowerCacheSize, 0, 16, null);
        if (this.enableDefaults && this.getOpenCollectors().isEmpty()) {
            this.addDefaultCollectors();
        }
    }

    public /* synthetic */ UrlFeeder(UrlPool urlPool, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(urlPool, n, bl);
    }

    @NotNull
    public final UrlPool getUrlPool() {
        return this.urlPool;
    }

    public final int getLowerCacheSize() {
        return this.lowerCacheSize;
    }

    public final boolean getEnableDefaults() {
        return this.enableDefaults;
    }

    @NotNull
    public final ConcurrentLoadingIterable<UrlAware> getLoadingIterable() {
        return this.loadingIterable;
    }

    public final int getCacheSize() {
        return this.loadingIterable.getCacheSize();
    }

    private final ChainedDataCollector<UrlAware> getChainedDataCollector() {
        DataCollector<UrlAware> dataCollector = this.loadingIterable.getRegularCollector();
        Intrinsics.checkNotNull(dataCollector, (String)"null cannot be cast to non-null type ai.platon.pulsar.common.collect.ChainedDataCollector<ai.platon.pulsar.common.urls.UrlAware>");
        return (ChainedDataCollector)dataCollector;
    }

    @NotNull
    public final Collection<PriorityDataCollector<UrlAware>> getOpenCollectors() {
        return this.getChainedDataCollector().getCollectors();
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> getCollectors() {
        List list2;
        List it = list2 = (List)new ArrayList();
        boolean bl = false;
        ((Collection)it).add(this.realTimeCollector);
        ((Collection)it).add(this.delayCollector);
        CollectionsKt.addAll((Collection)it, (Iterable)this.getOpenCollectors());
        Iterable $this$sortedBy$iv = list2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PriorityDataCollector it = (PriorityDataCollector)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (PriorityDataCollector)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
    }

    @NotNull
    public final String getAbstract() {
        return new PriorityDataCollectorsFormatter((Collection)this.getCollectors()).abstract();
    }

    @NotNull
    public final String getReport() {
        return new PriorityDataCollectorsFormatter((Collection)this.getCollectors()).toString();
    }

    public final void addFirst(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.loadingIterable.addFirst(url);
    }

    public final void addLast(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.loadingIterable.addLast(url);
    }

    @Override
    @NotNull
    public Iterator<UrlAware> iterator() {
        return this.loadingIterable.iterator();
    }

    public final int estimatedOrder(int priority) {
        Serializable serializable;
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)this.doEstimatedOrder(priority));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = serializable = throwable;
            boolean bl = false;
            this.logger.warn(ExceptionsKt.stringify$default(it, null, null, 3, null));
        }
        serializable = Integer.valueOf(-2);
        return ((Number)(Result.isFailure-impl((Object)object) ? serializable : object)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final int doEstimatedOrder(int priority) {
        void $this$filterTo$iv$iv;
        int delayQueueCount;
        DelayUrl it;
        int count$iv;
        int n;
        int n2;
        int n3;
        Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getCollectors()), (Function1)((Function1)new Function1<PriorityDataCollector<UrlAware>, Boolean>(priority){
            final /* synthetic */ int $priority;
            {
                this.$priority = $priority;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PriorityDataCollector<UrlAware> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getPriority() < this.$priority;
            }
        })), (Function1)doEstimatedOrder.priorCount.2.INSTANCE);
        int n4 = 0;
        for (Object e : sequence) {
            void it2;
            PriorityDataCollector priorityDataCollector = (PriorityDataCollector)e;
            n3 = n4;
            boolean bl = false;
            n2 = it2.getSize();
            n4 = n3 + n2;
        }
        int priorCount2 = n4;
        long now = System.currentTimeMillis();
        double speed = 1.0;
        Iterable $this$count$iv = this.delayCollector.getQueue();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (DelayUrl)element$iv;
                boolean bl = false;
                if (!((double)(it.getDelayExpireAt() - now) < speed * (double)priorCount2) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = delayQueueCount = count$iv;
        }
        if (delayQueueCount == 0) {
            int n5;
            $this$count$iv = this.delayCollector.getQueue();
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (DelayUrl)element$iv;
                    boolean bl = false;
                    if (!(it.getDelayExpireAt() - now < 15000L) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            delayQueueCount = n5;
        }
        Iterable $this$filter$iv = this.getCollectors();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it3 = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!(it3.getPriority() == priority)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List competitorCollectors = (List)destination$iv$iv;
        Iterable iterable = competitorCollectors;
        int n6 = 0;
        for (Object t : iterable) {
            void it4;
            PriorityDataCollector bl = (PriorityDataCollector)t;
            n3 = n6;
            boolean bl2 = false;
            n2 = it4.getSize();
            n6 = n3 + n2;
        }
        int competitorCount = n6;
        return priorCount2 + delayQueueCount + competitorCount / competitorCollectors.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UrlFeeder addDefaultCollectors() {
        this.getChainedDataCollector().getCollectors().removeIf(arg_0 -> UrlFeeder.addDefaultCollectors$lambda$11(addDefaultCollectors.1.INSTANCE, arg_0));
        Iterable $this$forEach$iv = this.urlPool.getOrderedCaches().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$addDefaultCollectors_u24lambda_u2413_u24lambda_u2412;
            UrlCacheCollector urlCacheCollector;
            UrlCache urlCache2 = (UrlCache)element$iv;
            boolean bl = false;
            UrlCacheCollector urlCacheCollector2 = urlCacheCollector = new UrlCacheCollector(urlCache2);
            UrlFeeder urlFeeder = this;
            boolean bl2 = false;
            $this$addDefaultCollectors_u24lambda_u2413_u24lambda_u2412.setName("FCC." + $this$addDefaultCollectors_u24lambda_u2413_u24lambda_u2412.getId());
            urlFeeder.addCollector(urlCacheCollector);
        }
        return this;
    }

    @NotNull
    public final UrlFeeder addCollector(@NotNull PriorityDataCollector<UrlAware> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        ((Collection)this.getChainedDataCollector().getCollectors()).add(collector);
        return this;
    }

    @NotNull
    public final UrlFeeder addCollectors(@NotNull Iterable<? extends PriorityDataCollector<UrlAware>> collectors) {
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        CollectionsKt.addAll((Collection)this.getChainedDataCollector().getCollectors(), collectors);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull String name) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = this.getChainedDataCollector().getCollectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull Iterable<String> names) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$filter$iv = this.getChainedDataCollector().getCollectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains(names, (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull Regex regex) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Iterable $this$filter$iv = this.getChainedDataCollector().getCollectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!regex.matches((CharSequence)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByNameLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.findByName(new Regex(".*" + name + ".*"));
    }

    public final boolean remove(@NotNull DataCollector<UrlAware> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        return TypeIntrinsics.asMutableCollection((Object)this.getChainedDataCollector().getCollectors()).remove(collector);
    }

    public final boolean removeAll(@NotNull Collection<? extends DataCollector<UrlAware>> collectors) {
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        return TypeIntrinsics.asMutableCollection((Object)this.getChainedDataCollector().getCollectors()).removeAll(collectors);
    }

    public final void clear() {
        this.loadingIterable.clear();
        this.realTimeCollector.getUrlCache().clear();
        this.delayCollector.getQueue().clear();
        this.getChainedDataCollector().clear();
    }

    private static final boolean addDefaultCollectors$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

