/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.collector;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.collector.AbstractDataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\rH\u0016R\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/common/collect/collector/AbstractPriorityDataCollector;", "T", "Lai/platon/pulsar/common/collect/collector/AbstractDataCollector;", "Lai/platon/pulsar/common/collect/collector/PriorityDataCollector;", "priority", "Lai/platon/pulsar/common/Priority13;", "(Lai/platon/pulsar/common/Priority13;)V", "", "(I)V", "capacity", "getCapacity", "()I", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPriority", "toString", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nDataCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataCollector.kt\nai/platon/pulsar/common/collect/collector/AbstractPriorityDataCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
public abstract class AbstractPriorityDataCollector<T>
extends AbstractDataCollector<T>
implements PriorityDataCollector<T> {
    private final int priority;
    private final int capacity;
    @NotNull
    private String name;

    public AbstractPriorityDataCollector(int priority) {
        this.priority = priority;
        this.capacity = 1000;
        this.name = "PriorityDC";
    }

    public /* synthetic */ AbstractPriorityDataCollector(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Priority13.NORMAL.getValue();
        }
        this(n);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public AbstractPriorityDataCollector(@NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        this(priority.getValue());
    }

    @Override
    @NotNull
    public String toString() {
        Object object;
        long elapsedSeconds;
        block3: {
            block2: {
                elapsedSeconds = RangesKt.coerceAtLeast((long)this.getCollectTime().getSeconds(), (long)1L);
                object = Priority13.Companion.valueOfOrNull(this.getPriority());
                if (object == null) break block2;
                Priority13 it = object;
                boolean bl = false;
                String string = it + ", " + this.getPriority();
                object = string;
                if (string != null) break block3;
            }
            object = String.valueOf(this.getPriority());
        }
        Object priorityName = object;
        String string = "%s(%s) - collected %s/%s/%s/%s in %s, remaining %s/%s, collect time: %s -> %s %s";
        Object[] objectArray = new Object[12];
        objectArray[0] = this.getName();
        objectArray[1] = priorityName;
        objectArray[2] = this.getCollectedCount();
        String string2 = "%.2f";
        Object[] objectArray2 = new Object[]{1.0 * (double)this.getCollectedCount() / (double)elapsedSeconds};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        objectArray[4] = this.getCollectCount();
        string2 = "%.2f";
        objectArray2 = new Object[]{1.0 * (double)this.getCollectCount() / (double)elapsedSeconds};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        objectArray[6] = DateTimesKt.readable(this.getCollectTime());
        objectArray[7] = this.getSize();
        objectArray[8] = this.getEstimatedSize();
        objectArray[9] = this.getFirstCollectTime();
        objectArray[10] = this.getLastCollectedTime();
        objectArray[11] = CollectionsKt.joinToString$default((Iterable)this.getLabels(), null, null, null, (int)0, null, null, (int)63, null);
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @Override
    public int compareTo(@NotNull PriorityDataCollector<T> other) {
        return PriorityDataCollector.DefaultImpls.compareTo(this, other);
    }

    public AbstractPriorityDataCollector() {
        this(0, 1, null);
    }
}

