/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect.collector;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.Loadable;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.collector.AbstractPriorityDataCollector;
import ai.platon.pulsar.common.collect.queue.LoadingQueue;
import ai.platon.pulsar.common.urls.UrlAware;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0016J$\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0002J\b\u0010'\u001a\u00020 H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00180\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "Lai/platon/pulsar/common/collect/collector/AbstractPriorityDataCollector;", "Lai/platon/pulsar/common/urls/UrlAware;", "urlCache", "Lai/platon/pulsar/common/collect/UrlCache;", "(Lai/platon/pulsar/common/collect/UrlCache;)V", "estimatedExternalSize", "", "getEstimatedExternalSize", "()I", "estimatedSize", "getEstimatedSize", "externalSize", "getExternalSize", "logger", "Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "queues", "", "Ljava/util/Queue;", "getQueues", "()Ljava/util/List;", "size", "getSize", "getUrlCache", "()Lai/platon/pulsar/common/collect/UrlCache;", "clear", "", "collectTo", "sink", "", "consume", "queue", "", "deepClear", "dump", "hasMore", "", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlCacheCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlCacheCollector.kt\nai/platon/pulsar/common/collect/collector/UrlCacheCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n1360#3:94\n1446#3,2:95\n1549#3:97\n1620#3,3:98\n1448#3,3:101\n*S KotlinDebug\n*F\n+ 1 UrlCacheCollector.kt\nai/platon/pulsar/common/collect/collector/UrlCacheCollector\n*L\n81#1:94\n81#1:95,2\n81#1:97\n81#1:98,3\n81#1:101,3\n*E\n"})
public class UrlCacheCollector
extends AbstractPriorityDataCollector<UrlAware> {
    @NotNull
    private final UrlCache urlCache;
    @NotNull
    private final Logger logger;
    @NotNull
    private String name;

    public UrlCacheCollector(@NotNull UrlCache urlCache2) {
        Intrinsics.checkNotNullParameter((Object)urlCache2, (String)"urlCache");
        super(urlCache2.getPriority());
        this.urlCache = urlCache2;
        this.logger = LogsKt.getLogger(this);
        this.name = "FCC";
    }

    @NotNull
    public final UrlCache getUrlCache() {
        return this.urlCache;
    }

    private final List<Queue<UrlAware>> getQueues() {
        return this.urlCache.getQueues();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    public int getSize() {
        return this.urlCache.getSize();
    }

    @Override
    public int getExternalSize() {
        return this.urlCache.getExternalSize();
    }

    @Override
    public int getEstimatedExternalSize() {
        return this.urlCache.getEstimatedExternalSize();
    }

    @Override
    public int getEstimatedSize() {
        return this.urlCache.getEstimatedSize();
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.getSize() > 0) {
            return true;
        }
        if (this.getDeadTime().compareTo(Instant.now()) <= 0) {
            return false;
        }
        if (this.getEstimatedSize() > 0 && this.urlCache instanceof Loadable) {
            this.logger.debug("Loading tasks with estimatedSize be {}", (Object)this.getEstimatedSize());
            ((Loadable)((Object)this.urlCache)).loadNow();
        }
        return this.getSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int collectTo(@NotNull List<UrlAware> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.beforeCollect();
        Iterable iterable = this.getQueues();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Queue queue = (Queue)t;
            int n2 = n;
            boolean bl = false;
            int n3 = this.consume((Queue<UrlAware>)it, (Collection<UrlAware>)sink);
            n = n2 + n3;
        }
        int count2 = n;
        return this.afterCollect(count2);
    }

    private final int consume(Queue<UrlAware> queue, Collection<UrlAware> sink) {
        if (queue instanceof LoadingQueue && queue.size() == 0 && ((LoadingQueue)queue).getEstimatedExternalSize() == 0) {
            return 0;
        }
        UrlAware e = queue.poll();
        if (e != null) {
            this.getLabels().add(e.getLabel());
            sink.add(e);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized List<String> dump() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getQueues();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Queue it = (Queue)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = it;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                UrlAware urlAware = (UrlAware)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it2.toString());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public synchronized void clear() {
        this.urlCache.clear();
    }

    @Override
    public synchronized void deepClear() {
        this.urlCache.deepClear();
    }
}

