/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Params {
    public static final Params EMPTY_PARAMS = new Params();
    private Logger log = LoggerFactory.getLogger(Params.class);
    private List<Pair<String, Object>> paramsList = new LinkedList<Pair<String, Object>>();
    private String captionFormat = String.format("%20sParams Table%-25s\n", "----------", "----------");
    private String headerFormat = String.format("%25s   %-25s\n", "Name", "Value");
    private String rowFormat = "%25s: %s";
    private boolean cmdLineStyle = false;
    private List<String> distinctBooleanParams;
    private String pairDelimiter = " ";
    private String kvDelimiter = ": ";
    private Logger defaultLog = null;

    public Params() {
    }

    public Params(String key, Object value, Object ... others) {
        this.paramsList.addAll(Params.toArgList(key, value, others));
    }

    public Params(Map<String, Object> args) {
        args.forEach((key, value) -> this.paramsList.add((Pair<String, Object>)Pair.of((Object)key, (Object)value)));
    }

    public static Params of(String key, Object value, Object ... others) {
        return new Params(key, value, others);
    }

    public static Params of(Map<String, Object> args) {
        return new Params(args);
    }

    public static List<Pair<String, Object>> toArgList(String key, Object value, Object ... others) {
        LinkedList<Pair<String, Object>> results = new LinkedList<Pair<String, Object>>();
        results.add(Pair.of((Object)key, (Object)value));
        if (others == null || others.length < 2) {
            return results;
        }
        if (others.length % 2 != 0) {
            throw new RuntimeException("expected name/value pairs");
        }
        for (int i = 0; i < others.length; i += 2) {
            Object k = others[i];
            Object v = others[i + 1];
            if (k == null || v == null) continue;
            results.add((Pair<String, Object>)Pair.of((Object)String.valueOf(others[i]), (Object)others[i + 1]));
        }
        return results;
    }

    public static Map<String, Object> toArgMap(String key, Object value, Object ... others) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.put(key, value);
        if (others == null || others.length < 2) {
            return results;
        }
        if (others.length % 2 != 0) {
            throw new RuntimeException("expected name/value pairs");
        }
        for (int i = 0; i < others.length; i += 2) {
            Object k = others[i];
            Object v = others[i + 1];
            if (k == null || v == null) continue;
            results.put(String.valueOf(others[i]), others[i + 1]);
        }
        return results;
    }

    public static String formatAsLine(String key, Object value, Object ... others) {
        return Params.of(key, value, others).formatAsLine();
    }

    public static String format(String key, Object value, Object ... others) {
        return Params.of(key, value, others).format();
    }

    public void put(String name, Object value) {
        this.paramsList.add((Pair<String, Object>)Pair.of((Object)name, (Object)value));
    }

    public boolean remove(String key) {
        boolean removed;
        List list2 = this.paramsList.stream().filter((? super T entry) -> !((String)entry.getKey()).equals(key)).collect(Collectors.toList());
        boolean bl = removed = list2.size() < this.paramsList.size();
        if (removed) {
            this.paramsList = list2;
        }
        return removed;
    }

    public Object get(String name) {
        Pair entry = (Pair)CollectionUtils.find(this.paramsList, e -> ((String)e.getKey()).equals(name));
        return entry == null ? null : entry.getValue();
    }

    public String get(String name, String defaultValue) {
        String value = (String)this.get(name);
        return value == null ? defaultValue : value;
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        Object val = this.get(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val.toString());
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Integer getInt(String name, Integer defaultValue) {
        Integer value = (Integer)this.get(name);
        return value == null ? defaultValue : value;
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Long getLong(String name, Long defaultValue) {
        Long value = (Long)this.get(name);
        return value == null ? defaultValue : value;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        Boolean value = (Boolean)this.get(name);
        return value == null ? defaultValue : value;
    }

    public String[] getStrings(String name, String[] defaultValue) {
        String valueString = this.get(name, null);
        if (valueString == null) {
            return defaultValue;
        }
        return Strings.getStrings(valueString);
    }

    public Collection<String> getStringCollection(String name, String delim) {
        String valueString = this.get(name, null);
        return Strings.getStringCollection(valueString, delim);
    }

    public Path getPath(String name) throws IOException {
        String value = this.getString(name);
        if (value == null) {
            return null;
        }
        Path path = Paths.get(value, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public Path getPath(String name, Path defaultValue) throws IOException {
        String value = this.getString(name);
        Path path = value == null ? Paths.get(value, new String[0]) : defaultValue;
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public Instant getInstant(String name) {
        return (Instant)this.get(name);
    }

    public Instant getInstant(String name, Instant defaultValue) {
        Instant value = (Instant)this.get(name);
        return value == null ? defaultValue : value;
    }

    public Duration getDuration(String name) {
        return (Duration)this.get(name);
    }

    public Duration getDuration(String name, Duration defaultValue) {
        Duration value = (Duration)this.get(name);
        return value == null ? defaultValue : value;
    }

    public String format() {
        return this.format(this.paramsList);
    }

    public String formatAsLine() {
        return this.formatAsLine(this.paramsList);
    }

    public Params withCaptionFormat(String captionFormat) {
        this.captionFormat = captionFormat;
        return this;
    }

    public Params withHeaderFormat(String headerFormat) {
        this.headerFormat = headerFormat;
        return this;
    }

    public Params withRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
        return this;
    }

    public Params withPairDelimiter(String pairDelimiter) {
        this.pairDelimiter = pairDelimiter;
        return this;
    }

    public Params withKVDelimiter(String kvDelimiter) {
        this.kvDelimiter = kvDelimiter;
        return this;
    }

    public boolean isCmdLineStyle() {
        return this.cmdLineStyle;
    }

    public Params withCmdLineStyle() {
        return this.withCmdLineStyle(true);
    }

    public Params withCmdLineStyle(boolean isCmdLineStyle) {
        this.cmdLineStyle = isCmdLineStyle;
        return this;
    }

    public Params withDistinctBooleanParams(List<String> distinctBooleanParams) {
        this.distinctBooleanParams = distinctBooleanParams;
        return this;
    }

    public Params sorted() {
        this.paramsList = this.paramsList.stream().sorted(Comparator.comparing(Pair::getKey)).collect(Collectors.toList());
        return this;
    }

    public Params filter(Predicate<Pair<String, Object>> predicate) {
        this.paramsList = this.paramsList.stream().filter(predicate).collect(Collectors.toList());
        return this;
    }

    public Params distinct() {
        this.paramsList = this.paramsList.stream().distinct().collect(Collectors.toList());
        return this;
    }

    public Params merge(Params ... others) {
        if (others != null && others.length > 0) {
            Arrays.stream(others).forEach(params -> this.paramsList.addAll(params.getParamsList()));
        }
        return this;
    }

    public Params merge(Collection<Params> others) {
        others.forEach(params -> this.paramsList.addAll(params.getParamsList()));
        return this;
    }

    public List<Pair<String, Object>> getParamsList() {
        return this.paramsList;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.paramsList.forEach(p -> result.put((String)p.getKey(), p.getValue()));
        return result;
    }

    public Map<String, String> asStringMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.paramsList.forEach(p -> result.put((String)p.getKey(), p.getValue().toString()));
        return result;
    }

    public Params withLogger(Logger logger) {
        this.defaultLog = logger;
        return this;
    }

    public void debug() {
        this.debug(false);
    }

    public void debug(boolean inline) {
        if (this.defaultLog != null) {
            this.defaultLog.debug(inline ? this.formatAsLine() : this.format());
        } else {
            this.log.debug(inline ? this.formatAsLine() : this.format());
        }
    }

    public void info() {
        this.info(false);
    }

    public void info(boolean inline) {
        this.info("", "", inline);
    }

    public void info(String prefix, String postfix, boolean inline) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(inline ? this.formatAsLine() : this.format());
        sb.append(postfix);
        if (this.defaultLog != null) {
            this.defaultLog.info(sb.toString());
        } else {
            this.log.info(sb.toString());
        }
    }

    public String toString() {
        return this.format();
    }

    private String format(List<Pair<String, Object>> params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        if (this.captionFormat != null) {
            sb.append(this.captionFormat);
        }
        if (this.headerFormat != null) {
            sb.append(this.headerFormat);
        }
        int i = 0;
        for (Pair<String, Object> param : params) {
            if (i++ > 0) {
                sb.append("\n");
            }
            String key = (String)param.getKey();
            Object value = param.getValue();
            if (value instanceof Map) {
                Map m = (Map)value;
                value = m.entrySet().stream().map(e -> String.valueOf(e.getKey()) + ":" + e.getValue().toString()).collect(Collectors.joining(", "));
            } else if (value instanceof Collection) {
                Collection c = (Collection)value;
                value = StringUtils.join((Iterable)c, (String)", ");
            }
            sb.append(String.format(this.rowFormat, key, value));
        }
        sb.append('\n');
        return sb.toString();
    }

    private String formatAsLine(List<Pair<String, Object>> params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Pair<String, Object> arg : params) {
            if (i++ > 0) {
                sb.append(this.pairDelimiter);
            }
            String key = (String)arg.getKey();
            String value = arg.getValue().toString();
            if (arg.getValue() == null) {
                sb.append(key);
                if (this.cmdLineStyle) continue;
                sb.append(this.kvDelimiter);
                sb.append("null");
                continue;
            }
            if (this.cmdLineStyle && key.startsWith("-") && "true".equals(value)) {
                if (this.distinctBooleanParams != null && this.distinctBooleanParams.contains(key)) {
                    sb.append(key);
                    sb.append(this.kvDelimiter);
                    sb.append("true");
                    continue;
                }
                sb.append(key);
                continue;
            }
            if (this.cmdLineStyle && key.startsWith("-") && "false".equals(value)) {
                if (this.distinctBooleanParams == null || !this.distinctBooleanParams.contains(key)) continue;
                sb.append(key);
                sb.append(this.kvDelimiter);
                sb.append("false");
                continue;
            }
            sb.append(key);
            if (value.isEmpty()) continue;
            sb.append(this.kvDelimiter);
            if (value.contains(this.kvDelimiter) && !value.startsWith("\"") && !value.endsWith("\"")) {
                sb.append('\"').append(value).append('\"');
                continue;
            }
            sb.append(value);
        }
        return sb.toString().trim();
    }
}

