/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyEntry2;
import ai.platon.pulsar.common.proxy.ProxyType;
import ai.platon.pulsar.common.urls.UrlUtils;
import com.google.common.collect.ConcurrentHashMultiset;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(message="Use ProxyEntry2 instead", replaceWith=@ReplaceWith(expression="ProxyEntry2", imports={}))
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00b6\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0006\u00b5\u0001\u00b6\u0001\u00b7\u0001B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u009e\u0001\u001a\u00020\u00052\u0007\u0010\u009f\u0001\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u00a0\u0001\u001a\u00020\u00152\n\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a1\u0001H\u0096\u0002J\t\u0010\u00a2\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u00a3\u0001\u001a\u00020\u0003H\u0002J\t\u0010\u00a4\u0001\u001a\u00020\u0005H\u0016J\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001J\b\u0010\u00a7\u0001\u001a\u00030\u00a6\u0001J\u0007\u0010\u00a8\u0001\u001a\u00020\u0003J\b\u0010\u00a9\u0001\u001a\u00030\u00a6\u0001J\b\u0010\u00aa\u0001\u001a\u00030\u00a6\u0001J\u0007\u0010\u00ab\u0001\u001a\u00020\u0015J\u001b\u0010\u00ab\u0001\u001a\u00020\u00152\u0007\u0010\u00ac\u0001\u001a\u00020\u00122\t\b\u0002\u0010\u00ad\u0001\u001a\u000200J\b\u0010\u00ae\u0001\u001a\u00030\u00af\u0001J\t\u0010\u00b0\u0001\u001a\u00020\u0003H\u0016J\u0010\u0010\u00b1\u0001\u001a\u00020\u00152\u0007\u0010\u00b2\u0001\u001a\u000200J\u0010\u0010\u00b3\u0001\u001a\u00020\u00152\u0007\u0010\u00b4\u0001\u001a\u00020\u000eR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u001a\u0010\u0013\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010!R\u0019\u0010/\u001a\n 1*\u0004\u0018\u000100008F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b8\u0010!R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0019\u0010=\u001a\n 1*\u0004\u0018\u000100008F\u00a2\u0006\u0006\u001a\u0004\b>\u00103R\"\u0010?\u001a\n 1*\u0004\u0018\u00010000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00103\"\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bE\u0010DR\u0011\u0010F\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bF\u0010DR\u0011\u0010G\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bG\u0010DR\u0011\u0010H\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bH\u0010DR\u0011\u0010I\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bI\u0010DR\u0011\u0010J\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010DR\u0011\u0010K\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bK\u0010DR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010D\"\u0004\bL\u0010MR\u0011\u0010N\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bN\u0010DR\"\u0010O\u001a\n 1*\u0004\u0018\u00010\u000e0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010$\"\u0004\bQ\u0010&R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010!\"\u0004\bS\u00106R\u0011\u0010T\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bU\u0010!R,\u0010V\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020\u00150WX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u0011\u0010]\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u0011\u0010a\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010`R\u0011\u0010c\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010`R\u0011\u0010e\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010`R\u0011\u0010g\u001a\u00020^\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010`R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010!\"\u0004\bj\u00106R\u0011\u0010k\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bl\u0010!R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\bm\u0010!R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010:\"\u0004\bo\u0010<R\u0011\u0010p\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bq\u0010!R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u0010!\"\u0004\bw\u00106R\u0011\u0010x\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\by\u0010!R\u001a\u0010z\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010D\"\u0004\b|\u0010MR\u001c\u0010}\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b~\u0010!\"\u0004\b\u007f\u00106R\u0013\u0010\u0080\u0001\u001a\u00020\u00038F\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010!R:\u0010\u0082\u0001\u001a(\u0012\f\u0012\n 1*\u0004\u0018\u00010\u00030\u0003 1*\u0013\u0012\f\u0012\n 1*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u0083\u00010\u0083\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001b\u0010\u0086\u0001\u001a\n 1*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010$R%\u0010\u0088\u0001\u001a\u0013\u0012\u000e\u0012\f 1*\u0005\u0018\u00010\u008a\u00010\u008a\u00010\u0089\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u0015\u0010\u008d\u0001\u001a\u00030\u008e\u00018F\u00a2\u0006\b\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0091\u0001\u0010\u0092\u0001\"\u0006\b\u0093\u0001\u0010\u0094\u0001R\u001b\u0010\u0095\u0001\u001a\n 1*\u0004\u0018\u00010\u000e0\u000e8F\u00a2\u0006\u0007\u001a\u0005\b\u0096\u0001\u0010$R\u0015\u0010\u0097\u0001\u001a\u0004\u0018\u0001008F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u00103R\u0013\u0010\b\u001a\u00020\t8F\u00a2\u0006\b\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009b\u0001\u0010!\"\u0005\b\u009c\u0001\u00106R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0007\u001a\u0005\b\u009d\u0001\u0010!\u00a8\u0006\u00b8\u0001"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry;", "", "host", "", "port", "", "username", "password", "type", "Ljava/net/Proxy$Type;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/net/Proxy$Type;)V", "outIp", "id", "declaredTTL", "Ljava/time/Instant;", "lastTarget", "testUrls", "", "Ljava/net/URL;", "defaultTestUrl", "isTestIp", "", "proxyType", "Lai/platon/pulsar/common/proxy/ProxyType;", "user", "pwd", "(Ljava/lang/String;ILjava/lang/String;ILjava/time/Instant;Ljava/lang/String;Ljava/util/List;Ljava/net/URL;ZLai/platon/pulsar/common/proxy/ProxyType;Ljava/lang/String;Ljava/lang/String;)V", "accumResponseMillis", "Ljava/util/concurrent/atomic/AtomicLong;", "getAccumResponseMillis", "()Ljava/util/concurrent/atomic/AtomicLong;", "agentIp", "getAgentIp", "()Ljava/lang/String;", "availableTime", "getAvailableTime", "()Ljava/time/Instant;", "setAvailableTime", "(Ljava/time/Instant;)V", "getDeclaredTTL", "setDeclaredTTL", "getDefaultTestUrl", "()Ljava/net/URL;", "setDefaultTestUrl", "(Ljava/net/URL;)V", "display", "getDisplay", "elapsedTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getElapsedTime", "()Ljava/time/Duration;", "getHost", "setHost", "(Ljava/lang/String;)V", "hostPort", "getHostPort", "getId", "()I", "setId", "(I)V", "idleTime", "getIdleTime", "idleTimeout", "getIdleTimeout", "setIdleTimeout", "(Ljava/time/Duration;)V", "isBanned", "()Z", "isExpired", "isFailed", "isFree", "isGone", "isIdle", "isReady", "isRetired", "setTestIp", "(Z)V", "isWorking", "lastActiveTime", "getLastActiveTime", "setLastActiveTime", "getLastTarget", "setLastTarget", "metadata", "getMetadata", "networkTester", "Lkotlin/Function2;", "Ljava/net/Proxy;", "getNetworkTester", "()Lkotlin/jvm/functions/Function2;", "setNetworkTester", "(Lkotlin/jvm/functions/Function2;)V", "numConnectionLosses", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumConnectionLosses", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numFailedPages", "getNumFailedPages", "numRunningTasks", "getNumRunningTasks", "numSuccessPages", "getNumSuccessPages", "numTests", "getNumTests", "getOutIp", "setOutIp", "outSegment", "getOutSegment", "getPassword", "getPort", "setPort", "protocol", "getProtocol", "getProxyType", "()Lai/platon/pulsar/common/proxy/ProxyType;", "setProxyType", "(Lai/platon/pulsar/common/proxy/ProxyType;)V", "getPwd", "setPwd", "readableState", "getReadableState", "rotatable", "getRotatable", "setRotatable", "rotateURL", "getRotateURL", "setRotateURL", "segment", "getSegment", "servedDomains", "Lcom/google/common/collect/ConcurrentHashMultiset;", "getServedDomains", "()Lcom/google/common/collect/ConcurrentHashMultiset;", "startTime", "getStartTime", "status", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyEntry$Status;", "getStatus", "()Ljava/util/concurrent/atomic/AtomicReference;", "testSpeed", "", "getTestSpeed", "()D", "getTestUrls", "()Ljava/util/List;", "setTestUrls", "(Ljava/util/List;)V", "ttl", "getTtl", "ttlDuration", "getTtlDuration", "getType", "()Ljava/net/Proxy$Type;", "getUser", "setUser", "getUsername", "compareTo", "other", "equals", "", "formatDisplay", "formatMetadata", "hashCode", "refresh", "", "retire", "serialize", "setFree", "startWork", "test", "target", "timeout", "toProxyEntry2", "Lai/platon/pulsar/common/proxy/ProxyEntry2;", "toString", "willExpireAfter", "duration", "willExpireAt", "instant", "BanState", "Companion", "Status", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nProxyEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyEntry.kt\nai/platon/pulsar/common/proxy/ProxyEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1#2:419\n1#2:428\n766#3:420\n857#3,2:421\n766#3:423\n857#3,2:424\n1611#3:426\n1855#3:427\n1856#3:429\n1612#3:430\n*S KotlinDebug\n*F\n+ 1 ProxyEntry.kt\nai/platon/pulsar/common/proxy/ProxyEntry\n*L\n369#1:428\n162#1:420\n162#1:421,2\n341#1:423\n341#1:424,2\n369#1:426\n369#1:427\n369#1:429\n369#1:430\n*E\n"})
public final class ProxyEntry
implements Comparable<ProxyEntry> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private String host;
    private int port;
    @NotNull
    private String outIp;
    private int id;
    @Nullable
    private Instant declaredTTL;
    @Nullable
    private String lastTarget;
    @NotNull
    private List<URL> testUrls;
    @NotNull
    private URL defaultTestUrl;
    private boolean isTestIp;
    @NotNull
    private ProxyType proxyType;
    @Nullable
    private String user;
    @Nullable
    private String pwd;
    private boolean rotatable;
    @Nullable
    private String rotateURL;
    private final Instant startTime;
    @NotNull
    private Function2<? super URL, ? super Proxy, Boolean> networkTester;
    @NotNull
    private final AtomicInteger numTests;
    @NotNull
    private final AtomicInteger numConnectionLosses;
    @NotNull
    private final AtomicLong accumResponseMillis;
    @NotNull
    private Instant availableTime;
    @NotNull
    private final AtomicInteger numFailedPages;
    @NotNull
    private final AtomicInteger numSuccessPages;
    private final ConcurrentHashMultiset<String> servedDomains;
    @NotNull
    private final AtomicReference<Status> status;
    @NotNull
    private final AtomicInteger numRunningTasks;
    private Instant lastActiveTime;
    private Duration idleTimeout;
    private static final Logger log;
    @NotNull
    private static final AtomicInteger instanceSequence;
    @NotNull
    private static final String META_DELIMITER = " ";
    private static final Duration PROXY_EXPIRED;
    private static final Duration MISSING_PROXY_DEAD_TIME;
    private static final int DEFAULT_PROXY_SERVER_PORT = 80;
    @NotNull
    public static final String PROXY_TEST_WEB_SITES_FILE = "proxy.test.web.sites.txt";
    @NotNull
    private static final URL DEFAULT_TEST_URL;
    @NotNull
    private static final List<URL> TEST_URLS;

    public ProxyEntry(@NotNull String host, int port, @NotNull String outIp, int id, @Nullable Instant declaredTTL, @Nullable String lastTarget, @NotNull List<URL> testUrls, @NotNull URL defaultTestUrl, boolean isTestIp, @NotNull ProxyType proxyType, @Nullable String user, @Nullable String pwd) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)outIp, (String)"outIp");
        Intrinsics.checkNotNullParameter(testUrls, (String)"testUrls");
        Intrinsics.checkNotNullParameter((Object)defaultTestUrl, (String)"defaultTestUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)proxyType), (String)"proxyType");
        this.host = host;
        this.port = port;
        this.outIp = outIp;
        this.id = id;
        this.declaredTTL = declaredTTL;
        this.lastTarget = lastTarget;
        this.testUrls = testUrls;
        this.defaultTestUrl = defaultTestUrl;
        this.isTestIp = isTestIp;
        this.proxyType = proxyType;
        this.user = user;
        this.pwd = pwd;
        this.startTime = Instant.now();
        this.networkTester = networkTester.1.INSTANCE;
        this.numTests = new AtomicInteger();
        this.numConnectionLosses = new AtomicInteger();
        this.accumResponseMillis = new AtomicLong();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.availableTime = instant;
        this.numFailedPages = new AtomicInteger();
        this.numSuccessPages = new AtomicInteger();
        this.servedDomains = ConcurrentHashMultiset.create();
        this.status = new AtomicReference<Status>(Status.FREE);
        this.numRunningTasks = new AtomicInteger();
        this.lastActiveTime = Instant.now();
        this.idleTimeout = Duration.ofMinutes(10L);
    }

    public /* synthetic */ ProxyEntry(String string, int n, String string2, int n2, Instant instant, String string3, List list2, URL uRL, boolean bl, ProxyType proxyType, String string4, String string5, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            string2 = "";
        }
        if ((n3 & 8) != 0) {
            n2 = instanceSequence.incrementAndGet();
        }
        if ((n3 & 0x10) != 0) {
            instant = null;
        }
        if ((n3 & 0x20) != 0) {
            string3 = null;
        }
        if ((n3 & 0x40) != 0) {
            list2 = CollectionsKt.toList((Iterable)TEST_URLS);
        }
        if ((n3 & 0x80) != 0) {
            uRL = DEFAULT_TEST_URL;
        }
        if ((n3 & 0x100) != 0) {
            bl = false;
        }
        if ((n3 & 0x200) != 0) {
            proxyType = ProxyType.HTTP;
        }
        if ((n3 & 0x400) != 0) {
            string4 = null;
        }
        if ((n3 & 0x800) != 0) {
            string5 = null;
        }
        this(string, n, string2, n2, instant, string3, list2, uRL, bl, proxyType, string4, string5);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getOutIp() {
        return this.outIp;
    }

    public final void setOutIp(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outIp = string;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    @Nullable
    public final Instant getDeclaredTTL() {
        return this.declaredTTL;
    }

    public final void setDeclaredTTL(@Nullable Instant instant) {
        this.declaredTTL = instant;
    }

    @Nullable
    public final String getLastTarget() {
        return this.lastTarget;
    }

    public final void setLastTarget(@Nullable String string) {
        this.lastTarget = string;
    }

    @NotNull
    public final List<URL> getTestUrls() {
        return this.testUrls;
    }

    public final void setTestUrls(@NotNull List<URL> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.testUrls = list2;
    }

    @NotNull
    public final URL getDefaultTestUrl() {
        return this.defaultTestUrl;
    }

    public final void setDefaultTestUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.defaultTestUrl = uRL;
    }

    public final boolean isTestIp() {
        return this.isTestIp;
    }

    public final void setTestIp(boolean bl) {
        this.isTestIp = bl;
    }

    @NotNull
    public final ProxyType getProxyType() {
        return this.proxyType;
    }

    public final void setProxyType(@NotNull ProxyType proxyType) {
        Intrinsics.checkNotNullParameter((Object)((Object)proxyType), (String)"<set-?>");
        this.proxyType = proxyType;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    @Nullable
    public final String getPwd() {
        return this.pwd;
    }

    public final void setPwd(@Nullable String string) {
        this.pwd = string;
    }

    @NotNull
    public final String getHostPort() {
        return this.host + ":" + this.port;
    }

    @NotNull
    public final String getProtocol() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.proxyType.ordinal()]) {
            case 1: {
                string = "http";
                break;
            }
            case 2: {
                string = "socks";
                break;
            }
            case 3: {
                string = "socks";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Nullable
    public final String getUsername() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.pwd;
    }

    @NotNull
    public final Proxy.Type getType() {
        Proxy.Type type;
        switch (WhenMappings.$EnumSwitchMapping$0[this.proxyType.ordinal()]) {
            case 1: {
                type = Proxy.Type.HTTP;
                break;
            }
            case 2: {
                type = Proxy.Type.SOCKS;
                break;
            }
            case 3: {
                type = Proxy.Type.SOCKS;
                break;
            }
            default: {
                type = Proxy.Type.DIRECT;
            }
        }
        return type;
    }

    @NotNull
    public final String getAgentIp() {
        String string;
        String it = string = this.outIp;
        boolean bl = false;
        String string2 = Strings.isIpLike(it) ? string : null;
        if (string2 == null) {
            string2 = this.host;
        }
        return string2;
    }

    public final boolean getRotatable() {
        return this.rotatable;
    }

    public final void setRotatable(boolean bl) {
        this.rotatable = bl;
    }

    @Nullable
    public final String getRotateURL() {
        return this.rotateURL;
    }

    public final void setRotateURL(@Nullable String string) {
        this.rotateURL = string;
    }

    @NotNull
    public final String getSegment() {
        return StringsKt.substringBeforeLast$default((String)this.host, (String)".", null, (int)2, null);
    }

    @NotNull
    public final String getOutSegment() {
        return StringsKt.substringBeforeLast$default((String)this.outIp, (String)".", null, (int)2, null);
    }

    public final Instant getStartTime() {
        return this.startTime;
    }

    public final Duration getElapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    @NotNull
    public final String getDisplay() {
        return this.formatDisplay();
    }

    @NotNull
    public final String getMetadata() {
        return this.formatMetadata();
    }

    @NotNull
    public final Function2<URL, Proxy, Boolean> getNetworkTester() {
        return this.networkTester;
    }

    public final void setNetworkTester(@NotNull Function2<? super URL, ? super Proxy, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.networkTester = function2;
    }

    @NotNull
    public final AtomicInteger getNumTests() {
        return this.numTests;
    }

    @NotNull
    public final AtomicInteger getNumConnectionLosses() {
        return this.numConnectionLosses;
    }

    @NotNull
    public final AtomicLong getAccumResponseMillis() {
        return this.accumResponseMillis;
    }

    @NotNull
    public final Instant getAvailableTime() {
        return this.availableTime;
    }

    public final void setAvailableTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.availableTime = instant;
    }

    @NotNull
    public final AtomicInteger getNumFailedPages() {
        return this.numFailedPages;
    }

    @NotNull
    public final AtomicInteger getNumSuccessPages() {
        return this.numSuccessPages;
    }

    public final ConcurrentHashMultiset<String> getServedDomains() {
        return this.servedDomains;
    }

    @NotNull
    public final AtomicReference<Status> getStatus() {
        return this.status;
    }

    public final double getTestSpeed() {
        return (double)(this.accumResponseMillis.get() / (long)RangesKt.coerceAtLeast((int)this.numTests.get(), (int)1)) / 1000.0;
    }

    public final Instant getTtl() {
        Instant instant = this.declaredTTL;
        if (instant == null) {
            instant = this.availableTime.plus(PROXY_EXPIRED);
        }
        return instant;
    }

    @Nullable
    public final Duration getTtlDuration() {
        Duration duration;
        Duration it = duration = Duration.between(Instant.now(), this.getTtl());
        boolean bl = false;
        return !it.isNegative() ? duration : null;
    }

    public final boolean isExpired() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return this.willExpireAt(instant);
    }

    public final boolean isRetired() {
        return this.status.get() == Status.RETIRED;
    }

    public final boolean isFree() {
        return this.status.get() == Status.FREE;
    }

    public final boolean isWorking() {
        return this.status.get() == Status.WORKING;
    }

    public final boolean isBanned() {
        return this.isRetired() && !this.isExpired();
    }

    public final boolean isFailed() {
        return this.numConnectionLosses.get() >= 3;
    }

    public final boolean isGone() {
        return this.isRetired() || this.isFailed();
    }

    @NotNull
    public final AtomicInteger getNumRunningTasks() {
        return this.numRunningTasks;
    }

    public final Instant getLastActiveTime() {
        return this.lastActiveTime;
    }

    public final void setLastActiveTime(Instant instant) {
        this.lastActiveTime = instant;
    }

    public final Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(Duration duration) {
        this.idleTimeout = duration;
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isIdle() {
        return this.numRunningTasks.get() == 0 && this.getIdleTime().compareTo(this.idleTimeout) > 0;
    }

    public final boolean isReady() {
        return !this.isGone() && !this.isExpired() && !this.isRetired() && !this.isBanned();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getReadableState() {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"retired", (Object)this.isRetired()), TuplesKt.to((Object)"idle", (Object)this.isIdle()), TuplesKt.to((Object)"ready", (Object)this.isReady())};
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)META_DELIMITER, null, null, (int)0, null, (Function1)readableState.2.INSTANCE, (int)30, null);
    }

    public ProxyEntry(@NotNull String host, int port, @Nullable String username, @Nullable String password, @NotNull Proxy.Type type) {
        ProxyType proxyType;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(host, port, null, 0, null, null, null, null, false, null, username, password, 1020, null);
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                proxyType = ProxyType.HTTP;
                break;
            }
            case 2: {
                proxyType = ProxyType.SOCKS5;
                break;
            }
            case 3: {
                proxyType = ProxyType.DIRECT;
                break;
            }
            default: {
                proxyType = ProxyType.DIRECT;
            }
        }
        this.proxyType = proxyType;
    }

    public /* synthetic */ ProxyEntry(String string, int n, String string2, String string3, Proxy.Type type, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            type = Proxy.Type.HTTP;
        }
        this(string, n, string2, string3, type);
    }

    public final boolean willExpireAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.getTtl().compareTo(instant) < 0;
    }

    public final boolean willExpireAfter(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return this.getTtl().compareTo(Instant.now().plus(duration)) < 0;
    }

    public final void setFree() {
        this.status.set(Status.FREE);
    }

    public final void startWork() {
        this.status.set(Status.WORKING);
    }

    public final void retire() {
        this.status.set(Status.RETIRED);
    }

    public final void refresh() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.lastActiveTime = this.availableTime = instant;
    }

    public final boolean test() {
        URL target = this.lastTarget != null ? new URL(this.lastTarget) : (URL)CollectionsKt.random((Collection)this.testUrls, (Random)((Random)Random.Default));
        boolean available = ProxyEntry.test$default(this, target, null, 2, null);
        if (!(available || this.isGone() || Intrinsics.areEqual((Object)target, (Object)this.defaultTestUrl))) {
            available = ProxyEntry.test$default(this, this.defaultTestUrl, null, 2, null);
            if (available) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Target unreachable via {} | {} | {}", objectArray);
            } else if (!this.isGone()) {
                Object[] objectArray = new Object[]{this.getDisplay(), this.getMetadata(), target.getHost()};
                log.warn("Proxy connection lost {} | {} | {}", objectArray);
            }
        }
        return available;
    }

    public final boolean test(@NotNull URL target, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        boolean available = NetUtil.testTcpNetwork(this.host, this.port, timeout);
        if (available) {
            InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            long start2 = System.currentTimeMillis();
            available = (Boolean)this.networkTester.invoke((Object)target, (Object)proxy);
            long end = System.currentTimeMillis();
            this.numTests.incrementAndGet();
            this.accumResponseMillis.addAndGet(end - start2);
        }
        if (!available) {
            this.numConnectionLosses.incrementAndGet();
            if (this.isGone()) {
                log.warn("Proxy is gone after {} tests | {}", (Object)this.numTests, (Object)this);
            } else {
                log.info("Proxy is not available | " + this);
            }
        } else {
            this.numConnectionLosses.set(0);
            this.refresh();
        }
        return available;
    }

    public static /* synthetic */ boolean test$default(ProxyEntry proxyEntry, URL uRL, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        return proxyEntry.test(uRL, duration);
    }

    @NotNull
    public final String serialize() {
        String ttlStr = this.declaredTTL != null ? ", ttl:" + this.declaredTTL : "";
        return this.host + ":" + this.port + " at:" + this.availableTime + ttlStr + ", " + this.getMetadata();
    }

    @NotNull
    public final ProxyEntry2 toProxyEntry2() {
        ProxyEntry2 p2 = new ProxyEntry2(this.host, this.port, this.getUsername(), this.getPassword(), this.getType());
        p2.setOutIp(this.outIp);
        p2.setId(this.id);
        p2.setDeclaredTTL(this.declaredTTL);
        p2.setLastTarget(this.lastTarget);
        p2.getTestUrls();
        p2.getDefaultTestUrl();
        p2.isTestIp();
        return p2;
    }

    public int hashCode() {
        return 31 * this.proxyType.hashCode() + this.getHostPort().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ProxyEntry2) {
            return ((ProxyEntry2)other).getType() == this.getType() && Intrinsics.areEqual((Object)((ProxyEntry2)other).getHost(), (Object)this.host) && ((ProxyEntry2)other).getPort() == this.port && Intrinsics.areEqual((Object)((ProxyEntry2)other).getUsername(), (Object)this.getUsername());
        }
        return other instanceof ProxyEntry && ((ProxyEntry)other).getType() == this.getType() && Intrinsics.areEqual((Object)((ProxyEntry)other).host, (Object)this.host) && ((ProxyEntry)other).port == this.port && Intrinsics.areEqual((Object)((ProxyEntry)other).getUsername(), (Object)this.getUsername());
    }

    @NotNull
    public String toString() {
        return ((Object)StringsKt.trim((CharSequence)(this.getDisplay() + META_DELIMITER + this.getMetadata()))).toString();
    }

    @Override
    public int compareTo(@NotNull ProxyEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int c = this.outIp.compareTo(other.outIp);
        if (c == 0) {
            c = this.getHostPort().compareTo(other.getHostPort());
        }
        return c;
    }

    private final String formatDisplay() {
        String ban = this.isBanned() ? "[banned] " : "";
        Object object = this.getTtlDuration();
        if (object == null || (object = ((Duration)object).truncatedTo(ChronoUnit.SECONDS)) == null || (object = DateTimesKt.readable((Duration)object)) == null) {
            object = "0s";
        }
        Object ttlStr = object;
        String ipStr = ((CharSequence)this.outIp).length() == 0 ? this.getHostPort() : this.getHostPort() + " => " + this.outIp;
        return ban + "[" + ipStr + "](" + this.numFailedPages + "/" + this.numSuccessPages + "/" + (String)ttlStr + ")[" + this.getReadableState() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private final String formatMetadata() {
        void $this$filterTo$iv$iv;
        int nPages = this.numSuccessPages.get() + this.numFailedPages.get();
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"st", (Object)this.status.get().ordinal()), TuplesKt.to((Object)"pg", (Object)nPages), TuplesKt.to((Object)"fpg", (Object)this.numFailedPages.get()), TuplesKt.to((Object)"tt", (Object)this.numTests.get()), TuplesKt.to((Object)"ftt", (Object)this.numConnectionLosses.get())};
        Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object s2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        if (this.getTestSpeed() > 0.0) {
            s2 = (String)s2 + ", spd:" + this.getTestSpeed();
        }
        return s2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapNotNullTo$iv;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ProxyEntry.class);
        instanceSequence = new AtomicInteger();
        PROXY_EXPIRED = Duration.ofSeconds(120L);
        MISSING_PROXY_DEAD_TIME = Duration.ofHours(1L);
        DEFAULT_TEST_URL = new URL("https://www.baidu.com");
        TEST_URLS = new ArrayList();
        Iterable iterable = ResourceLoader.INSTANCE.readAllLines(PROXY_TEST_WEB_SITES_FILE);
        Collection destination$iv = TEST_URLS;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (UrlUtils.getURLOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$BanState;", "", "(Ljava/lang/String;I)V", "isBanned", "", "()Z", "isOK", "OK", "SEGMENT", "HOST", "OTHER", "pulsar-common"})
    public static final class BanState
    extends Enum<BanState> {
        public static final /* enum */ BanState OK = new BanState();
        public static final /* enum */ BanState SEGMENT = new BanState();
        public static final /* enum */ BanState HOST = new BanState();
        public static final /* enum */ BanState OTHER = new BanState();
        private static final /* synthetic */ BanState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isOK() {
            return this == OK;
        }

        public final boolean isBanned() {
            return !this.isOK();
        }

        public static BanState[] values() {
            return (BanState[])$VALUES.clone();
        }

        public static BanState valueOf(String value) {
            return Enum.valueOf(BanState.class, value);
        }

        @NotNull
        public static EnumEntries<BanState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = banStateArray = new BanState[]{BanState.OK, BanState.SEGMENT, BanState.HOST, BanState.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$Companion;", "", "()V", "DEFAULT_PROXY_SERVER_PORT", "", "DEFAULT_TEST_URL", "Ljava/net/URL;", "getDEFAULT_TEST_URL", "()Ljava/net/URL;", "META_DELIMITER", "", "MISSING_PROXY_DEAD_TIME", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "PROXY_EXPIRED", "PROXY_TEST_WEB_SITES_FILE", "TEST_URLS", "", "getTEST_URLS", "()Ljava/util/List;", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "log", "Lorg/slf4j/Logger;", "create", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "proxy", "Lai/platon/pulsar/common/proxy/ProxyEntry2;", "parse", "str", "pulsar-common"})
    @SourceDebugExtension(value={"SMAP\nProxyEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyEntry.kt\nai/platon/pulsar/common/proxy/ProxyEntry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,418:1\n1855#2,2:419\n1#3:421\n*S KotlinDebug\n*F\n+ 1 ProxyEntry.kt\nai/platon/pulsar/common/proxy/ProxyEntry$Companion\n*L\n398#1:419,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL getDEFAULT_TEST_URL() {
            return DEFAULT_TEST_URL;
        }

        @NotNull
        public final List<URL> getTEST_URLS() {
            return TEST_URLS;
        }

        @NotNull
        public final ProxyEntry create(@NotNull ProxyEntry2 proxy) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            ProxyEntry2 p2 = proxy;
            return new ProxyEntry(p2.getHost(), p2.getPort(), p2.getOutIp(), p2.getId(), p2.getDeclaredTTL(), p2.getLastTarget(), p2.getTestUrls(), p2.getDefaultTestUrl(), p2.isTestIp(), null, p2.getUsername(), p2.getPassword(), 512, null);
        }

        @Nullable
        public final ProxyEntry parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String ipPort = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)str)).toString(), (String)ProxyEntry.META_DELIMITER, null, (int)2, null);
            if (!Strings.isIpPortLike(ipPort)) {
                log.warn("Malformed ip port - >{}<", (Object)str);
                return null;
            }
            int pos = StringsKt.lastIndexOf$default((CharSequence)ipPort, (char)':', (int)0, (boolean)false, (int)6, null);
            if (pos != -1) {
                String string = ipPort.substring(0, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String host = string;
                String string2 = ipPort.substring(pos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int port = NumberUtils.toInt((String)string2, (int)80);
                Instant availableTime = null;
                Instant ttl = null;
                String[] stringArray = new String[]{", "};
                List parts = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)str, (String)ProxyEntry.META_DELIMITER, null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$forEach$iv = parts;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String item = (String)element$iv;
                    boolean bl = false;
                    try {
                        if (StringsKt.startsWith$default((String)item, (String)"at:", (boolean)false, (int)2, null)) {
                            String string3 = item.substring(3);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            availableTime = Instant.parse(((Object)StringsKt.trimEnd((CharSequence)string3)).toString());
                            continue;
                        }
                        if (!StringsKt.startsWith$default((String)item, (String)"ttl:", (boolean)false, (int)2, null)) continue;
                        String string4 = item.substring(4);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        ttl = Instant.parse(((Object)StringsKt.trimEnd((CharSequence)string4)).toString());
                    }
                    catch (Throwable e) {
                        log.warn("Ignore malformed proxy metadata <{}>", (Object)item);
                    }
                }
                ProxyEntry proxyEntry = new ProxyEntry(host, port, null, 0, ttl, null, null, null, false, null, null, null, 4076, null);
                Instant instant = availableTime;
                if (instant != null) {
                    Instant it = instant;
                    boolean bl = false;
                    proxyEntry.setAvailableTime(it);
                }
                return proxyEntry;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyEntry$Status;", "", "(Ljava/lang/String;I)V", "FREE", "WORKING", "RETIRED", "EXPIRED", "GONE", "pulsar-common"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FREE = new Status();
        public static final /* enum */ Status WORKING = new Status();
        public static final /* enum */ Status RETIRED = new Status();
        public static final /* enum */ Status EXPIRED = new Status();
        public static final /* enum */ Status GONE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FREE, Status.WORKING, Status.RETIRED, Status.EXPIRED, Status.GONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProxyType.values().length];
            try {
                nArray[ProxyType.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.SOCKS4.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.SOCKS5.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

