/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls.sites.amazon;

import ai.platon.pulsar.common.config.AppConstants;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/common/urls/sites/amazon/AmazonUrls;", "", "()V", "charset", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getCharset", "()Ljava/nio/charset/Charset;", "indexPageUrlContains", "", "", "getIndexPageUrlContains", "()[Ljava/lang/String;", "[Ljava/lang/String;", "findAsin", "url", "isAmazon", "", "isAmazonIndexPage", "isAmazonItemPage", "isAmazonReviewPage", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nAmazonUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmazonUrls.kt\nai/platon/pulsar/common/urls/sites/amazon/AmazonUrls\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,67:1\n12474#2,2:68\n*S KotlinDebug\n*F\n+ 1 AmazonUrls.kt\nai/platon/pulsar/common/urls/sites/amazon/AmazonUrls\n*L\n23#1:68,2\n*E\n"})
public final class AmazonUrls {
    @NotNull
    public static final AmazonUrls INSTANCE = new AmazonUrls();
    private static final Charset charset = Charset.defaultCharset();
    @NotNull
    private static final String[] indexPageUrlContains;

    private AmazonUrls() {
    }

    public final Charset getCharset() {
        return charset;
    }

    @NotNull
    public final String[] getIndexPageUrlContains() {
        return indexPageUrlContains;
    }

    public final boolean isAmazon(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.contains$default((CharSequence)url, (CharSequence)".amazon.", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAmazonIndexPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!this.isAmazon(url)) return false;
        String[] $this$any$iv = indexPageUrlContains;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String element$iv;
            String it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)it, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean isAmazonItemPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/dp/", (boolean)false, (int)2, null);
    }

    public final boolean isAmazonReviewPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/product-reviews/", (boolean)false, (int)2, null);
    }

    @Nullable
    public final String findAsin(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int pos = StringsKt.indexOf$default((CharSequence)url, (String)"/dp/", (int)0, (boolean)false, (int)6, null) + 4;
        if (pos > AppConstants.SHORTEST_VALID_URL_LENGTH) {
            int pos2;
            for (pos2 = pos; pos2 < url.length() && Character.isLetterOrDigit(url.charAt(pos2)); ++pos2) {
            }
            if (pos2 <= url.length()) {
                String string = url.substring(pos, pos2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
        }
        return null;
    }

    static {
        String[] stringArray = new String[]{"/zgbs/", "/most-wished-for/", "/new-releases/", "/movers-and-shakers/"};
        indexPageUrlContains = stringArray;
    }
}

