/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Strings;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bJ \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0016\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0016\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\u0006\u0010\u001c\u001a\u00020\bJ\u0014\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020'J \u0010$\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020'J \u0010$\u001a\u00020\n2\u0006\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020'J\u000e\u0010*\u001a\u00020'2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\bJ\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lai/platon/pulsar/common/AppFiles;", "", "()V", "logger", "Lorg/slf4j/Logger;", "appendLog", "", "message", "", "path", "Ljava/nio/file/Path;", "file", "createSharedFileTask", "url", "createSymbolicLink", "dstFile", "target", "createTempFile", "prefix", "suffix", "getCachedWebPage", "getJarEntries", "", "Ljava/util/zip/ZipEntry;", "T", "clazz", "Ljava/lang/Class;", "listJarDirectory", "baseDirectory", "logUnreachableHosts", "unreachableHosts", "", "readBatchIdOrDefault", "defaultValue", "readLastGeneratedRows", "", "saveTo", "any", "deleteIfExists", "", "content", "", "supportSymbolicLink", "writeLastBatchId", "batchId", "writeLastGeneratedRows", "rows", "", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nAppFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppFiles.kt\nai/platon/pulsar/common/AppFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n1549#3:220\n1620#3,3:221\n1549#3:224\n1620#3,3:225\n*S KotlinDebug\n*F\n+ 1 AppFiles.kt\nai/platon/pulsar/common/AppFiles\n*L\n208#1:220\n208#1:221,3\n209#1:224\n209#1:225,3\n*E\n"})
public final class AppFiles {
    @NotNull
    public static final AppFiles INSTANCE = new AppFiles();
    @NotNull
    private static final Logger logger = LogsKt.getLogger(AppFiles.class);

    private AppFiles() {
    }

    public final boolean supportSymbolicLink(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !SystemUtils.IS_OS_WINDOWS && path.getFileSystem().supportedFileAttributeViews().contains("posix");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSymbolicLink(@NotNull Path dstFile, @NotNull Path target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Files.createDirectories(dstFile.getParent(), new FileAttribute[0]);
        if (this.supportSymbolicLink(dstFile)) {
            Files.createSymbolicLink(dstFile, target, new FileAttribute[0]);
        } else {
            Closeable closeable = Files.newBufferedWriter(dstFile, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable;
                boolean bl = false;
                String string = "Please see %s%n";
                Object[] objectArray = new Object[]{((Object)target).toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                writer2.write(string2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public final Path createTempFile(@NotNull String prefix, @NotNull String suffix) throws IOException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String rand = RandomStringUtils.randomAlphanumeric((int)12);
        String[] stringArray = new String[]{prefix + rand + suffix};
        Path path = AppPaths.INSTANCE.getProcTmp("tmp", stringArray);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.writeString(path, (CharSequence)"", new OpenOption[0]);
        return path;
    }

    public static /* synthetic */ Path createTempFile$default(AppFiles appFiles, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return appFiles.createTempFile(string, string2);
    }

    @NotNull
    public final Path saveTo(@NotNull Object any, @NotNull Path path, boolean deleteIfExists) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = any.toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.saveTo(byArray, path, deleteIfExists);
    }

    public static /* synthetic */ Path saveTo$default(AppFiles appFiles, Object object, Path path, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return appFiles.saveTo(object, path, bl);
    }

    @NotNull
    public final Path saveTo(@NotNull String content2, @NotNull Path path, boolean deleteIfExists) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = content2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.saveTo(byArray, path, deleteIfExists);
    }

    public static /* synthetic */ Path saveTo$default(AppFiles appFiles, String string, Path path, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return appFiles.saveTo(string, path, bl);
    }

    @NotNull
    public final Path saveTo(@NotNull byte[] content2, @NotNull Path path, boolean deleteIfExists) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (deleteIfExists) {
            Files.deleteIfExists(path);
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        Files.write(path, content2, openOptionArray);
        return path;
    }

    public static /* synthetic */ Path saveTo$default(AppFiles appFiles, byte[] byArray, Path path, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return appFiles.saveTo(byArray, path, bl);
    }

    public final void appendLog(@NotNull String message, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            FileUtils.writeStringToFile((File)path.toFile(), (String)(DateTimes.now() + " " + message), (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void appendLog(@NotNull String message, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            FileUtils.writeStringToFile((File)new File(file), (String)(DateTimes.now() + " " + message), (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final <T> List<String> listJarDirectory(@NotNull Class<T> clazz) throws IOException {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List entries = new ArrayList();
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        ZipInputStream zip = new ZipInputStream(src.getLocation().openStream());
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            entries.add(string);
            entry = zip.getNextEntry();
        }
        return entries;
    }

    @NotNull
    public final <T> List<String> listJarDirectory(@NotNull Class<T> clazz, @NotNull String baseDirectory) throws IOException {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
        return this.listJarDirectory(clazz);
    }

    @NotNull
    public final <T> List<ZipEntry> getJarEntries(@NotNull Class<T> clazz) throws IOException {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List entries = new ArrayList();
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        ZipInputStream zip = new ZipInputStream(src.getLocation().openStream());
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            entries.add(entry);
            entry = zip.getNextEntry();
        }
        return entries;
    }

    @NotNull
    public final Path writeLastGeneratedRows(long rows) throws IOException {
        Path path = AppPaths.INSTANCE.getPATH_LAST_GENERATED_ROWS();
        String string = rows + "\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        Files.write(path, byArray, (OpenOption[])string);
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    public final int readLastGeneratedRows() {
        try {
            if (!Files.exists(AppPaths.INSTANCE.getPATH_LAST_GENERATED_ROWS(), new LinkOption[0])) {
                return -1;
            }
            String line = Files.readAllLines(AppPaths.INSTANCE.getPATH_LAST_GENERATED_ROWS()).get(0);
            return NumberUtils.toInt((String)line, (int)-1);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    @NotNull
    public final Path writeLastBatchId(@NotNull String batchId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
        Path path = AppPaths.INSTANCE.getPATH_LAST_BATCH_ID();
        if (((CharSequence)batchId).length() > 0) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)batchId, openOptionArray);
        }
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    @NotNull
    public final String readBatchIdOrDefault(@NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            if (!Files.exists(AppPaths.INSTANCE.getPATH_LAST_BATCH_ID(), new LinkOption[0])) {
                return defaultValue;
            }
            String string = Files.readAllLines(AppPaths.INSTANCE.getPATH_LAST_BATCH_ID()).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public final void createSharedFileTask(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Path path = AppPaths.INSTANCE.getWEB_CACHE_DIR().resolve(AppPaths.INSTANCE.fromUri((String)url, "", ".task"));
            OpenOption[] openOptionArray = url;
            byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(path, byArray, openOptionArray);
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
    }

    @Nullable
    public final String getCachedWebPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Path path = AppPaths.INSTANCE.getWEB_CACHE_DIR().resolve(AppPaths.INSTANCE.fromUri(url, "", ".htm"));
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try {
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] byArray2 = byArray;
            return new String(byArray2, Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    public final void logUnreachableHosts(@NotNull Collection<String> unreachableHosts) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(unreachableHosts, (String)"unreachableHosts");
        OpenOption[] $this$map$iv = unreachableHosts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Strings.reverse(it));
        }
        $this$map$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Strings.reverse(it));
        }
        String report2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)logUnreachableHosts.report.3.INSTANCE, (int)31, null);
        try {
            Path path = AppPaths.INSTANCE.getPATH_UNREACHABLE_HOSTS();
            $this$map$iv = report2;
            byte[] byArray = $this$map$iv.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$map$iv = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(path, byArray, $this$map$iv);
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
    }
}

