/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.FileCommand;
import ai.platon.pulsar.common.LogsKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u00042\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000eJ*\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u00042\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/platon/pulsar/common/FileCommand;", "", "()V", "CHECK_INTERVAL", "Ljava/time/Duration;", "getCHECK_INTERVAL", "()Ljava/time/Duration;", "COMMAND_FILE", "Ljava/nio/file/Path;", "getCOMMAND_FILE", "()Ljava/nio/file/Path;", "LAST_CHECK_TIME", "", "", "", "getLAST_CHECK_TIME", "()Ljava/util/Map;", "log", "Lorg/slf4j/Logger;", "check", "", "command", "checkInterval", "action", "Lkotlin/Function0;", "", "doCheckFile", "submit", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCommand.kt\nai/platon/pulsar/common/FileCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1747#2,3:94\n*S KotlinDebug\n*F\n+ 1 FileCommand.kt\nai/platon/pulsar/common/FileCommand\n*L\n80#1:94,3\n*E\n"})
public final class FileCommand {
    @NotNull
    public static final FileCommand INSTANCE = new FileCommand();
    @NotNull
    private static final Logger log = LogsKt.getLogger(FileCommand.class);
    @NotNull
    private static final Path COMMAND_FILE;
    @NotNull
    private static final Duration CHECK_INTERVAL;
    @NotNull
    private static final Map<String, Long> LAST_CHECK_TIME;

    private FileCommand() {
    }

    @NotNull
    public final Path getCOMMAND_FILE() {
        return COMMAND_FILE;
    }

    @NotNull
    public final Duration getCHECK_INTERVAL() {
        return CHECK_INTERVAL;
    }

    @NotNull
    public final Map<String, Long> getLAST_CHECK_TIME() {
        return LAST_CHECK_TIME;
    }

    @Nullable
    public final synchronized Path submit(@NotNull String command) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Object object2 = this;
        try {
            FileCommand $this$submit_u24lambda_u240 = object2;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            object = Result.constructor-impl((Object)Files.writeString(COMMAND_FILE, (CharSequence)command, openOptionArray));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public final synchronized boolean check(@NotNull String command, long checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Duration duration = Duration.ofSeconds(checkInterval);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return FileCommand.check$default(this, command, duration, null, 4, null);
    }

    @JvmOverloads
    public final synchronized boolean check(@NotNull String command, @NotNull Duration checkInterval, @NotNull Function0<Unit> action) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            bl = this.doCheckFile(command, checkInterval, action);
        }
        catch (IOException e) {
            log.error(e.toString());
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean check$default(FileCommand fileCommand, String string, Duration duration, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            duration = CHECK_INTERVAL;
        }
        if ((n & 4) != 0) {
            function0 = check.1.INSTANCE;
        }
        return fileCommand.check(string, duration, (Function0<Unit>)function0);
    }

    private final boolean doCheckFile(String command, Duration checkInterval, Function0<Unit> action) {
        long lastCheckTime = ((Number)LAST_CHECK_TIME.getOrDefault(command, 0L)).longValue();
        if (DateTimes.INSTANCE.elapsedTime(lastCheckTime).compareTo(checkInterval) < 0) {
            return false;
        }
        if (!Files.exists(COMMAND_FILE, new LinkOption[0])) {
            return false;
        }
        long now = System.currentTimeMillis();
        long modifiedTime = COMMAND_FILE.toFile().lastModified();
        boolean exist = false;
        if (lastCheckTime <= modifiedTime) {
            List<String> lines;
            block8: {
                boolean bl;
                Long l = now;
                LAST_CHECK_TIME.put(command, l);
                lines = Files.readAllLines(COMMAND_FILE);
                Intrinsics.checkNotNull(lines);
                Iterable $this$any$iv = lines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)command, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = exist = false;
                }
            }
            if (exist) {
                if (!StringsKt.contains((CharSequence)command, (CharSequence)"-perm", (boolean)true)) {
                    lines.remove(command);
                    Files.write(COMMAND_FILE, (Iterable<? extends CharSequence>)lines, new OpenOption[0]);
                }
                action.invoke();
            }
        }
        return exist;
    }

    static /* synthetic */ boolean doCheckFile$default(FileCommand fileCommand, String string, Duration duration, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            duration = CHECK_INTERVAL;
        }
        if ((n & 4) != 0) {
            function0 = doCheckFile.1.INSTANCE;
        }
        return fileCommand.doCheckFile(string, duration, (Function0<Unit>)function0);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command, @NotNull Duration checkInterval) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)checkInterval, (String)"checkInterval");
        return FileCommand.check$default(this, command, checkInterval, null, 4, null);
    }

    @JvmOverloads
    public final boolean check(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return FileCommand.check$default(this, command, null, null, 6, null);
    }

    static {
        Path path = AppPaths.INSTANCE.getPATH_LOCAL_COMMAND();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-PATH_LOCAL_COMMAND>(...)");
        COMMAND_FILE = path;
        Duration duration = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        CHECK_INTERVAL = duration;
        LAST_CHECK_TIME = new HashMap();
    }
}

