/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.concurrent.ConcurrentPassiveExpiringSet;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.LoadingProxyPool;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyLoader;
import ai.platon.pulsar.common.proxy.ProxyPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lai/platon/pulsar/common/proxy/LoadingProxyPool;", "Lai/platon/pulsar/common/proxy/ProxyPool;", "proxyLoader", "Lai/platon/pulsar/common/proxy/ProxyLoader;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/proxy/ProxyLoader;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bannedIps", "Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "", "getBannedIps", "()Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "bannedSegments", "getBannedSegments", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProxyLoader", "()Lai/platon/pulsar/common/proxy/ProxyLoader;", "ban", "", "proxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "dump", "handleBanState", "Lai/platon/pulsar/common/proxy/ProxyEntry$BanState;", "load", "poll0", "report", "retire", "take", "toString", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nLoadingProxyPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadingProxyPool.kt\nai/platon/pulsar/common/proxy/LoadingProxyPool\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1313#2,2:157\n1#3:159\n*S KotlinDebug\n*F\n+ 1 LoadingProxyPool.kt\nai/platon/pulsar/common/proxy/LoadingProxyPool\n*L\n107#1:157,2\n*E\n"})
public final class LoadingProxyPool
extends ProxyPool {
    @NotNull
    private final ProxyLoader proxyLoader;
    private final Logger logger;

    public LoadingProxyPool(@NotNull ProxyLoader proxyLoader, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)proxyLoader, (String)"proxyLoader");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.proxyLoader = proxyLoader;
        this.logger = LoggerFactory.getLogger(LoadingProxyPool.class);
    }

    @NotNull
    public final ProxyLoader getProxyLoader() {
        return this.proxyLoader;
    }

    private final ConcurrentPassiveExpiringSet<String> getBannedIps() {
        return this.proxyLoader.getBannedIps();
    }

    private final ConcurrentPassiveExpiringSet<String> getBannedSegments() {
        return this.proxyLoader.getBannedSegments();
    }

    @Override
    @Nullable
    public ProxyEntry take() throws ProxyException, InterruptedException {
        this.setLastActiveTime(Instant.now());
        int i = 0;
        int maxRetry = 10;
        ProxyEntry proxy = null;
        while (this.isActive() && proxy == null && i++ < maxRetry && !Thread.currentThread().isInterrupted()) {
            if (this.getFreeProxies().isEmpty()) {
                this.load();
            }
            proxy = this.poll0();
        }
        return proxy;
    }

    @Override
    public void retire(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        proxyEntry.retire();
        if (proxyEntry.isBanned()) {
            this.ban(proxyEntry);
        }
    }

    @Override
    public void report(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        Object[] objectArray = new Object[6];
        objectArray[0] = proxyEntry.getOutIp();
        objectArray[1] = proxyEntry.getNumSuccessPages();
        Duration duration = proxyEntry.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-elapsedTime>(...)");
        objectArray[2] = DateTimesKt.readable(duration);
        objectArray[3] = this.getNumProxyBanned();
        objectArray[4] = this.getBannedIps().size();
        objectArray[5] = proxyEntry;
        this.logger.info("Ban proxy <{}> after {} pages served in {} | total ban: {}, banned ips: {} | {}", objectArray);
        String s2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.chunked((Iterable)this.getBannedSegments(), (int)20), (CharSequence)"\n", null, null, (int)0, null, (Function1)report.s.1.INSTANCE, (int)30, null);
        this.logger.info("Banned segments ({}): {}", (Object)this.getBannedSegments().size(), (Object)s2);
    }

    private final void ban(ProxyEntry proxyEntry) {
        if (Intrinsics.areEqual((Object)proxyEntry.getHost(), (Object)"127.0.0.1")) {
            return;
        }
        boolean banned = false;
        if (!this.getBannedIps().contains(proxyEntry.getOutIp())) {
            this.getBannedIps().add(proxyEntry.getOutIp());
            banned = true;
        }
        if (!this.getBannedSegments().contains(proxyEntry.getOutSegment())) {
            this.getBannedSegments().add(proxyEntry.getOutSegment());
            banned = true;
        }
        if (banned) {
            this.setNumProxyBanned(this.getNumProxyBanned() + 1);
            this.getNumProxyBanned();
            this.report(proxyEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() throws ProxyException {
        List<ProxyEntry> list2;
        ProxyLoader proxyLoader = this.proxyLoader;
        synchronized (proxyLoader) {
            boolean bl = false;
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
            list2 = this.proxyLoader.updateProxies(duration);
        }
        List<ProxyEntry> loadedProxies = list2;
        Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)loadedProxies), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getProxyEntries().contains(it);
            }
        })), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LoadingProxyPool.access$getBannedIps(this.this$0).contains(it.getOutIp());
            }
        })), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LoadingProxyPool.access$getBannedSegments(this.this$0).contains(it.getOutSegment());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProxyEntry it = (ProxyEntry)element$iv;
            boolean bl = false;
            this.offer(it);
        }
    }

    private final ProxyEntry poll0() throws InterruptedException {
        ProxyEntry proxyEntry;
        ProxyEntry.BanState banState;
        ProxyEntry.BanState banState2;
        ProxyEntry proxyEntry2 = this.getFreeProxies().poll(this.getPollingTimeout().toMillis(), TimeUnit.MILLISECONDS);
        if (proxyEntry2 == null) {
            return null;
        }
        ProxyEntry proxy = proxyEntry2;
        ProxyEntry.BanState it = banState2 = this.handleBanState(proxy);
        boolean bl = false;
        ProxyEntry.BanState banState3 = it.isBanned() ? banState2 : null;
        if (banState3 != null) {
            it = banState2 = banState3;
            boolean bl2 = false;
            int n = this.getNumProxyBanned();
            this.setNumProxyBanned(n + 1);
            Object[] objectArray = new Object[]{it, this.getNumProxyBanned(), this.getBannedIps().size(), this.getBannedSegments().size(), proxy.getDisplay()};
            this.logger.info("Proxy is banned <{}> | bp: {}, bh: {}, bs: {} | {}", objectArray);
            banState = banState2;
        } else {
            banState = null;
        }
        ProxyEntry.BanState banState4 = banState;
        ProxyEntry it2 = proxyEntry = proxy;
        boolean bl3 = false;
        return banState4 == null ? proxyEntry : null;
    }

    private final ProxyEntry.BanState handleBanState(ProxyEntry proxyEntry) {
        ProxyEntry.BanState banState;
        String string = this.proxyLoader.getBanStrategy();
        if (string == null) {
            string = "";
        }
        String banStrategy = string;
        if (Intrinsics.areEqual((Object)banStrategy, (Object)"")) {
            banState = ProxyEntry.BanState.OK;
        } else if (Intrinsics.areEqual((Object)banStrategy, (Object)"none")) {
            banState = ProxyEntry.BanState.OK;
        } else if (Intrinsics.areEqual((Object)banStrategy, (Object)"clear")) {
            ProxyEntry.BanState banState2;
            ProxyEntry.BanState it = banState2 = ProxyEntry.BanState.OK;
            boolean bl = false;
            this.getBannedSegments().clear();
            this.getBannedIps().clear();
            banState = banState2;
        } else {
            banState = StringsKt.startsWith$default((String)banStrategy, (String)"segment", (boolean)false, (int)2, null) && this.getBannedSegments().contains(proxyEntry.getOutSegment()) ? ProxyEntry.BanState.SEGMENT : (StringsKt.startsWith$default((String)banStrategy, (String)"host", (boolean)false, (int)2, null) && this.getBannedIps().contains(proxyEntry.getOutIp()) ? ProxyEntry.BanState.HOST : (proxyEntry.isBanned() ? ProxyEntry.BanState.OTHER : ProxyEntry.BanState.OK));
        }
        return banState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        Path path = AppPaths.INSTANCE.getPROXY_ARCHIVE_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-PROXY_ARCHIVE_DIR>(...)");
        Path path2 = path;
        synchronized (path2) {
            Object object;
            boolean bl = false;
            try {
                Files.writeString(AppPaths.INSTANCE.getPROXY_BANNED_HOSTS_FILE(), (CharSequence)CollectionsKt.joinToString$default((Iterable)this.getBannedIps(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new OpenOption[0]);
                object = Files.writeString(AppPaths.INSTANCE.getPROXY_BANNED_SEGMENTS_FILE(), (CharSequence)CollectionsKt.joinToString$default((Iterable)this.getBannedSegments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.warn(e.toString());
                object = Unit.INSTANCE;
            }
            Unit unit = object;
        }
        super.dump();
    }

    @Override
    @NotNull
    public String toString() {
        String string = "total %d, free: %d, banH: %d banS: %d";
        Object[] objectArray = new Object[]{this.getProxyEntries().size(), this.getFreeProxies().size(), this.getBannedIps().size(), this.getBannedSegments().size()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final /* synthetic */ ConcurrentPassiveExpiringSet access$getBannedIps(LoadingProxyPool $this) {
        return $this.getBannedIps();
    }

    public static final /* synthetic */ ConcurrentPassiveExpiringSet access$getBannedSegments(LoadingProxyPool $this) {
        return $this.getBannedSegments();
    }
}

