/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DomUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtil.class);

    public static void saveDom(OutputStream os, Element e) {
        DOMSource source = new DOMSource(e);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.flush();
        }
        catch (UnsupportedEncodingException e1) {
            LOG.error("Failed with the following UnsupportedEncodingException: ", (Throwable)e1);
        }
        catch (IOException e1) {
            LOG.error("Failed to with the following IOException: ", (Throwable)e1);
        }
        catch (TransformerConfigurationException e2) {
            LOG.error("Failed with the following TransformerConfigurationException: ", (Throwable)e2);
        }
        catch (TransformerException ex) {
            LOG.error("Failed with the following TransformerException: ", (Throwable)ex);
        }
    }

    public static String getAttribute(Node node, String attrName) {
        Node attrNode;
        NamedNodeMap map = node.getAttributes();
        if (map != null && (attrNode = map.getNamedItem(attrName)) != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static String getId(Node node) {
        return DomUtil.getId(node, false);
    }

    public static String getId(Node node, boolean prefix) {
        String id = DomUtil.getAttribute(node, "id");
        if (id != null) {
            String p = prefix ? "#" : "";
            return p + id;
        }
        return null;
    }

    public static String getClassString(Node node) {
        return DomUtil.getAttribute(node, "class");
    }

    public static Set<String> getClasses(Node node) {
        return DomUtil.getClasses(node, "");
    }

    public static Set<String> getClasses(Node node, String prefix) {
        HashSet classes = Sets.newHashSet();
        String cls = DomUtil.getAttribute(node, "class");
        if (cls != null) {
            for (String s2 : cls.split("\\s+")) {
                if (s2 == null) continue;
                classes.add(prefix + s2);
            }
        }
        return classes;
    }

    public static Set<String> getSimpleSelectors(Node node) {
        Set<String> selectors = DomUtil.getClasses(node, ".");
        String id = DomUtil.getId(node, true);
        if (id != null) {
            selectors.add(id);
        }
        return selectors;
    }

    public static String getPrettyName(Node node) {
        NamedNodeMap map = node.getAttributes();
        Object msg = node.getNodeName().toLowerCase();
        if (map != null) {
            Node cls;
            Node id = map.getNamedItem("id");
            if (id != null) {
                msg = (String)msg + "#" + id.getNodeValue();
            }
            if ((cls = map.getNamedItem("class")) != null) {
                msg = (String)msg + "." + StringUtils.join((Object[])cls.getNodeValue().split("\\s+"), (char)'.');
            }
        }
        return msg;
    }
}

