/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.config.AbstractConfiguration;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.KConfiguration;
import ai.platon.pulsar.common.config.VolatileConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004J+\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00152\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0017\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0015J\u001b\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0086\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!J+\u0010\"\u001a\u00020\u000f\"\u000e\b\u0000\u0010#*\b\u0012\u0004\u0012\u0002H#0$2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u0002H#\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020'J\u0016\u0010(\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u001a\u0010)\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u0016\u0010*\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020.J\u0016\u0010/\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u000200J)\u00101\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0017\"\u00020\u0004\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u00067"}, d2={"Lai/platon/pulsar/common/config/MutableConfig;", "Lai/platon/pulsar/common/config/ImmutableConfig;", "()V", "profile", "", "(Ljava/lang/String;)V", "loadDefaults", "", "(Z)V", "resources", "", "(Ljava/lang/String;ZLjava/lang/Iterable;)V", "conf", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "clear", "", "getAndSet", "name", "value", "getAndUnset", "merge", "Lai/platon/pulsar/common/config/KConfiguration;", "names", "", "(Lai/platon/pulsar/common/config/KConfiguration;[Ljava/lang/String;)V", "reset", "set", "setBoolean", "setBooleanIfUnset", "setDouble", "", "setDuration", "duration", "Ljava/time/Duration;", "setEnum", "T", "", "(Ljava/lang/String;Ljava/lang/Enum;)V", "setFloat", "", "setIfNotEmpty", "setIfNotNull", "setInstant", "time", "Ljava/time/Instant;", "setInt", "", "setLong", "", "setStrings", "values", "(Ljava/lang/String;[Ljava/lang/String;)V", "toVolatileConfig", "Lai/platon/pulsar/common/config/VolatileConfig;", "unset", "pulsar-common"})
public class MutableConfig
extends ImmutableConfig {
    public MutableConfig() {
        this(false);
    }

    public MutableConfig(@NotNull String profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this(profile, true, CollectionsKt.emptyList());
    }

    public MutableConfig(boolean loadDefaults) {
        String string = System.getProperty("legacy.config.profile", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this(string, loadDefaults, CollectionsKt.emptyList());
    }

    public MutableConfig(@NotNull String profile, boolean loadDefaults, @NotNull Iterable<String> resources) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        super(profile, loadDefaults, resources);
    }

    public /* synthetic */ MutableConfig(String string, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            iterable = AbstractConfiguration.Companion.getDEFAULT_RESOURCES();
        }
        this(string, bl, iterable);
    }

    public MutableConfig(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf.unbox());
        this.setEnvironment(conf.getEnvironment());
    }

    public final void set(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getConf().set(name, value);
    }

    public final void setIfNotNull(@Nullable String name, @Nullable String value) {
        if (name != null && value != null) {
            this.set(name, value);
        }
    }

    public final void setIfNotEmpty(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence[] charSequenceArray = new CharSequence[]{name, value};
        if (StringUtils.isNoneEmpty((CharSequence[])charSequenceArray)) {
            this.set(name, value);
        }
    }

    @Nullable
    public final String getAndSet(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String old = this.get(name);
        if (old != null) {
            this.set(name, value);
        }
        return old;
    }

    @Nullable
    public final String getAndUnset(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String old = this.get(name);
        if (old != null) {
            this.unset(name);
        }
        return old;
    }

    public final void setStrings(@Nullable String name, String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        KConfiguration kConfiguration = this.getConf();
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        kConfiguration.setStrings(string, Arrays.copyOf(values, values.length));
    }

    public final void setInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.set(name, Integer.toString(value));
    }

    public final void setLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.set(name, String.valueOf(value));
    }

    public final void setFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.set(name, String.valueOf(value));
    }

    public final void setDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.set(name, String.valueOf(value));
    }

    public final void setBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.set(name, Boolean.toString(value));
    }

    public final void setBooleanIfUnset(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.unbox().setIfUnset(name, Boolean.toString(value));
    }

    public final <T extends Enum<T>> void setEnum(@NotNull String name, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.set(name, value.name());
    }

    public final void setInstant(@NotNull String name, @NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.set(name, time.toString());
    }

    public final void setDuration(@NotNull String name, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.set(name, duration.toString());
    }

    public final void unset(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.getConf().unset(name);
    }

    public final void clear() {
        this.getConf().clear();
    }

    public final void reset(@NotNull KConfiguration conf) {
        String key;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Iterator<Map.Entry<String, String>> iterator = conf.iterator();
        while (iterator.hasNext()) {
            key = iterator.next().getKey();
            this.unset(key);
        }
        for (Map.Entry<String, String> entry : conf) {
            key = entry.getKey();
            String value = entry.getValue();
            this.set(key, value);
        }
    }

    public final void merge(@NotNull KConfiguration conf, String ... names) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        for (Map.Entry<String, String> entry : conf) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!(names.length == 0) && !ArrayUtils.contains((Object[])names, (Object)key)) continue;
            this.set(key, value);
        }
    }

    @Override
    @NotNull
    public VolatileConfig toVolatileConfig() {
        return new VolatileConfig(this);
    }
}

