/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.ConcurrentUrlCache;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.LoadingUrlCache;
import ai.platon.pulsar.common.collect.UrlFeeder;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.QueueCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.urls.UrlAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001a\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0014J\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J(\u0010\u001e\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020!2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&J\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100(2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100(2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014J\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100(2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100(2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010+2\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110+0-2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110+0-J \u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110+0-2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014J\u001a\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110+0-2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110+0-2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010/\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110+2\b\b\u0002\u00100\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lai/platon/pulsar/common/collect/UrlFeederHelper;", "", "feeder", "Lai/platon/pulsar/common/collect/UrlFeeder;", "(Lai/platon/pulsar/common/collect/UrlFeeder;)V", "dcLogger", "Lorg/slf4j/Logger;", "getFeeder", "()Lai/platon/pulsar/common/collect/UrlFeeder;", "urlPool", "Lai/platon/pulsar/common/collect/UrlPool;", "getUrlPool", "()Lai/platon/pulsar/common/collect/UrlPool;", "add", "", "collector", "Lai/platon/pulsar/common/collect/collector/PriorityDataCollector;", "Lai/platon/pulsar/common/urls/UrlAware;", "addAll", "collectors", "", "addDefaults", "contains", "", "name", "", "names", "regex", "Lkotlin/text/Regex;", "containsLike", "create", "Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "priority", "", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "Lai/platon/pulsar/common/collect/collector/QueueCollector;", "queue", "Ljava/util/Queue;", "findByName", "", "findByNameLike", "remove", "Lai/platon/pulsar/common/collect/collector/DataCollector;", "removeAll", "", "removeAllLike", "report", "message", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlFeederHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlFeederHelper.kt\nai/platon/pulsar/common/collect/UrlFeederHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n800#2,11:136\n1855#2,2:147\n1855#2,2:149\n800#2,11:152\n1549#2:163\n1620#2,3:164\n1864#2,3:167\n1#3:151\n*S KotlinDebug\n*F\n+ 1 UrlFeederHelper.kt\nai/platon/pulsar/common/collect/UrlFeederHelper\n*L\n46#1:136,11\n46#1:147,2\n49#1:149,2\n114#1:152,11\n114#1:163\n114#1:164,3\n119#1:167,3\n*E\n"})
public final class UrlFeederHelper {
    @NotNull
    private final UrlFeeder feeder;
    @NotNull
    private final Logger dcLogger;

    public UrlFeederHelper(@NotNull UrlFeeder feeder) {
        Intrinsics.checkNotNullParameter((Object)feeder, (String)"feeder");
        this.feeder = feeder;
        this.dcLogger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(DataCollector.class));
    }

    @NotNull
    public final UrlFeeder getFeeder() {
        return this.feeder;
    }

    private final UrlPool getUrlPool() {
        return this.feeder.getUrlPool();
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.feeder.findByName(name);
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull Iterable<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return this.feeder.findByName(names);
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByName(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return this.feeder.findByName(regex);
    }

    @NotNull
    public final List<PriorityDataCollector<UrlAware>> findByNameLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.feeder.findByNameLike(name);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !((Collection)this.findByName(name)).isEmpty();
    }

    public final boolean contains(@NotNull Iterable<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return !((Collection)this.findByName(names)).isEmpty();
    }

    public final boolean contains(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return !((Collection)this.findByName(regex)).isEmpty();
    }

    public final boolean containsLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !((Collection)this.findByNameLike(name)).isEmpty();
    }

    public final void addDefaults() {
        this.feeder.addDefaultCollectors();
    }

    public final void add(@NotNull PriorityDataCollector<UrlAware> collector) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        this.addAll(CollectionsKt.listOf(collector));
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(@NotNull Iterable<? extends PriorityDataCollector<UrlAware>> collectors) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        Iterable<? extends PriorityDataCollector<UrlAware>> $this$filterIsInstance$iv = collectors;
        boolean $i$f$filterIsInstance = false;
        Iterator<? extends PriorityDataCollector<UrlAware>> iterator = $this$filterIsInstance$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
            collection.add(element$iv$iv);
        }
        Iterable<? extends PriorityDataCollector<UrlAware>> $this$forEach$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object e : $this$forEach$iv) {
            UrlCacheCollector it = (UrlCacheCollector)e;
            boolean bl = false;
            this.getUrlPool().getOrderedCaches().put(it.getPriority(), it.getUrlCache());
        }
        $this$forEach$iv = collectors;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            PriorityDataCollector<UrlAware> priorityDataCollector;
            PriorityDataCollector<UrlAware> it = priorityDataCollector = iterator.next();
            boolean bl = false;
            UrlFeederHelper.report$default(this, it, null, 2, null);
        }
        this.feeder.addCollectors(collectors);
    }

    @NotNull
    public final QueueCollector create(@NotNull String name, int priority, @NotNull Queue<UrlAware> queue) {
        QueueCollector queueCollector;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        QueueCollector it = queueCollector = new QueueCollector(queue, priority);
        boolean bl = false;
        it.setName(name);
        QueueCollector collector = queueCollector;
        this.feeder.addCollector(collector);
        UrlFeederHelper.report$default(this, collector, null, 2, null);
        return collector;
    }

    public static /* synthetic */ QueueCollector create$default(UrlFeederHelper urlFeederHelper, String string, int n, Queue queue, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Priority13.NORMAL.getValue();
        }
        if ((n2 & 4) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        return urlFeederHelper.create(string, n, queue);
    }

    @NotNull
    public final UrlCacheCollector create(int priority, @NotNull ExternalUrlLoader urlLoader) {
        UrlCacheCollector urlCacheCollector;
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        UrlCacheCollector it = urlCacheCollector = this.create("", priority, urlLoader);
        boolean bl = false;
        it.setName("LFC@" + it.getId());
        return urlCacheCollector;
    }

    @NotNull
    public final UrlCacheCollector create(@NotNull String name, int priority, @NotNull ExternalUrlLoader urlLoader) {
        UrlCacheCollector urlCacheCollector;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        LoadingUrlCache urlCache2 = new LoadingUrlCache(name, priority, urlLoader, 0, 8, null);
        this.getUrlPool().getUnorderedCaches().add(urlCache2);
        UrlCacheCollector it = urlCacheCollector = new UrlCacheCollector(urlCache2);
        boolean bl = false;
        it.setName(name);
        UrlCacheCollector collector = urlCacheCollector;
        UrlFeederHelper.report$default(this, collector, null, 2, null);
        this.feeder.addCollector(collector);
        return collector;
    }

    @NotNull
    public final UrlCacheCollector create(int priority) {
        UrlCacheCollector urlCacheCollector;
        UrlCacheCollector it = urlCacheCollector = this.create("", priority);
        boolean bl = false;
        it.setName("FC@" + it.getId());
        return urlCacheCollector;
    }

    @NotNull
    public final UrlCacheCollector create(@NotNull String name, int priority) {
        UrlCacheCollector urlCacheCollector;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentUrlCache urlCache2 = new ConcurrentUrlCache(name, 0, 2, null);
        this.getUrlPool().getUnorderedCaches().add(urlCache2);
        UrlCacheCollector it = urlCacheCollector = new UrlCacheCollector(urlCache2);
        boolean bl = false;
        it.setName(name);
        UrlCacheCollector collector = urlCacheCollector;
        this.feeder.addCollector(collector);
        UrlFeederHelper.report$default(this, collector, null, 2, null);
        return collector;
    }

    @Nullable
    public final DataCollector<UrlAware> remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (DataCollector)CollectionsKt.firstOrNull((Iterable)this.removeAll(CollectionsKt.listOf((Object)name)));
    }

    @NotNull
    public final Collection<DataCollector<UrlAware>> removeAll(@NotNull Iterable<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        List<PriorityDataCollector<UrlAware>> collectors = this.feeder.findByName(names);
        return this.removeAll((Collection<? extends DataCollector<UrlAware>>)collectors);
    }

    @NotNull
    public final Collection<DataCollector<UrlAware>> removeAll(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        List<PriorityDataCollector<UrlAware>> collectors = this.feeder.findByName(regex);
        return this.removeAll((Collection<? extends DataCollector<UrlAware>>)collectors);
    }

    @NotNull
    public final Collection<DataCollector<UrlAware>> removeAllLike(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.removeAll(new Regex(".*" + name + ".*"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<DataCollector<UrlAware>> removeAll(@NotNull Collection<? extends DataCollector<UrlAware>> collectors) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        this.feeder.removeAll(collectors);
        Iterable $this$filterIsInstance$iv = collectors;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UrlCacheCollector urlCacheCollector = (UrlCacheCollector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrlCache());
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.getUrlPool().getUnorderedCaches().removeAll(it);
        if (!collectors.isEmpty()) {
            this.dcLogger.info("Removed collectors: " + CollectionsKt.joinToString$default((Iterable)collectors, null, null, null, (int)0, null, (Function1)removeAll.3.INSTANCE, (int)31, null));
            Iterable $this$forEachIndexed$iv = collectors;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void c;
                int n;
                Object item$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (DataCollector)item$iv;
                int i = n;
                boolean bl2 = false;
                this.dcLogger.info(i + 1 + ".\t" + (DataCollector)c);
            }
            this.dcLogger.info("");
        }
        return collectors;
    }

    public final void report(@NotNull DataCollector<? extends UrlAware> collector, @NotNull String message) {
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object msg = StringsKt.isBlank((CharSequence)message) ? "" : " | " + message;
        Object[] objectArray = new Object[]{collector.getName(), collector.getSize(), collector.getEstimatedSize(), msg, this.feeder.getOpenCollectors().getClass().getSimpleName(), ((Object)this.feeder.getOpenCollectors()).hashCode()};
        this.dcLogger.info("Task <{}> has {}/{} items{}, adding to {}@{}", objectArray);
        this.dcLogger.info("{}", collector);
    }

    public static /* synthetic */ void report$default(UrlFeederHelper urlFeederHelper, DataCollector dataCollector, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        urlFeederHelper.report(dataCollector, string);
    }
}

