/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.urls.TenantedUrl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0012\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J'\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040 \"\u00020\u0004\u00a2\u0006\u0002\u0010!J\u001c\u0010\"\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010$\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u001aH\u0007J\u001a\u0010&\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u001aH\u0007J\u001c\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u001aH\u0007J&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+2\b\b\u0002\u0010%\u001a\u00020\u001aH\u0007J&\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010.\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\u001aH\u0007J'\u00100\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040 \"\u00020\u0004\u00a2\u0006\u0002\u0010!J\u0018\u00101\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u001c\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\n\u00105\u001a\u000606j\u0002`7H\u0002J\u0010\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0018\u0010:\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0012\u0010<\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040>2\u0006\u0010\u0011\u001a\u00020\u0004J\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010@\u001a\u00020\u0004H\u0007J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u0004H\u0007J\u0018\u0010C\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010D\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007\u00a8\u0006E"}, d2={"Lai/platon/pulsar/common/urls/UrlUtils;", "", "()V", "decodeKeyLowerBound", "", "startKey", "decodeKeyUpperBound", "endKey", "fixPureQueryTargets", "Ljava/net/URL;", "base", "targetUrl", "getEndKey", "tenantId", "", "unreversedUrl", "getQueryParameters", "url", "parameterName", "getReversedHost", "reversedUrl", "getStartKey", "getURLOrNull", "spec", "getUrlWithoutParameters", "isInternal", "", "isNotInternal", "isStandard", "str", "keepQueryParameters", "parameterNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "mergeUrlArgs", "args", "normalize", "ignoreQuery", "normalizeOrEmpty", "normalizeOrNull", "normalizeUrls", "", "urls", "", "normalizedUrlAndKey", "Lkotlin/Pair;", "originalUrl", "norm", "removeQueryParameters", "resolveURL", "reverseAppendSplits", "", "string", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reverseHost", "hostName", "reverseUrl", "reverseUrlOrEmpty", "reverseUrlOrNull", "splitQueryParameters", "", "splitUrlArgs", "configuredUrl", "unreverseHost", "reversedHostName", "unreverseUrl", "unreverseUrlOrNull", "pulsar-common"})
@SourceDebugExtension(value={"SMAP\nUrlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlUtils.kt\nai/platon/pulsar/common/urls/UrlUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,692:1\n1#2:693\n1#2:704\n1603#3,9:694\n1855#3:703\n1856#3:705\n1612#3:706\n1179#3,2:707\n1253#3,4:709\n288#3,2:713\n151#4,6:715\n*S KotlinDebug\n*F\n+ 1 UrlUtils.kt\nai/platon/pulsar/common/urls/UrlUtils\n*L\n176#1:704\n176#1:694,9\n176#1:703\n176#1:705\n176#1:706\n187#1:707,2\n187#1:709,4\n199#1:713,2\n296#1:715,6\n*E\n"})
public final class UrlUtils {
    @NotNull
    public static final UrlUtils INSTANCE = new UrlUtils();

    private UrlUtils() {
    }

    @JvmStatic
    public static final boolean isInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://internal.pulsar.platon.ai", (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final boolean isNotInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return !UrlUtils.isInternal(url);
    }

    @JvmStatic
    @Nullable
    public static final URL getURLOrNull(@Nullable String spec) {
        Object object = spec;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return null;
        }
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)new URL(spec));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (URL)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @JvmStatic
    public static final boolean isStandard(@Nullable String str) {
        return UrlUtils.getURLOrNull(str) != null;
    }

    @JvmStatic
    @NotNull
    public static final URL normalize(@NotNull String url, boolean ignoreQuery) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String url0 = (String)UrlUtils.splitUrlArgs(url).component1();
        URIBuilder uriBuilder = new URIBuilder(url0);
        uriBuilder.setFragment(null);
        if (ignoreQuery) {
            uriBuilder.removeQuery();
        }
        URL uRL = uriBuilder.build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    public static /* synthetic */ URL normalize$default(String string, boolean bl, int n, Object object) throws URISyntaxException, IllegalArgumentException, MalformedURLException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalize(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeOrEmpty(@NotNull String url, boolean ignoreQuery) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrEmpty$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrEmpty(string, bl);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeOrNull(@NotNull String url, boolean ignoreQuery) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.normalize(url, ignoreQuery).toString();
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String normalizeOrNull$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeOrNull(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> normalizeUrls(@NotNull Iterable<String> urls, boolean ignoreQuery) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable<String> $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable<String> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (UrlUtils.normalizeOrNull(it, ignoreQuery) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List normalizeUrls$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizeUrls(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> splitQueryParameters(@NotNull String url) throws URISyntaxException {
        Map map;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        List list2 = new URIBuilder(url).getQueryParams();
        if (list2 != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = list2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                NameValuePair it = (NameValuePair)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getQueryParameters(@NotNull String url, @NotNull String parameterName) throws URISyntaxException {
        Object v2;
        List list2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
            List list3 = new URIBuilder(url).getQueryParams();
            list2 = list3;
            if (list3 == null) return null;
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NameValuePair it = (NameValuePair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        NameValuePair nameValuePair = v2;
        list2 = nameValuePair;
        if (nameValuePair == null) return null;
        String string = list2.getValue();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$removeQueryParameters_u24lambda_u245;
        List list2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list3 = list2 = uriBuilder.getQueryParams();
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl = false;
        $this$removeQueryParameters_u24lambda_u245.removeIf(arg_0 -> UrlUtils.removeQueryParameters$lambda$5$lambda$4((Function1)new Function1<NameValuePair, Boolean>(parameterNames){
            final /* synthetic */ String[] $parameterNames;
            {
                this.$parameterNames = $parameterNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(NameValuePair it) {
                return ArraysKt.contains((Object[])this.$parameterNames, (Object)it.getName());
            }
        }, arg_0));
        uRIBuilder.setParameters(list2);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String keepQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$keepQueryParameters_u24lambda_u247;
        List list2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list3 = list2 = uriBuilder.getQueryParams();
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl = false;
        $this$keepQueryParameters_u24lambda_u247.removeIf(arg_0 -> UrlUtils.keepQueryParameters$lambda$7$lambda$6((Function1)new Function1<NameValuePair, Boolean>(parameterNames){
            final /* synthetic */ String[] $parameterNames;
            {
                this.$parameterNames = $parameterNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(NameValuePair it) {
                return !ArraysKt.contains((Object[])this.$parameterNames, (Object)it.getName());
            }
        }, arg_0));
        uRIBuilder.setParameters(list2);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final URL resolveURL(@NotNull URL base, @NotNull String targetUrl) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        String target = ((Object)StringsKt.trim((CharSequence)targetUrl)).toString();
        return StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null) ? INSTANCE.fixPureQueryTargets(base, target) : new URL(base, target);
    }

    private final URL fixPureQueryTargets(URL base, String targetUrl) {
        Object target = ((Object)StringsKt.trim((CharSequence)targetUrl)).toString();
        if (!StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            return new URL(base, (String)target);
        }
        String basePath = base.getPath();
        String baseRightMost = "";
        Intrinsics.checkNotNull((Object)basePath);
        int baseRightMostIdx = StringsKt.lastIndexOf$default((CharSequence)basePath, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (baseRightMostIdx != -1) {
            String string = basePath.substring(baseRightMostIdx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            baseRightMost = string;
        }
        if (StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            target = baseRightMost + (String)target;
        }
        return new URL(base, (String)target);
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> splitUrlArgs(@NotNull String configuredUrl) {
        int n;
        String url;
        block2: {
            Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)configuredUrl)).toString();
            Regex regex = new Regex("[\\r\\n\\t]");
            String string = "";
            url = regex.replace(charSequence, string);
            CharSequence $this$indexOfFirst$iv = url;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)it)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int pos = n;
        String args = "";
        if (pos >= 0) {
            String string = url.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            args = string;
            String string2 = url.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            url = string2;
        }
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)url)).toString(), (Object)((Object)StringsKt.trim((CharSequence)args)).toString());
    }

    @JvmStatic
    @NotNull
    public static final String mergeUrlArgs(@NotNull String url, @Nullable String args) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = args;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ((Object)StringsKt.trim((CharSequence)url)).toString() : ((Object)StringsKt.trim((CharSequence)url)).toString() + " " + ((Object)StringsKt.trim((CharSequence)args)).toString();
    }

    public static /* synthetic */ String mergeUrlArgs$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return UrlUtils.mergeUrlArgs(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String getUrlWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(url);
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> normalizedUrlAndKey(@NotNull String originalUrl, boolean norm) {
        String string;
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        if (norm) {
            string = UrlUtils.normalizeOrNull$default(originalUrl, false, 2, null);
            if (string == null) {
                string = "";
            }
        } else {
            string = originalUrl;
        }
        String url = string;
        String key = UrlUtils.reverseUrlOrEmpty(url);
        return TuplesKt.to((Object)url, (Object)key);
    }

    public static /* synthetic */ Pair normalizedUrlAndKey$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UrlUtils.normalizedUrlAndKey(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return UrlUtils.reverseUrl(new URL(url));
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrlOrEmpty(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String reverseUrlOrNull(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = UrlUtils.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        String file = url.getFile();
        String protocol = url.getProtocol();
        int port = url.getPort();
        StringBuilder buf = new StringBuilder();
        Intrinsics.checkNotNull((Object)host);
        INSTANCE.reverseAppendSplits(host, buf);
        buf.append(':');
        buf.append(protocol);
        if (port != -1) {
            buf.append(':');
            buf.append(port);
        }
        Intrinsics.checkNotNull((Object)file);
        if (((CharSequence)file).length() > 0 && '/' != file.charAt(0)) {
            buf.append('/');
        }
        buf.append(file);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(int tenantId, @NotNull String unreversedUrl) {
        Intrinsics.checkNotNullParameter((Object)unreversedUrl, (String)"unreversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(unreversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.reverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        StringBuilder buf = new StringBuilder(reversedUrl.length() + 2);
        int pathBegin = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pathBegin == -1) {
            pathBegin = reversedUrl.length();
        }
        String string = reversedUrl.substring(0, pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String sub = string;
        String[] splits = StringUtils.splitPreserveAllTokens((String)sub, (char)':');
        buf.append(splits[1]);
        buf.append("://");
        String string2 = splits[0];
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        INSTANCE.reverseAppendSplits(string2, buf);
        if (splits.length == 3) {
            buf.append(':');
            buf.append(splits[2]);
        }
        String string3 = reversedUrl.substring(pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        buf.append(string3);
        String string4 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @JvmStatic
    @Nullable
    public static final String unreverseUrlOrNull(@NotNull String reversedUrl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)UrlUtils.unreverseUrl(reversedUrl));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(int tenantId, @NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(reversedUrl);
        return TenantedUrl.Companion.combine(tenantId, UrlUtils.unreverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId);
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String startKey = UrlUtils.decodeKeyLowerBound(unreversedUrl);
        return UrlUtils.reverseUrl(startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(endKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId + 1);
        }
        String endKey = UrlUtils.decodeKeyUpperBound(unreversedUrl);
        return UrlUtils.reverseUrl(tenantId, endKey);
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyLowerBound(@NotNull String startKey) {
        Intrinsics.checkNotNullParameter((Object)startKey, (String)"startKey");
        String startKey2 = startKey;
        CharSequence charSequence = startKey2;
        Regex regex = new Regex("\\\\u0001");
        String string = "\u0001";
        startKey2 = regex.replace(charSequence, string);
        charSequence = startKey2;
        regex = new Regex("\\u0001");
        string = "\u0001";
        startKey2 = regex.replace(charSequence, string);
        return startKey2;
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyUpperBound(@NotNull String endKey) {
        Intrinsics.checkNotNullParameter((Object)endKey, (String)"endKey");
        String endKey2 = endKey;
        CharSequence charSequence = endKey2;
        Regex regex = new Regex("\\\\uFFFF");
        String string = "\uffff";
        endKey2 = regex.replace(charSequence, string);
        charSequence = endKey2;
        regex = new Regex("\\uFFFF");
        string = "\uffff";
        endKey2 = regex.replace(charSequence, string);
        return endKey2;
    }

    @JvmStatic
    @NotNull
    public static final String getReversedHost(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        String string = reversedUrl.substring(0, StringsKt.indexOf$default((CharSequence)reversedUrl, (char)':', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseHost(@NotNull String hostName) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        StringBuilder buf = new StringBuilder();
        INSTANCE.reverseAppendSplits(hostName, buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String unreverseHost(@NotNull String reversedHostName) {
        Intrinsics.checkNotNullParameter((Object)reversedHostName, (String)"reversedHostName");
        return UrlUtils.reverseHost(reversedHostName);
    }

    private final void reverseAppendSplits(String string, StringBuilder buf) {
        String[] splits = StringUtils.split((String)string, (char)'.');
        Intrinsics.checkNotNull((Object)splits);
        if (!(splits.length == 0)) {
            for (int i = splits.length - 1; 0 < i; --i) {
                buf.append(splits[i]);
                buf.append('.');
            }
            buf.append(splits[0]);
        } else {
            buf.append(string);
        }
    }

    private static final boolean removeQueryParameters$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean keepQueryParameters$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

