/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.BinaryTreeNode;
import ai.platon.pulsar.common.Frequency;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\u0016B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011JJ\u0010\u0012\u001a\u00020\u00112\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bR\b\u0012\u0004\u0012\u00028\u00000\u00002(\u0010\u0013\u001a$\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\bR\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0014R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bR\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/common/HuffmanTree;", "T", "", "", "frequency", "Lai/platon/pulsar/common/Frequency;", "(Lai/platon/pulsar/common/Frequency;)V", "root", "Lai/platon/pulsar/common/HuffmanTree$Node;", "getRoot", "()Lai/platon/pulsar/common/HuffmanTree$Node;", "decode", "", "input", "getEncodingMap", "", "print", "", "traverse", "visitor", "Lkotlin/Function2;", "", "Node", "pulsar-common"})
public final class HuffmanTree<T extends Comparable<? super T>> {
    @NotNull
    private final Node<T> root;

    @NotNull
    public final Node<T> getRoot() {
        return this.root;
    }

    public final void print() {
        this.root.print(2);
    }

    public final void traverse(@Nullable Node<T> root, @NotNull Function2<? super Node<T>, ? super Integer, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        Node<T> node = root;
        int depth = 0;
        while (node != null) {
            visitor.invoke(node, (Object)depth);
            this.traverse(node.getLeft(), visitor);
            this.traverse(node.getRight(), visitor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String decode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String result = "";
        Node<T> n = this.root;
        int n2 = 0;
        int n3 = input.length();
        while (n2 < n3) {
            void i;
            char ch = input.charAt((int)i);
            if (ch == '0') {
                Node<T> node = n;
                n = node != null ? node.getLeft() : null;
            } else {
                Node<T> node = n;
                n = node != null ? node.getRight() : null;
            }
            Node<T> node = n;
            if ((node != null ? node.getLeft() : null) == null && n != null) {
                result = result + (Comparable)n.getData();
                n = this.root;
            }
            ++i;
        }
        return result;
    }

    @NotNull
    public final Map<T, String> getEncodingMap() {
        return this.root.fillEncodingMap(new HashMap(), "");
    }

    /*
     * WARNING - void declaration
     */
    public HuffmanTree(@NotNull Frequency<T> frequency) {
        Multiset.Entry it;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(frequency, (String)"frequency");
        Iterable iterable = frequency.entrySet();
        Collection destination$iv = new PriorityQueue();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Multiset.Entry entry = (Multiset.Entry)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Object object = it.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.element");
            Node node = new Node(this, object, it.getCount(), null, null, 12, null);
            collection.add(node);
        }
        PriorityQueue nodes = (PriorityQueue)destination$iv;
        int i = 0;
        Iterable $this$forEach$iv = frequency.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Multiset.Entry)element$iv;
            boolean bl = false;
            ++i;
            if (nodes.size() <= 1) continue;
            Node smallest = (Node)nodes.remove();
            Node nextSmallest = (Node)nodes.remove();
            Node node = new Node(this, it.getElement(), it.getCount(), null, null, 12, null);
            node.setFrequency(smallest.getFrequency() + nextSmallest.getFrequency());
            node.setLeft(smallest);
            node.setRight(nextSmallest);
            nodes.add(node);
        }
        int sz = frequency.entrySet().size();
        String string = i + " while size is " + sz;
        boolean bl = false;
        System.out.println((Object)string);
        Object e = nodes.remove();
        Intrinsics.checkNotNullExpressionValue(e, (String)"nodes.remove()");
        this.root = (Node)e;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u0002H\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u00030\u0002BM\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\tJ!\u0010\u0019\u001a\u00020\u00062\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0096\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003J.\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u0006J\b\u0010'\u001a\u00020\u001dH\u0016R\u001c\u0010\u0004\u001a\u00028\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R,\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016\u00a8\u0006("}, d2={"Lai/platon/pulsar/common/HuffmanTree$Node;", "T", "", "Lai/platon/pulsar/common/HuffmanTree;", "data", "frequency", "", "left", "right", "(Lai/platon/pulsar/common/HuffmanTree;Ljava/lang/Object;ILai/platon/pulsar/common/HuffmanTree$Node;Lai/platon/pulsar/common/HuffmanTree$Node;)V", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getFrequency", "()I", "setFrequency", "(I)V", "getLeft", "()Lai/platon/pulsar/common/HuffmanTree$Node;", "setLeft", "(Lai/platon/pulsar/common/HuffmanTree$Node;)V", "getRight", "setRight", "compareTo", "other", "convert", "Lai/platon/pulsar/common/BinaryTreeNode;", "", "copy", "fillEncodingMap", "", "map", "", "prefix", "print", "", "margin", "toString", "pulsar-common"})
    public final class Node<T>
    implements Comparable<Node<T>> {
        private T data;
        private int frequency;
        @Nullable
        private Node<T> left;
        @Nullable
        private Node<T> right;
        final /* synthetic */ HuffmanTree this$0;

        @NotNull
        public final Map<T, String> fillEncodingMap(@NotNull Map<T, String> map, @NotNull String prefix) {
            block2: {
                block1: {
                    Intrinsics.checkNotNullParameter(map, (String)"map");
                    Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                    if (this.left != null) break block1;
                    map.put(this.data, prefix);
                    break block2;
                }
                Node<T> node = this.left;
                if (node != null) {
                    node.fillEncodingMap(map, prefix + "0");
                }
                Node<T> node2 = this.right;
                if (node2 == null) break block2;
                node2.fillEncodingMap(map, prefix + "1");
            }
            return map;
        }

        public final void print(int margin) {
            block1: {
                String string = StringsKt.repeat((CharSequence)"\t", (int)margin);
                boolean bl = false;
                System.out.print((Object)string);
                string = this.data;
                bl = false;
                System.out.println((Object)string);
                Node<T> node = this.left;
                if (node != null) {
                    node.print(2 + margin);
                }
                Node<T> node2 = this.right;
                if (node2 == null) break block1;
                node2.print(2 + margin);
            }
        }

        public static /* synthetic */ void print$default(Node node, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 2;
            }
            node.print(n);
        }

        @NotNull
        public final Node<T> copy() {
            Node<T> node = this.left;
            Node<T> node2 = this.right;
            return new Node<T>(this.this$0, this.data, this.frequency, node != null ? node.copy() : null, node2 != null ? node2.copy() : null);
        }

        @NotNull
        public final BinaryTreeNode<String> convert() {
            Node<T> node = this.left;
            Node<T> node2 = this.right;
            return new BinaryTreeNode<String>(this.toString(), node != null ? node.convert() : null, node2 != null ? node2.convert() : null);
        }

        @Override
        public int compareTo(@NotNull Node<T> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.frequency - other.frequency;
        }

        @NotNull
        public String toString() {
            return "" + this.data + ':' + this.frequency;
        }

        public final T getData() {
            return this.data;
        }

        public final void setData(T t) {
            this.data = t;
        }

        public final int getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(int n) {
            this.frequency = n;
        }

        @Nullable
        public final Node<T> getLeft() {
            return this.left;
        }

        public final void setLeft(@Nullable Node<T> node) {
            this.left = node;
        }

        @Nullable
        public final Node<T> getRight() {
            return this.right;
        }

        public final void setRight(@Nullable Node<T> node) {
            this.right = node;
        }

        public Node(HuffmanTree this$0, T data, @Nullable int frequency, @Nullable Node<T> left, Node<T> right) {
            this.this$0 = this$0;
            this.data = data;
            this.frequency = frequency;
            this.left = left;
            this.right = right;
        }

        public /* synthetic */ Node(HuffmanTree huffmanTree, Object object, int n, Node node, Node node2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                node = null;
            }
            if ((n2 & 8) != 0) {
                node2 = null;
            }
            this(huffmanTree, object, n, node, node2);
        }
    }
}

