/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.MessageWriter;
import ai.platon.pulsar.common.MultiSinkWriter;
import ai.platon.pulsar.common.config.ImmutableConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/platon/pulsar/common/MultiSinkWriter;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "jobIdent", "", "reportDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "timeIdent", "writers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/common/MessageWriter;", "close", "", "closeWriter", "filename", "getPath", "readAllLines", "", "write", "message", "file", "writeLine", "pulsar-common"})
public abstract class MultiSinkWriter
implements AutoCloseable {
    private final String timeIdent;
    private final String jobIdent;
    private final Path reportDir;
    private final ConcurrentHashMap<Path, MessageWriter> writers;
    private final AtomicBoolean closed;
    @NotNull
    private final ImmutableConfig conf;

    @NotNull
    public final Path getPath(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.reportDir.resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"reportDir.resolve(filename)");
        return path;
    }

    @NotNull
    public final List<String> readAllLines(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = this.getPath(filename);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(path)");
            return list;
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    public final void write(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.write(message, this.getPath(filename));
    }

    public final void write(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.writers.computeIfAbsent(file.toAbsolutePath(), write.1.INSTANCE).write(message);
    }

    public final void writeLine(@NotNull String message, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.writeLine(message, this.getPath(filename));
    }

    public final void writeLine(@NotNull String message, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MessageWriter messageWriter = this.writers.computeIfAbsent(file.toAbsolutePath(), writeLine.writer.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)messageWriter, (String)"writers.computeIfAbsent(\u2026()) { MessageWriter(it) }");
        MessageWriter writer2 = messageWriter;
        writer2.write(message);
        writer2.write("\n");
    }

    public final void closeWriter(@NotNull String filename) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            MessageWriter messageWriter = this.writers.get(this.getPath(filename));
            if (messageWriter == null) break block0;
            messageWriter.close();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Collection<MessageWriter> collection = this.writers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"writers.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MessageWriter it = (MessageWriter)element$iv;
                boolean bl = false;
                it.close();
            }
        }
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public MultiSinkWriter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.timeIdent = DateTimes.INSTANCE.formatNow("MMdd");
        this.jobIdent = this.conf.get("pulsar.job.name", DateTimes.INSTANCE.now("HHmm"));
        this.reportDir = AppPaths.INSTANCE.getREPORT_DIR().resolve(this.timeIdent).resolve(this.jobIdent);
        this.writers = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        Files.createDirectories(this.reportDir, new FileAttribute[0]);
    }
}

