/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lai/platon/pulsar/common/Ping;", "", "()V", "getCheckResult", "", "line", "", "getTimes", "", "ping", "", "ipAddress", "pingTimes", "timeout", "Ljava/time/Duration;", "ping02", "", "pingNeedTime", "timeOut", "pulsar-common"})
public final class Ping {
    @NotNull
    public static final Ping INSTANCE;

    public final boolean ping(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        int timeOut = 3000;
        return InetAddress.getByName(ipAddress).isReachable(timeOut);
    }

    public final void ping02(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        try {
            Process pro;
            Process process = pro = Runtime.getRuntime().exec("ping " + ipAddress);
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"pro");
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = buf.readLine();
            while (line != null) {
                boolean bl = false;
                System.out.println((Object)line);
                line = buf.readLine();
            }
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean ping(@NotNull String ipAddress, int pingTimes, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        reader = null;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " /n " + pingTimes + " /w " + timeout.toMillis() : "ping -c " + pingTimes + " -w " + timeout.getSeconds() + ' ' + ipAddress;
        try {
            var7_7 = false;
            System.out.println((Object)pingCommand);
            if (r.exec(pingCommand) != null) {
                p = v0;
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                connectedCount = 0;
                line = reader.readLine();
            } else {
                var8_11 = false;
                ** try [egrp 1[TRYBLOCK] [0 : 145->149)] { 
lbl19:
                // 1 sources

                return var8_11;
            }
            while (line != null) {
                var10_18 = false;
                System.out.println((Object)line);
                connectedCount += this.getCheckResult(line);
                line = reader.readLine();
            }
            var10_18 = connectedCount == pingTimes;
            ** try [egrp 3[TRYBLOCK] [1 : 245->254)] { 
lbl28:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = false;
            return connectedCount;
        }
lbl36:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var8_11;
lbl-1000:
        // 1 sources

        {
            reader.close();
            return var10_18;
        }
lbl41:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var10_18;
        finally {
            try {
                v1 = reader;
                if (v1 != null) {
                    v1.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float pingNeedTime(@NotNull String ipAddress, int pingTimes, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        reader = null;
        time = 10000.0f;
        r = Runtime.getRuntime();
        pingCommand = SystemUtils.IS_OS_WINDOWS != false ? "ping " + ipAddress + " -n " + pingTimes + " -w " + timeOut : "ping -c " + pingTimes + " -w " + timeOut / 1000 + ' ' + ipAddress;
        try {
            if (r.exec(pingCommand) != null) {
                p = v0;
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                connectedCount = 0;
                timeTotal = 0.0f;
                spendTime = 0.0f;
                line = reader.readLine();
            } else {
                var9_8 = time;
                ** try [egrp 1[TRYBLOCK] [0 : 131->135)] { 
lbl19:
                // 1 sources

                return var9_8;
            }
            while (line != null) {
                spendTime = this.getTimes(line);
                if (spendTime > (float)false) {
                    timeTotal += spendTime;
                    ++connectedCount;
                }
                line = reader.readLine();
            }
            var13_20 = timeTotal / (float)connectedCount;
            ** try [egrp 3[TRYBLOCK] [1 : 236->245)] { 
lbl29:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception ex) {
            ex.printStackTrace();
            connectedCount = time;
            return connectedCount;
        }
lbl37:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var9_8;
lbl-1000:
        // 1 sources

        {
            reader.close();
            return var13_20;
        }
lbl42:
        // 1 sources

        catch (IOException e) {
            e.printStackTrace();
        }
        return var13_20;
        finally {
            try {
                v1 = reader;
                if (v1 != null) {
                    v1.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final float getTimes(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.getCheckResult(line) == 0) {
            return 0.0f;
        }
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+)ms") : Pattern.compile("(\\d+.?\\d+)\\s+ms");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String string = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
            String string2 = StringsKt.substringBefore$default((String)string, (String)"ms", null, (int)2, null);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String str = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            return NumberUtils.toFloat((String)str);
        }
        return 10000.0f;
    }

    private final int getCheckResult(String line) {
        Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("(\\d+ms)(\\s+)(TTL=\\d+)", 2) : Pattern.compile("(ttl=\\d+)(\\s+)(.+)=(\\d+.?\\d+ ms)", 2);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        return 0;
    }

    private Ping() {
    }

    static {
        Ping ping;
        INSTANCE = ping = new Ping();
    }
}

