/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J\u001c\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/common/Sockets;", "", "()V", "PORT_RANGE_MAX", "", "PORT_RANGE_MIN", "random", "Ljava/util/Random;", "findAvailableTcpPort", "minPort", "maxPort", "findAvailableTcpPorts", "Ljava/util/SortedSet;", "numRequested", "findAvailableUdpPort", "findAvailableUdpPorts", "SocketType", "pulsar-common"})
public final class Sockets {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random;
    @NotNull
    public static final Sockets INSTANCE;

    @JvmOverloads
    public final int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePort(minPort, maxPort);
    }

    public static /* synthetic */ int findAvailableTcpPort$default(Sockets sockets, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1024;
        }
        if ((n3 & 2) != 0) {
            n2 = 65535;
        }
        return sockets.findAvailableTcpPort(n, n2);
    }

    @JvmOverloads
    public final int findAvailableTcpPort(int minPort) {
        return Sockets.findAvailableTcpPort$default(this, minPort, 0, 2, null);
    }

    @JvmOverloads
    public final int findAvailableTcpPort() {
        return Sockets.findAvailableTcpPort$default(this, 0, 0, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.TCP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    public static /* synthetic */ SortedSet findAvailableTcpPorts$default(Sockets sockets, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 1024;
        }
        if ((n4 & 4) != 0) {
            n3 = 65535;
        }
        return sockets.findAvailableTcpPorts(n, n2, n3);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested, int minPort) {
        return Sockets.findAvailableTcpPorts$default(this, numRequested, minPort, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableTcpPorts(int numRequested) {
        return Sockets.findAvailableTcpPorts$default(this, numRequested, 0, 0, 6, null);
    }

    @JvmOverloads
    public final int findAvailableUdpPort(int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePort(minPort, maxPort);
    }

    public static /* synthetic */ int findAvailableUdpPort$default(Sockets sockets, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 1024;
        }
        if ((n3 & 2) != 0) {
            n2 = 65535;
        }
        return sockets.findAvailableUdpPort(n, n2);
    }

    @JvmOverloads
    public final int findAvailableUdpPort(int minPort) {
        return Sockets.findAvailableUdpPort$default(this, minPort, 0, 2, null);
    }

    @JvmOverloads
    public final int findAvailableUdpPort() {
        return Sockets.findAvailableUdpPort$default(this, 0, 0, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested, int minPort, int maxPort) {
        return SocketType.UDP.findAvailablePorts(numRequested, minPort, maxPort);
    }

    public static /* synthetic */ SortedSet findAvailableUdpPorts$default(Sockets sockets, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 1024;
        }
        if ((n4 & 4) != 0) {
            n3 = 65535;
        }
        return sockets.findAvailableUdpPorts(n, n2, n3);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested, int minPort) {
        return Sockets.findAvailableUdpPorts$default(this, numRequested, minPort, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SortedSet<Integer> findAvailableUdpPorts(int numRequested) {
        return Sockets.findAvailableUdpPorts$default(this, numRequested, 0, 0, 6, null);
    }

    private Sockets() {
    }

    static {
        Sockets sockets;
        INSTANCE = sockets = new Sockets();
        random = new Random(System.currentTimeMillis());
    }

    public static final /* synthetic */ Random access$getRandom$p(Sockets $this) {
        Sockets sockets = $this;
        return random;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H$j\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType;", "", "(Ljava/lang/String;I)V", "findAvailablePort", "", "minPort", "maxPort", "findAvailablePorts", "Ljava/util/SortedSet;", "numRequested", "findRandomPort", "isPortAvailable", "", "port", "TCP", "UDP", "pulsar-common"})
    private static final abstract class SocketType
    extends Enum<SocketType> {
        public static final /* enum */ SocketType TCP;
        public static final /* enum */ SocketType UDP;
        private static final /* synthetic */ SocketType[] $VALUES;

        static {
            SocketType[] socketTypeArray = new SocketType[2];
            SocketType[] socketTypeArray2 = socketTypeArray;
            socketTypeArray[0] = TCP = new TCP("TCP", 0);
            socketTypeArray[1] = UDP = new UDP("UDP", 1);
            $VALUES = socketTypeArray;
        }

        protected abstract boolean isPortAvailable(int var1);

        private final int findRandomPort(int minPort, int maxPort) {
            int portRange = maxPort - minPort;
            return minPort + Sockets.access$getRandom$p(INSTANCE).nextInt(portRange + 1);
        }

        public final int findAvailablePort(int minPort, int maxPort) {
            boolean bl = minPort > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "'minPort' must be greater than 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = maxPort >= minPort;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "'maxPort' must be greater than or equal to 'minPort'";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = maxPort <= 65535;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "'maxPort' must be less than or equal to 65535";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int portRange = maxPort - minPort;
            int candidatePort = 0;
            int searchCounter = 0;
            do {
                int n = searchCounter <= portRange ? 1 : 0;
                boolean bl7 = false;
                boolean bl8 = false;
                if (n == 0) {
                    boolean bl9 = false;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Could not find an available %s port in the range [%d, %d] after %d attempts";
                    Object[] objectArray = new Object[]{this.name(), minPort, maxPort, searchCounter};
                    boolean bl10 = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    String string3 = string2;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                candidatePort = this.findRandomPort(minPort, maxPort);
                n = searchCounter;
                searchCounter = n + 1;
            } while (!this.isPortAvailable(candidatePort));
            return candidatePort;
        }

        @NotNull
        public final SortedSet<Integer> findAvailablePorts(int numRequested, int minPort, int maxPort) {
            boolean bl = minPort > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "'minPort' must be greater than 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = maxPort > minPort;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "'maxPort' must be greater than 'minPort'";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = maxPort <= 65535;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "'maxPort' must be less than or equal to 65535";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = numRequested > 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "'numRequested' must be greater than 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = maxPort - minPort >= numRequested;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "'numRequested' must not be greater than 'maxPort' - 'minPort'";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            SortedSet availablePorts = new TreeSet();
            int attemptCount = 0;
            while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
                availablePorts.add(this.findAvailablePort(minPort, maxPort));
            }
            bl3 = availablePorts.size() == numRequested;
            boolean bl9 = false;
            boolean bl10 = false;
            if (!bl3) {
                boolean bl11 = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Could not find %d available %s ports in the range [%d, %d]";
                Object[] objectArray = new Object[]{numRequested, this.name(), minPort, maxPort};
                boolean bl12 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return availablePorts;
        }

        private SocketType() {
        }

        public /* synthetic */ SocketType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static SocketType[] values() {
            return (SocketType[])$VALUES.clone();
        }

        public static SocketType valueOf(String string) {
            return Enum.valueOf(SocketType.class, string);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType$TCP;", "Lai/platon/pulsar/common/Sockets$SocketType;", "isPortAvailable", "", "port", "", "pulsar-common"})
        static final class TCP
        extends SocketType {
            @Override
            protected boolean isPortAvailable(int port) {
                boolean bl;
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    bl = true;
                }
                catch (Exception ex) {
                    bl = false;
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            TCP() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lai/platon/pulsar/common/Sockets$SocketType$UDP;", "Lai/platon/pulsar/common/Sockets$SocketType;", "isPortAvailable", "", "port", "", "pulsar-common"})
        static final class UDP
        extends SocketType {
            @Override
            protected boolean isPortAvailable(int port) {
                boolean bl;
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName("localhost"));
                    socket.close();
                    bl = true;
                }
                catch (Exception ex) {
                    bl = false;
                }
                return bl;
            }

            /*
             * WARNING - void declaration
             */
            UDP() {
                void var1_1;
            }
        }
    }
}

