/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import ai.platon.pulsar.common.concurrent.ConcurrentLRUCache;
import ai.platon.pulsar.common.concurrent.ExpiringItem;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 2*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u00012B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J'\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J'\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010(J%\u0010)\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u00012\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010/\u001a\u00020\u00152\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001R#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "K", "T", "", "ttl", "Ljava/time/Duration;", "capacity", "", "(Ljava/time/Duration;I)V", "cache", "Lai/platon/pulsar/common/concurrent/ConcurrentLRUCache;", "Lai/platon/pulsar/common/concurrent/ExpiringItem;", "getCache", "()Lai/platon/pulsar/common/concurrent/ConcurrentLRUCache;", "getCapacity", "()I", "size", "getSize", "getTtl", "()Ljava/time/Duration;", "clear", "", "computeIfAbsent", "key", "mappingFunction", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "contains", "", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Lai/platon/pulsar/common/concurrent/ExpiringItem;", "getDatum", "(Ljava/lang/Object;)Ljava/lang/Object;", "expires", "now", "Ljava/time/Instant;", "(Ljava/lang/Object;Ljava/time/Duration;Ljava/time/Instant;)Ljava/lang/Object;", "put", "item", "(Ljava/lang/Object;Lai/platon/pulsar/common/concurrent/ExpiringItem;)V", "putDatum", "datum", "timestamp", "", "(Ljava/lang/Object;Ljava/lang/Object;J)V", "remove", "removeAll", "keys", "", "Companion", "pulsar-common"})
public final class ConcurrentExpiringLRUCache<K, T> {
    @NotNull
    private final ConcurrentLRUCache<K, ExpiringItem<T>> cache;
    @NotNull
    private final Duration ttl;
    private final int capacity;
    private static final Duration CACHE_TTL;
    public static final int CACHE_CAPACITY = 200;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ConcurrentLRUCache<K, ExpiringItem<T>> getCache() {
        return this.cache;
    }

    public final int getSize() {
        return this.cache.getSize();
    }

    public final void put(K key, @NotNull ExpiringItem<T> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.cache.put(key, item);
    }

    public final void putDatum(K key, T datum, long timestamp) {
        this.put(key, new ExpiringItem<T>(datum, timestamp));
    }

    public static /* synthetic */ void putDatum$default(ConcurrentExpiringLRUCache concurrentExpiringLRUCache, Object object, Object object2, long l, int n, Object object3) {
        if ((n & 4) != 0) {
            l = System.currentTimeMillis();
        }
        concurrentExpiringLRUCache.putDatum(object, object2, l);
    }

    @Nullable
    public final ExpiringItem<T> get(K key) {
        return this.cache.get(key);
    }

    @Nullable
    public final T getDatum(K key) {
        ExpiringItem<T> expiringItem = this.cache.get(key);
        return (T)(expiringItem != null ? expiringItem.getDatum() : null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final T getDatum(K key, @NotNull Duration expires, @NotNull Instant now) {
        T t;
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        ExpiringItem<T> expiringItem = this.get(key);
        if (expiringItem != null) {
            ExpiringItem<T> expiringItem2 = expiringItem;
            boolean bl = false;
            boolean bl2 = false;
            ExpiringItem<T> it = expiringItem2;
            boolean bl3 = false;
            expiringItem = !it.isExpired(expires, now) ? expiringItem2 : null;
            if (expiringItem != null) {
                t = expiringItem.getDatum();
                return t;
            }
        }
        t = null;
        return t;
    }

    public static /* synthetic */ Object getDatum$default(ConcurrentExpiringLRUCache concurrentExpiringLRUCache, Object object, Duration duration, Instant instant, int n, Object object2) {
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"Instant.now()");
            instant = instant2;
        }
        return concurrentExpiringLRUCache.getDatum(object, duration, instant);
    }

    public final boolean contains(K key) {
        return this.cache.get(key) != null;
    }

    public final T computeIfAbsent(K key, @NotNull Function1<? super K, ? extends T> mappingFunction) {
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        return this.cache.computeIfAbsent(key, (Function1)new Function1<K, ExpiringItem<T>>(mappingFunction, key){
            final /* synthetic */ Function1 $mappingFunction;
            final /* synthetic */ Object $key;

            @NotNull
            public final ExpiringItem<T> invoke(K it) {
                return new ExpiringItem<T>(this.$mappingFunction.invoke(this.$key), 0L, 2, null);
            }
            {
                this.$mappingFunction = function1;
                this.$key = object;
                super(1);
            }
        }).getDatum();
    }

    @Nullable
    public final ExpiringItem<T> remove(K key) {
        return this.cache.remove(key);
    }

    public final void removeAll(@NotNull Iterable<? extends K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable<K> $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        Iterator<K> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            K element$iv;
            K it = element$iv = iterator.next();
            boolean bl = false;
            this.cache.remove(it);
        }
    }

    public final void clear() {
        this.cache.clear();
    }

    @NotNull
    public final Duration getTtl() {
        return this.ttl;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ConcurrentExpiringLRUCache(@NotNull Duration ttl, int capacity) {
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        this.ttl = ttl;
        this.capacity = capacity;
        this.cache = new ConcurrentLRUCache(this.ttl.getSeconds(), this.capacity);
    }

    public /* synthetic */ ConcurrentExpiringLRUCache(Duration duration, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Duration duration2 = CACHE_TTL;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"CACHE_TTL");
            duration = duration2;
        }
        if ((n2 & 2) != 0) {
            n = 200;
        }
        this(duration, n);
    }

    public ConcurrentExpiringLRUCache() {
        this(null, 0, 3, null);
    }

    static {
        Companion = new Companion(null);
        CACHE_TTL = Duration.ofMinutes(5L);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache$Companion;", "", "()V", "CACHE_CAPACITY", "", "CACHE_TTL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCACHE_TTL", "()Ljava/time/Duration;", "pulsar-common"})
    public static final class Companion {
        public final Duration getCACHE_TTL() {
            return CACHE_TTL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

