/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.concurrent;

import ai.platon.pulsar.common.concurrent.ConcurrencyKt;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 (2\u00020\u0001:\u0001(B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020#2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020#2\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001eH&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0011\u00a8\u0006)"}, d2={"Lai/platon/pulsar/common/concurrent/ScheduledMonitor;", "Ljava/lang/AutoCloseable;", "initialDelay", "Ljava/time/Duration;", "watchInterval", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "autoClose", "", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;Z)V", "getAutoClose", "()Z", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getInitialDelay", "()Ljava/time/Duration;", "setInitialDelay", "(Ljava/time/Duration;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "getScheduledFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setScheduledFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "getWatchInterval", "setWatchInterval", "close", "", "start", "period", "runnable", "Lkotlin/Function0;", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Ljava/lang/Runnable;", "watch", "Companion", "pulsar-common"})
public abstract class ScheduledMonitor
implements AutoCloseable {
    private final Logger log;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private Duration initialDelay;
    @NotNull
    private Duration watchInterval;
    @NotNull
    private final ScheduledExecutorService executor;
    private final boolean autoClose;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected final void setScheduledFuture(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, new Runnable(runnable){
            final /* synthetic */ Function0 $runnable;

            public final void run() {
                this.$runnable.invoke();
            }
            {
                this.$runnable = function0;
            }
        });
    }

    public final void start(@NotNull Duration initialDelay, @NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this.start(initialDelay.getSeconds(), period.getSeconds(), TimeUnit.SECONDS, new Runnable(this){
            final /* synthetic */ ScheduledMonitor this$0;

            public final void run() {
                this.this$0.watch();
            }
            {
                this.this$0 = scheduledMonitor;
            }
        });
    }

    public void start(long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(period, period, unit);
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        boolean bl = this.scheduledFuture == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Scheduled monitor is already started | " + this.getClass().getSimpleName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.scheduledFuture = this.executor.scheduleAtFixedRate(runnable, initialDelay, period, unit);
        this.log.info("Scheduled monitor is started | {}", (Object)this.getClass().getSimpleName());
    }

    public synchronized void start(long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.start(initialDelay, period, unit, new Runnable(this){
            final /* synthetic */ ScheduledMonitor this$0;

            public final void run() {
                try {
                    this.this$0.watch();
                }
                catch (Throwable ex) {
                    ScheduledMonitor.access$getLog$p(this.this$0).error("Exception thrown from {}#report. Exception was suppressed.", (Object)this.this$0.getClass().getSimpleName(), (Object)ex);
                }
            }
            {
                this.this$0 = scheduledMonitor;
            }
        });
    }

    public final void start() {
        this.start(this.initialDelay, this.watchInterval, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScheduledMonitor this$0;

            public final void invoke() {
                this.this$0.watch();
            }
            {
                this.this$0 = scheduledMonitor;
                super(0);
            }
        }));
    }

    public abstract void watch();

    @Override
    public void close() {
        if (this.autoClose) {
            ConcurrencyKt.stopExecution(this.executor, (Future)this.scheduledFuture, true);
            this.log.info("Scheduled monitor is closed | " + this);
        }
    }

    @NotNull
    public final Duration getInitialDelay() {
        return this.initialDelay;
    }

    public final void setInitialDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.initialDelay = duration;
    }

    @NotNull
    public final Duration getWatchInterval() {
        return this.watchInterval;
    }

    public final void setWatchInterval(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.watchInterval = duration;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public final boolean getAutoClose() {
        return this.autoClose;
    }

    public ScheduledMonitor(@NotNull Duration initialDelay, @NotNull Duration watchInterval, @NotNull ScheduledExecutorService executor, boolean autoClose) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)watchInterval, (String)"watchInterval");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.initialDelay = initialDelay;
        this.watchInterval = watchInterval;
        this.executor = executor;
        this.autoClose = autoClose;
        this.log = LoggerFactory.getLogger(ScheduledMonitor.class);
    }

    public /* synthetic */ ScheduledMonitor(Duration duration, Duration duration2, ScheduledExecutorService scheduledExecutorService, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Duration duration3 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"Duration.ofMinutes(5)");
            duration = duration3;
        }
        if ((n & 2) != 0) {
            Duration duration4 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"Duration.ofSeconds(30)");
            duration2 = duration4;
        }
        if ((n & 4) != 0) {
            scheduledExecutorService = ScheduledMonitor.Companion.createDefaultExecutor();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(duration, duration2, scheduledExecutorService, bl);
    }

    public ScheduledMonitor() {
        this(null, null, null, false, 15, null);
    }

    public static final /* synthetic */ Logger access$getLog$p(ScheduledMonitor $this) {
        return $this.log;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/common/concurrent/ScheduledMonitor$Companion;", "", "()V", "createDefaultExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "pulsar-common"})
    public static final class Companion {
        private final ScheduledExecutorService createDefaultExecutor() {
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("em-%d").build();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(factory);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"Executors.newSingleThrea\u2026cheduledExecutor(factory)");
            return scheduledExecutorService;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

