/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.config;

import ai.platon.pulsar.common.SParser;
import ai.platon.pulsar.common.config.KConfiguration;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertyResolverExtensionsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 [2\u00020\u0001:\u0001[B+\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0002J\u0019\u0010#\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0096\u0002J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0005J\u001e\u0010&\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u001d\u001a\u00020\u00032\n\u0010$\u001a\u0006\u0012\u0002\b\u00030'J:\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(0'\"\u0004\b\u0000\u0010(2\u0006\u0010\u001d\u001a\u00020\u00032\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u0002H(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0'J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u0003J\u0016\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u000202J-\u00103\u001a\u0002H4\"\u0010\b\u0000\u00104*\n\u0012\u0004\u0012\u0002H4\u0018\u0001052\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u0002H4\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u0002082\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u000208J\u0016\u00109\u001a\u00020:2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020:J\u0016\u0010;\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020<J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u001d\u001a\u00020\u0003J\u001a\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030@2\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010A\u001a\u00020B2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020BJ\u0016\u0010C\u001a\u00020D2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010E\u001a\u00020DJ\u0010\u0010F\u001a\u0004\u0018\u00010D2\u0006\u0010\u001d\u001a\u00020\u0003J\"\u0010G\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010H\u001a\u0004\u0018\u00010\u00162\u0006\u0010,\u001a\u00020\u0003J\u0014\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00030J2\u0006\u0010\u001d\u001a\u00020\u0003J\u0019\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\u0002\u0010MJ-\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010\u001d\u001a\u00020\u00032\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030L\"\u00020\u0003\u00a2\u0006\u0002\u0010NJ\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00030J2\u0006\u0010\u001d\u001a\u00020\u0003J\u0019\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\u0002\u0010MJ-\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00030L2\u0006\u0010\u001d\u001a\u00020\u00032\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030L\"\u00020\u0003\u00a2\u0006\u0002\u0010NJ\u0016\u0010Q\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020<J\u0016\u0010R\u001a\u00020B2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010$\u001a\u00020BJ&\u0010S\u001a\u00020T2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\u0010\u0010V\u001a\u00020W2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0006\u0010X\u001a\u00020<J\b\u0010Y\u001a\u00020\u0003H\u0016J\u0006\u0010Z\u001a\u00020\nR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001c\"\u0004\b\u001f\u0010 R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lai/platon/pulsar/common/config/AbstractConfiguration;", "", "profile", "", "loadDefaults", "", "resources", "", "(Ljava/lang/String;ZLjava/lang/Iterable;)V", "conf", "Lai/platon/pulsar/common/config/KConfiguration;", "(Lai/platon/pulsar/common/config/KConfiguration;)V", "getConf", "()Lai/platon/pulsar/common/config/KConfiguration;", "environment", "Lorg/springframework/core/env/Environment;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "setEnvironment", "(Lorg/springframework/core/env/Environment;)V", "fullPathResources", "Ljava/util/LinkedHashSet;", "Ljava/net/URL;", "isDistributedFs", "()Z", "isDryRun", "mode", "getMode", "()Ljava/lang/String;", "name", "getName", "setName", "(Ljava/lang/String;)V", "<set-?>", "getProfile", "get", "defaultValue", "getBoolean", "getClass", "Ljava/lang/Class;", "U", "xface", "getConfResourceAsInputStream", "Ljava/io/InputStream;", "resource", "getConfResourceAsReader", "Ljava/io/Reader;", "getDouble", "", "getDuration", "Ljava/time/Duration;", "getEnum", "T", "", "(Ljava/lang/String;Ljava/lang/Enum;)Ljava/lang/Enum;", "getFloat", "", "getInstant", "Ljava/time/Instant;", "getInt", "", "getInts", "", "getKvs", "", "getLong", "", "getPath", "Ljava/nio/file/Path;", "elsePath", "getPathOrNull", "getRealResource", "getResource", "getStringCollection", "", "getStrings", "", "(Ljava/lang/String;)[Ljava/lang/String;", "(Ljava/lang/String;[Ljava/lang/String;)[Ljava/lang/String;", "getTrimmedStringCollection", "getTrimmedStrings", "getUint", "getUlong", "loadConfResources", "", "extraResources", "p", "Lai/platon/pulsar/common/SParser;", "size", "toString", "unbox", "Companion", "pulsar-common"})
public abstract class AbstractConfiguration {
    private final LinkedHashSet<String> resources;
    @NotNull
    private String name;
    @NotNull
    private String profile;
    @NotNull
    private final KConfiguration conf;
    @Nullable
    private Environment environment;
    private final LinkedHashSet<URL> fullPathResources;
    private static final Logger LOG;
    @NotNull
    public static final String APPLICATION_SPECIFIED_RESOURCES = "pulsar-default.xml,pulsar-site.xml,pulsar-task.xml";
    @NotNull
    private static final LinkedHashSet<String> DEFAULT_RESOURCES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getMode() {
        return this.isDistributedFs() ? "cluster" : "local";
    }

    @NotNull
    protected final KConfiguration getConf() {
        return this.conf;
    }

    @Nullable
    public final Environment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@Nullable Environment environment) {
        this.environment = environment;
    }

    private final void loadConfResources(String profile, boolean loadDefaults, Iterable<String> extraResources) {
        Object it;
        Iterable $this$forEach$iv;
        String specifiedResources;
        CollectionsKt.toCollection(extraResources, (Collection)this.resources);
        this.profile = profile;
        if (!loadDefaults) {
            return;
        }
        CharSequence charSequence = profile;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.conf.set("legacy.config.profile", profile);
        }
        String string = specifiedResources = System.getProperty("system.property.specified.resources", APPLICATION_SPECIFIED_RESOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"specifiedResources");
        Object object = string;
        String string2 = ",";
        int n = 0;
        string2 = new Regex(string2);
        n = 0;
        boolean bl2 = false;
        object = string2.split((CharSequence)object, n);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            this.resources.add((String)it);
        }
        for (String name : this.resources) {
            String string3 = this.getMode();
            String string4 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
            URL realResource = this.getRealResource(profile, string3, string4);
            if (realResource != null) {
                this.fullPathResources.add(realResource);
                continue;
            }
            LOG.info("Resource not find: " + name);
        }
        $this$forEach$iv = this.fullPathResources;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (URL)element$iv;
            boolean bl4 = false;
            this.conf.addResource((URL)it);
        }
        LOG.info(this.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final URL getRealResource(String profile, String mode, String name) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv22;
        void $this$map$iv;
        String prefix = "config/legacy";
        String suffix = mode + '/' + name;
        String[] stringArray = new String[]{prefix + '/' + suffix, prefix + '/' + profile + '/' + suffix, prefix + '/' + name, prefix + '/' + profile + '/' + name, name};
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var12_14 = $this$mapTo$iv$iv22;
        int n = ((void)var12_14).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_20 = item$iv$iv = var12_14[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = StringsKt.replace$default((String)it, (String)"//", (String)"/", (boolean)false, (int)4, null);
            collection.add(string);
        }
        Iterable $this$sortedByDescending$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedByDescending = false;
        boolean $this$mapTo$iv$iv22 = false;
        List searchPaths = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                String it = (String)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.length());
                it = (String)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.length();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        Iterable $this$mapNotNull$iv = searchPaths;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            URL uRL;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.getResource(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            URL it$iv$iv = uRL;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        URL resource = (URL)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        if (resource != null) {
            LOG.info("Find legacy resource: " + resource);
        }
        return resource;
    }

    public final boolean isDryRun() {
        return this.getBoolean("pulsar.dry.run", false);
    }

    public final boolean isDistributedFs() {
        String fsName = this.get("fs.defaultFS");
        return fsName != null && StringsKt.startsWith$default((String)fsName, (String)"hdfs", (boolean)false, (int)2, null);
    }

    @NotNull
    public final KConfiguration unbox() {
        return this.conf;
    }

    public final int size() {
        return this.conf.size();
    }

    @Nullable
    public String get(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = System.getProperty(name);
        if (string2 == null) {
            Environment environment = this.environment;
            string2 = string = environment != null ? PropertyResolverExtensionsKt.get((PropertyResolver)((PropertyResolver)environment), (String)name) : null;
        }
        if (string2 == null) {
            string = this.conf.get(name);
        }
        return string;
    }

    @NotNull
    public String get(@NotNull String name, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public final int getInt(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getInt(defaultValue);
    }

    @NotNull
    public final int[] getInts(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int[] nArray = this.p(name).getInts();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"p(name).ints");
        return nArray;
    }

    public final long getLong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getLong(defaultValue);
    }

    public final float getFloat(@NotNull String name, float defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getFloat(defaultValue);
    }

    public final double getDouble(@NotNull String name, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getDouble(defaultValue);
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getBoolean(defaultValue);
    }

    public final <T extends Enum<T>> T getEnum(@NotNull String name, T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getEnum(defaultValue);
    }

    @NotNull
    public final Collection<String> getStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection<String> collection = this.p(name).getStringCollection();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"p(name).stringCollection");
        return collection;
    }

    @NotNull
    public final String[] getStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.p(name).getStrings();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @NotNull
    public final String[] getStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String[] stringArray = this.p(name).getStrings(Arrays.copyOf(defaultValue, defaultValue.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"p(name).getStrings(*defaultValue)");
        return stringArray;
    }

    @NotNull
    public final Collection<String> getTrimmedStringCollection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection<String> collection = this.p(name).getTrimmedStringCollection();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"p(name).trimmedStringCollection");
        return collection;
    }

    @NotNull
    public final String[] getTrimmedStrings(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = this.p(name).getTrimmedStrings();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"p(name).trimmedStrings");
        return stringArray;
    }

    @NotNull
    public final String[] getTrimmedStrings(@NotNull String name, String ... defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String[] stringArray = this.p(name).getTrimmedStrings(Arrays.copyOf(defaultValue, defaultValue.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"p(name).getTrimmedStrings(*defaultValue)");
        return stringArray;
    }

    public final int getUint(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int value = this.getInt(name, defaultValue);
        if (value < 0) {
            value = defaultValue;
        }
        return value;
    }

    public final long getUlong(@NotNull String name, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long value = this.getLong(name, defaultValue);
        if (value < 0L) {
            value = defaultValue;
        }
        return value;
    }

    @NotNull
    public final Duration getDuration(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Duration duration = this.p(name).getDuration();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"p(name).duration");
        return duration;
    }

    @NotNull
    public final Duration getDuration(@NotNull String name, @NotNull Duration defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Duration duration = this.p(name).getDuration(defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"p(name).getDuration(defaultValue)");
        return duration;
    }

    @NotNull
    public final Instant getInstant(@NotNull String name, @NotNull Instant defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Instant instant = this.p(name).getInstant(defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"p(name).getInstant(defaultValue)");
        return instant;
    }

    @NotNull
    public final Path getPath(@NotNull String name, @NotNull Path elsePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)elsePath, (String)"elsePath");
        Path path = this.p(name).getPath(elsePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"p(name).getPath(elsePath)");
        return path;
    }

    @Nullable
    public final Path getPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.p(name).getPathOrNull();
    }

    @NotNull
    public final Map<String, String> getKvs(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, String> map = this.p(name).getKvs();
        Intrinsics.checkNotNullExpressionValue(map, (String)"p(name).kvs");
        return map;
    }

    @NotNull
    public final InputStream getConfResourceAsInputStream(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        SParser sParser = SParser.wrap(resource);
        Intrinsics.checkNotNullExpressionValue((Object)sParser, (String)"SParser.wrap(resource)");
        InputStream inputStream = sParser.getResourceAsInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"SParser.wrap(resource).resourceAsInputStream");
        return inputStream;
    }

    @NotNull
    public final Reader getConfResourceAsReader(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        SParser sParser = SParser.wrap(resource);
        Intrinsics.checkNotNullExpressionValue((Object)sParser, (String)"SParser.wrap(resource)");
        Reader reader = sParser.getResourceAsReader();
        Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"SParser.wrap(resource).resourceAsReader");
        return reader;
    }

    @Nullable
    public final URL getResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        SParser sParser = SParser.wrap(resource);
        Intrinsics.checkNotNullExpressionValue((Object)sParser, (String)"SParser.wrap(resource)");
        return sParser.getResource();
    }

    @NotNull
    public final Class<?> getClass(@NotNull String name, @NotNull Class<?> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Class<?> clazz = this.p(name).getClass(defaultValue);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"p(name).getClass(defaultValue)");
        return clazz;
    }

    @NotNull
    public final <U> Class<? extends U> getClass(@NotNull String name, @NotNull Class<? extends U> defaultValue, @NotNull Class<U> xface) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(xface, (String)"xface");
        Class<? extends U> clazz = this.p(name).getClass(defaultValue, xface);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"p(name).getClass(defaultValue, xface)");
        return clazz;
    }

    private final SParser p(String name) {
        return new SParser(this.get(name));
    }

    @NotNull
    public String toString() {
        return "profile: <" + this.profile + "> | " + this.conf;
    }

    public AbstractConfiguration(@NotNull String profile, boolean loadDefaults, @NotNull Iterable<String> resources) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.fullPathResources = new LinkedHashSet();
        this.conf = new KConfiguration(loadDefaults);
        this.loadConfResources(profile, loadDefaults, resources);
    }

    public /* synthetic */ AbstractConfiguration(String string, boolean bl, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = System.getProperty("legacy.config.profile", "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(Capab\u2026EGACY_CONFIG_PROFILE, \"\")");
            string = string2;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            iterable = DEFAULT_RESOURCES;
        }
        this(string, bl, iterable);
    }

    public AbstractConfiguration(@NotNull KConfiguration conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.resources = new LinkedHashSet();
        this.name = "Configuration#" + this.hashCode();
        this.profile = "";
        this.fullPathResources = new LinkedHashSet();
        this.conf = new KConfiguration(conf);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(AbstractConfiguration.class);
        DEFAULT_RESOURCES = new LinkedHashSet();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lai/platon/pulsar/common/config/AbstractConfiguration$Companion;", "", "()V", "APPLICATION_SPECIFIED_RESOURCES", "", "DEFAULT_RESOURCES", "Ljava/util/LinkedHashSet;", "getDEFAULT_RESOURCES", "()Ljava/util/LinkedHashSet;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-common"})
    public static final class Companion {
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final LinkedHashSet<String> getDEFAULT_RESOURCES() {
            return DEFAULT_RESOURCES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

