/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.math;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a8\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a8\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a8\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"getOutlierInnerFence", "Lkotlin/Pair;", "", "values", "", "p1", "p2", "smooth", "ds", "Lorg/apache/commons/math3/stat/descriptive/DescriptiveStatistics;", "getOutlierOuterFence", "pulsar-common"})
public final class MathsKt {
    @NotNull
    public static final Pair<Double, Double> getOutlierInnerFence(@NotNull double[] values, double p1, double p2, double smooth) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DescriptiveStatistics ds = new DescriptiveStatistics(values);
        return MathsKt.getOutlierInnerFence(ds, p1, p2, smooth);
    }

    public static /* synthetic */ Pair getOutlierInnerFence$default(double[] dArray, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d = 25.0;
        }
        if ((n & 4) != 0) {
            d2 = 75.0;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MathsKt.getOutlierInnerFence(dArray, d, d2, d3);
    }

    @NotNull
    public static final Pair<Double, Double> getOutlierInnerFence(@NotNull DescriptiveStatistics ds, double p1, double p2, double smooth) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        double q1 = ds.getPercentile(p1);
        double q3 = ds.getPercentile(p2);
        double iqr = q3 - q1;
        double f1 = q1 - 1.5 * iqr + smooth;
        double f2 = q3 + 1.5 * iqr + smooth;
        return TuplesKt.to((Object)f1, (Object)f2);
    }

    public static /* synthetic */ Pair getOutlierInnerFence$default(DescriptiveStatistics descriptiveStatistics, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d = 25.0;
        }
        if ((n & 4) != 0) {
            d2 = 75.0;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MathsKt.getOutlierInnerFence(descriptiveStatistics, d, d2, d3);
    }

    @NotNull
    public static final Pair<Double, Double> getOutlierOuterFence(@NotNull double[] values, double p1, double p2, double smooth) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DescriptiveStatistics ds = new DescriptiveStatistics(values);
        return MathsKt.getOutlierOuterFence(ds, p1, p2, smooth);
    }

    public static /* synthetic */ Pair getOutlierOuterFence$default(double[] dArray, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d = 25.0;
        }
        if ((n & 4) != 0) {
            d2 = 75.0;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MathsKt.getOutlierOuterFence(dArray, d, d2, d3);
    }

    @NotNull
    public static final Pair<Double, Double> getOutlierOuterFence(@NotNull DescriptiveStatistics ds, double p1, double p2, double smooth) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        double q1 = ds.getPercentile(p1);
        double q3 = ds.getPercentile(p2);
        double iqr = q3 - q1;
        double f1 = q1 - (double)3 * iqr + smooth;
        double f2 = q3 + (double)3 * iqr + smooth;
        return TuplesKt.to((Object)f1, (Object)f2);
    }

    public static /* synthetic */ Pair getOutlierOuterFence$default(DescriptiveStatistics descriptiveStatistics, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d = 25.0;
        }
        if ((n & 4) != 0) {
            d2 = 75.0;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MathsKt.getOutlierOuterFence(descriptiveStatistics, d, d2, d3);
    }
}

