/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.measure;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/common/measure/ByteUnitConverter;", "", "()V", "convert", "", "bytes", "", "unit", "", "", "toBytes", "value", "pulsar-common"})
public final class ByteUnitConverter {
    @NotNull
    public static final ByteUnitConverter INSTANCE;

    public final double convert(int bytes, @NotNull String unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return this.convert((long)bytes, unit);
    }

    public final double convert(long bytes, @NotNull String unit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (unit.charAt(0)) {
            case 'B': {
                d = bytes;
                break;
            }
            case 'K': {
                d = (double)bytes / 1024.0;
                break;
            }
            case 'M': {
                d = (double)bytes / 1024.0 / 1024.0;
                break;
            }
            case 'G': {
                d = (double)bytes / 1024.0 / 1024.0 / 1024.0;
                break;
            }
            case 'T': {
                d = (double)bytes / 1024.0 / 1024.0 / 1024.0 / 1024.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public final long toBytes(long value, @NotNull String unit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (unit.charAt(0)) {
            case 'B': {
                l = value;
                break;
            }
            case 'K': {
                l = value * (long)1024;
                break;
            }
            case 'M': {
                l = value * (long)1024 * (long)1024;
                break;
            }
            case 'G': {
                l = value * (long)1024 * (long)1024 * (long)1024;
                break;
            }
            case 'T': {
                l = value * (long)1024 * (long)1024 * (long)1024 * (long)1024;
                break;
            }
            default: {
                l = 0L;
            }
        }
        return l;
    }

    private ByteUnitConverter() {
    }

    static {
        ByteUnitConverter byteUnitConverter;
        INSTANCE = byteUnitConverter = new ByteUnitConverter();
    }
}

