/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.sql;

import ai.platon.pulsar.common.sql.ResultSetFormatter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 -2\u00020\u0001:\u0001-B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020#H\u0002J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0015H\u0002J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/platon/pulsar/common/sql/ResultSetFormatter;", "", "rs", "Ljava/sql/ResultSet;", "asList", "", "withHeader", "textOnly", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/sql/ResultSet;ZZZLjava/lang/StringBuilder;)V", "getBuffer", "()Ljava/lang/StringBuilder;", "columns", "", "", "meta", "Ljava/sql/ResultSetMetaData;", "kotlin.jvm.PlatformType", "numColumns", "", "<set-?>", "numFields", "getNumFields", "()I", "numNonBlankFields", "getNumNonBlankFields", "numNonNullFields", "getNumNonNullFields", "numRows", "getNumRows", "rows", "Ljava/util/ArrayList;", "format", "", "formatColumn", "columnIndex", "formatCurrentRow", "formatResultAsList", "formatResultAsTable", "formatRows", "getFloatColumnFormat", "overflow", "toString", "Companion", "pulsar-common"})
public final class ResultSetFormatter {
    private final ResultSetMetaData meta;
    private final int numColumns;
    private int numRows;
    private int numNonBlankFields;
    private int numNonNullFields;
    private int numFields;
    private final ArrayList<List<String>> rows;
    private final List<String> columns;
    private final ResultSet rs;
    private final boolean asList;
    private final boolean withHeader;
    private final boolean textOnly;
    @NotNull
    private final StringBuilder buffer;
    private static int MAX_ROW_BUFFER;
    private static int MAX_COLUMN_LENGTH;
    private static char BOX_VERTICAL;
    @NotNull
    public static final Companion Companion;

    public final int getNumRows() {
        return this.numRows;
    }

    public final int getNumNonBlankFields() {
        return this.numNonBlankFields;
    }

    public final int getNumNonNullFields() {
        return this.numNonNullFields;
    }

    public final int getNumFields() {
        return this.numFields;
    }

    public final void format() {
        try {
            this.rs.beforeFirst();
            if (this.asList) {
                this.formatResultAsList();
            } else {
                this.formatResultAsTable();
            }
        }
        catch (SQLException e) {
            String cfr_ignored_0 = "(Exception)" + e.getMessage();
        }
    }

    @NotNull
    public String toString() {
        CharSequence charSequence = this.buffer;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.format();
        }
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void formatResultAsTable() throws SQLException {
        if (this.withHeader) {
            this.rows.add(this.columns);
        }
        int i = 0;
        while (this.rs.next()) {
            if (i++ > 0 && this.rows.isEmpty()) {
                this.buffer.setLength(0);
            }
            this.formatCurrentRow();
            int n = this.numRows;
            this.numRows = n + 1;
            if (n <= MAX_ROW_BUFFER) continue;
            this.overflow();
        }
        this.formatRows();
    }

    private final void overflow() {
        this.formatRows();
        this.buffer.append("\n");
        this.rows.clear();
    }

    private final void formatResultAsList() throws SQLException {
        int i;
        int labelLength = 0;
        Object[] columns = new String[this.numColumns];
        int n = 0;
        int n2 = this.numColumns;
        while (n < n2) {
            String string = this.meta.getColumnLabel((int)(i + true));
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            columns[i] = it;
            String label = string;
            labelLength = RangesKt.coerceAtLeast((int)labelLength, (int)label.length());
            ++i;
        }
        while (this.rs.next()) {
            i = this.numRows;
            this.numRows = i + 1;
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, this.numColumns - 1);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i2 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (i2 > 0) {
                    this.buffer.append('\n');
                }
                String th = StringUtils.rightPad((String)Intrinsics.stringPlus((String)columns[i2], (Object)":"), (int)(15 + labelLength));
                String td = this.rs.getString(i2 + 1);
                this.buffer.append(th).append(td);
                ResultSetFormatter resultSetFormatter = this;
                ++resultSetFormatter.numFields;
                int cfr_ignored_0 = resultSetFormatter.numFields;
                if (td == null) continue;
                ResultSetFormatter resultSetFormatter2 = this;
                ++resultSetFormatter2.numNonNullFields;
                int cfr_ignored_1 = resultSetFormatter2.numNonNullFields;
                CharSequence charSequence = td;
                boolean bl4 = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                ResultSetFormatter resultSetFormatter3 = this;
                ++resultSetFormatter3.numNonBlankFields;
                int cfr_ignored_2 = resultSetFormatter3.numNonBlankFields;
            }
            this.buffer.append("\n");
        }
        if (this.numRows == 0) {
            ArraysKt.joinTo$default((Object[])columns, (Appendable)this.buffer, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
            this.buffer.append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void formatCurrentRow() throws SQLException {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(1, this.numColumns);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = StringUtils.abbreviateMiddle((String)this.formatColumn((int)it), (String)"..", (int)MAX_COLUMN_LENGTH);
            collection.add(string);
        }
        List list = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        this.rows.add(it);
    }

    private final String formatColumn(int columnIndex) throws SQLException {
        String string;
        if (this.textOnly) {
            String string2 = this.rs.getString(columnIndex);
            if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null)) == null) {
                string2 = "null";
            }
            return string2;
        }
        switch (this.rs.getMetaData().getColumnType(columnIndex)) {
            case 6: 
            case 7: 
            case 8: {
                String fmt = this.getFloatColumnFormat(columnIndex);
                double value = this.rs.getDouble(columnIndex);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{value};
                boolean bl = false;
                String string3 = String.format(fmt, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                break;
            }
            case 2003: {
                Object array;
                Array array2 = this.rs.getArray(columnIndex);
                Object object = array = array2 != null ? array2.getArray() : null;
                if (array == null) {
                    string = "null";
                    break;
                }
                if (array instanceof Object[]) {
                    string = ArraysKt.joinToString$default((Object[])((Object[])array), null, null, null, (int)0, null, (Function1)formatColumn.1.INSTANCE, (int)31, null);
                    break;
                }
                string = array.toString();
                break;
            }
            default: {
                string = this.rs.getString(columnIndex);
                if (string != null && (string = StringsKt.replace$default((String)string, (String)"\n", (String)"", (boolean)false, (int)4, null)) != null) break;
                string = "null";
            }
        }
        return string;
    }

    private final String getFloatColumnFormat(int columnIndex) {
        int precision = RangesKt.coerceIn((int)this.rs.getMetaData().getPrecision(columnIndex), (int)6, (int)10);
        int scale = RangesKt.coerceIn((int)this.rs.getMetaData().getScale(columnIndex), (int)2, (int)6);
        return "" + '%' + precision + '.' + scale + 'f';
    }

    /*
     * WARNING - void declaration
     */
    private final void formatRows() {
        int[] columnSizes = new int[this.numColumns];
        int n = 0;
        int n2 = this.numColumns;
        while (n < n2) {
            void i;
            int max = 0;
            for (List<String> row : this.rows) {
                max = RangesKt.coerceAtLeast((int)max, (int)row.get((int)i).length());
            }
            if (this.numColumns > 1) {
                max = RangesKt.coerceAtMost((int)MAX_COLUMN_LENGTH, (int)max);
            }
            columnSizes[i] = max;
            ++i;
        }
        Iterable $this$forEach$iv = this.rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List row = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = row;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                boolean bl2;
                void value;
                int n3 = index$iv++;
                boolean bl3 = false;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int j = n3;
                boolean bl4 = false;
                if (j > 0) {
                    this.buffer.append(' ').append(BOX_VERTICAL).append(' ');
                }
                this.buffer.append((String)value);
                if (j < this.numColumns - 1) {
                    int n4 = columnSizes[j] - value.length();
                    bl2 = false;
                    int n5 = 0;
                    n5 = 0;
                    int n6 = n4;
                    while (n5 < n6) {
                        int it = n5++;
                        boolean bl5 = false;
                        this.buffer.append(' ');
                    }
                }
                CharSequence charSequence = (CharSequence)value;
                bl2 = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                ResultSetFormatter resultSetFormatter = this;
                ++resultSetFormatter.numNonBlankFields;
                int cfr_ignored_0 = resultSetFormatter.numNonBlankFields;
            }
            this.buffer.append("\n");
        }
    }

    @NotNull
    public final StringBuilder getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - void declaration
     */
    public ResultSetFormatter(@NotNull ResultSet rs, boolean asList, boolean withHeader, boolean textOnly, @NotNull StringBuilder buffer) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.rs = rs;
        this.asList = asList;
        this.withHeader = withHeader;
        this.textOnly = textOnly;
        this.buffer = buffer;
        ResultSetMetaData resultSetMetaData = this.meta = this.rs.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"meta");
        this.numColumns = resultSetMetaData.getColumnCount();
        this.rows = new ArrayList();
        Iterable iterable = (Iterable)new IntRange(1, this.numColumns);
        ResultSetFormatter resultSetFormatter = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            String string = this.meta.getColumnLabel((int)it);
            if (string == null) {
                string = "";
            }
            String string2 = string;
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        resultSetFormatter.columns = collection;
    }

    public /* synthetic */ ResultSetFormatter(ResultSet resultSet, boolean bl, boolean bl2, boolean bl3, StringBuilder stringBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            stringBuilder = new StringBuilder();
        }
        this(resultSet, bl, bl2, bl3, stringBuilder);
    }

    static {
        Companion = new Companion(null);
        MAX_ROW_BUFFER = 5000;
        MAX_COLUMN_LENGTH = 1000;
        BOX_VERTICAL = (char)124;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lai/platon/pulsar/common/sql/ResultSetFormatter$Companion;", "", "()V", "BOX_VERTICAL", "", "getBOX_VERTICAL", "()C", "setBOX_VERTICAL", "(C)V", "MAX_COLUMN_LENGTH", "", "getMAX_COLUMN_LENGTH", "()I", "setMAX_COLUMN_LENGTH", "(I)V", "MAX_ROW_BUFFER", "getMAX_ROW_BUFFER", "setMAX_ROW_BUFFER", "pulsar-common"})
    public static final class Companion {
        public final int getMAX_ROW_BUFFER() {
            return MAX_ROW_BUFFER;
        }

        public final void setMAX_ROW_BUFFER(int n) {
            MAX_ROW_BUFFER = n;
        }

        public final int getMAX_COLUMN_LENGTH() {
            return MAX_COLUMN_LENGTH;
        }

        public final void setMAX_COLUMN_LENGTH(int n) {
            MAX_COLUMN_LENGTH = n;
        }

        public final char getBOX_VERTICAL() {
            return BOX_VERTICAL;
        }

        public final void setBOX_VERTICAL(char c) {
            BOX_VERTICAL = c;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

