/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.urls.TenantedUrl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0004J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0007J'\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001c\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u001a\u0010 \u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&2\b\b\u0002\u0010!\u001a\u00020\u0017H\u0007J&\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040(2\u0006\u0010)\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u0017H\u0007J'\u0010+\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001c\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010,\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u001c\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00042\n\u00100\u001a\u000601j\u0002`2H\u0002J\u0010\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u00106\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040(2\u0006\u00109\u001a\u00020\u0004H\u0007J\u0014\u0010:\u001a\u0004\u0018\u00010\u00042\b\u0010;\u001a\u0004\u0018\u00010<H\u0007J\u0010\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0007J\u0018\u0010?\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0012\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007\u00a8\u0006A"}, d2={"Lai/platon/pulsar/common/urls/Urls;", "", "()V", "decodeKeyLowerBound", "", "startKey", "decodeKeyUpperBound", "endKey", "fixPureQueryTargets", "Ljava/net/URL;", "base", "targetUrl", "getEndKey", "tenantId", "", "unreversedUrl", "getReversedHost", "reversedUrl", "getStartKey", "getURLOrNull", "url", "getUrlWithoutParameters", "isInternal", "", "isNotInternal", "isValidUrl", "keepQueryParameters", "parameterNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "mergeUrlArgs", "args", "normalize", "ignoreQuery", "normalizeOrNull", "normalizeUrls", "", "urls", "", "normalizedUrlAndKey", "Lkotlin/Pair;", "originalUrl", "norm", "removeQueryParameters", "resolveURL", "reverseAppendSplits", "", "string", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "reverseHost", "hostName", "reverseUrl", "reverseUrlOrEmpty", "reverseUrlOrNull", "splitUrlArgs", "configuredUrl", "toString", "utf8", "", "unreverseHost", "reversedHostName", "unreverseUrl", "unreverseUrlOrNull", "pulsar-common"})
public final class Urls {
    @NotNull
    public static final Urls INSTANCE;

    public final boolean isInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http://internal.pulsar.platon.ai", (boolean)false, (int)2, null);
    }

    public final boolean isNotInternal(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return !this.isInternal(url);
    }

    @JvmStatic
    @Nullable
    public static final URL getURLOrNull(@Nullable String url) {
        Object object;
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            URL uRL = new URL(url);
            boolean bl5 = false;
            object = Result.constructor-impl((Object)uRL);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl7 = false;
        return (URL)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    @JvmStatic
    public static final boolean isValidUrl(@Nullable String url) {
        return Urls.getURLOrNull(url) != null;
    }

    @JvmStatic
    @NotNull
    public static final String normalize(@NotNull String url, boolean ignoreQuery) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object u = (String)Urls.splitUrlArgs(url).getFirst();
        Object object = Urls.getURLOrNull((String)u);
        if (object == null || (object = ((URL)object).toString()) == null) {
            return "";
        }
        u = object;
        u = StringsKt.substringBefore$default((String)u, (String)"#", null, (int)2, null);
        if (ignoreQuery) {
            u = Urls.getUrlWithoutParameters((String)u);
        }
        return u;
    }

    public static /* synthetic */ String normalize$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Urls.normalize(string, bl);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeOrNull(@NotNull String url, boolean ignoreQuery) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = Urls.normalize(url, ignoreQuery);
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    public static /* synthetic */ String normalizeOrNull$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Urls.normalizeOrNull(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> normalizeUrls(@NotNull Iterable<String> urls, boolean ignoreQuery) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable<String> $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable<String> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string2 = Urls.normalize(it, ignoreQuery);
            boolean bl3 = false;
            boolean bl4 = false;
            String it2 = string2;
            boolean bl5 = false;
            CharSequence charSequence = it2;
            boolean bl6 = false;
            if ((!StringsKt.isBlank((CharSequence)charSequence) ? string2 : null) == null) continue;
            string = string;
            boolean bl7 = false;
            boolean bl8 = false;
            String it$iv$iv = string;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List normalizeUrls$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Urls.normalizeUrls(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list = uriBuilder.getQueryParams();
        boolean bl = false;
        boolean bl2 = false;
        List list2 = list;
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl3 = false;
        $this$apply.removeIf((Predicate)new Predicate<NameValuePair>(parameterNames){
            final /* synthetic */ String[] $parameterNames$inlined;
            {
                this.$parameterNames$inlined = stringArray;
            }

            public final boolean test(NameValuePair it) {
                NameValuePair nameValuePair = it;
                Intrinsics.checkNotNullExpressionValue((Object)nameValuePair, (String)"it");
                return ArraysKt.contains((Object[])this.$parameterNames$inlined, (Object)nameValuePair.getName());
            }
        });
        Unit unit = Unit.INSTANCE;
        uRIBuilder.setParameters(list);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String keepQueryParameters(@NotNull String url, String ... parameterNames) throws URISyntaxException {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)parameterNames, (String)"parameterNames");
        URIBuilder uriBuilder = new URIBuilder(url);
        List list = uriBuilder.getQueryParams();
        boolean bl = false;
        boolean bl2 = false;
        List list2 = list;
        URIBuilder uRIBuilder = uriBuilder;
        boolean bl3 = false;
        $this$apply.removeIf((Predicate)new Predicate<NameValuePair>(parameterNames){
            final /* synthetic */ String[] $parameterNames$inlined;
            {
                this.$parameterNames$inlined = stringArray;
            }

            public final boolean test(NameValuePair it) {
                NameValuePair nameValuePair = it;
                Intrinsics.checkNotNullExpressionValue((Object)nameValuePair, (String)"it");
                return !ArraysKt.contains((Object[])this.$parameterNames$inlined, (Object)nameValuePair.getName());
            }
        });
        Unit unit = Unit.INSTANCE;
        uRIBuilder.setParameters(list);
        String string = uriBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final URL resolveURL(@NotNull URL base, @NotNull String targetUrl) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
        String string = targetUrl;
        boolean bl = false;
        String target = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null) ? INSTANCE.fixPureQueryTargets(base, target) : new URL(base, target);
    }

    private final URL fixPureQueryTargets(URL base, String targetUrl) {
        String string = targetUrl;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String target = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            return new URL(base, target);
        }
        String basePath = base.getPath();
        String baseRightMost = "";
        String string3 = basePath;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"basePath");
        int baseRightMostIdx = StringsKt.lastIndexOf$default((CharSequence)string3, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (baseRightMostIdx != -1) {
            String string4 = basePath;
            int n = baseRightMostIdx + 1;
            boolean bl2 = false;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            baseRightMost = string5;
        }
        if (StringsKt.startsWith$default((String)target, (String)"?", (boolean)false, (int)2, null)) {
            target = baseRightMost + target;
        }
        return new URL(base, target);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<String, String> splitUrlArgs(@NotNull String configuredUrl) {
        int n;
        int n2;
        String url;
        int n3;
        block7: {
            Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
            CharSequence charSequence = configuredUrl;
            boolean bl = false;
            charSequence = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            String string = "[\\r\\n\\t]";
            boolean bl2 = false;
            string = new Regex(string);
            String string2 = "";
            n3 = 0;
            url = string.replace(charSequence, string2);
            CharSequence $this$indexOfFirst$iv = url;
            boolean $i$f$indexOfFirst = false;
            n3 = 0;
            n2 = $this$indexOfFirst$iv.length();
            while (n3 < n2) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl3 = false;
                if (CharsKt.isWhitespace((char)it)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = -1;
        }
        int pos = n;
        String args = "";
        if (pos >= 0) {
            String string = url;
            n3 = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            args = string4;
            string = url;
            n3 = 0;
            n2 = 0;
            String string5 = string;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n3, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            url = string6;
        }
        String string = url;
        n3 = 0;
        String string7 = string;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = args;
        n3 = 0;
        String string8 = string;
        if (string8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)string7)).toString(), (Object)((Object)StringsKt.trim((CharSequence)string8)).toString());
    }

    @NotNull
    public final String mergeUrlArgs(@NotNull String url, @Nullable String args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = args;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = url;
            bl = false;
            string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        } else {
            charSequence = url;
            bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(((Object)StringsKt.trim((CharSequence)charSequence)).toString()).append(' ');
            charSequence = args;
            bl = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = stringBuilder.append(((Object)StringsKt.trim((CharSequence)charSequence2)).toString()).toString();
        }
        return string;
    }

    public static /* synthetic */ String mergeUrlArgs$default(Urls urls, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return urls.mergeUrlArgs(string, string2);
    }

    @JvmStatic
    @NotNull
    public static final String getUrlWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(url);
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, String> normalizedUrlAndKey(@NotNull String originalUrl, boolean norm) {
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        String url = norm ? Urls.normalize$default(originalUrl, false, 2, null) : originalUrl;
        String key = Urls.reverseUrlOrEmpty(url);
        return TuplesKt.to((Object)url, (Object)key);
    }

    public static /* synthetic */ Pair normalizedUrlAndKey$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Urls.normalizedUrlAndKey(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Urls.reverseUrl(new URL(url));
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrlOrEmpty(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = Urls.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String reverseUrlOrNull(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            string = Urls.reverseUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.getHost();
        String file = url.getFile();
        String protocol = url.getProtocol();
        int port = url.getPort();
        StringBuilder buf = new StringBuilder();
        String string = host;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        INSTANCE.reverseAppendSplits(string, buf);
        buf.append(':');
        buf.append(protocol);
        if (port != -1) {
            buf.append(':');
            buf.append(port);
        }
        String string2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file");
        CharSequence charSequence = string2;
        boolean bl = false;
        if (charSequence.length() > 0 && '/' != file.charAt(0)) {
            buf.append('/');
        }
        buf.append(file);
        String string3 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"buf.toString()");
        return string3;
    }

    @JvmStatic
    @NotNull
    public static final String reverseUrl(int tenantId, @NotNull String unreversedUrl) {
        Intrinsics.checkNotNullParameter((Object)unreversedUrl, (String)"unreversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(unreversedUrl);
        return TenantedUrl.Companion.combine(tenantId, Urls.reverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        StringBuilder buf = new StringBuilder(reversedUrl.length() + 2);
        int pathBegin = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pathBegin == -1) {
            pathBegin = reversedUrl.length();
        }
        String string = reversedUrl;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sub = string2;
        String[] splits = StringUtils.splitPreserveAllTokens((String)sub, (char)':');
        buf.append(splits[1]);
        buf.append("://");
        String string3 = splits[0];
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"splits[0]");
        INSTANCE.reverseAppendSplits(string3, buf);
        if (splits.length == 3) {
            buf.append(':');
            buf.append(splits[2]);
        }
        String string4 = reversedUrl;
        bl = false;
        String string5 = string4.substring(pathBegin);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        buf.append(string5);
        String string6 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"buf.toString()");
        return string6;
    }

    @JvmStatic
    @Nullable
    public static final String unreverseUrlOrNull(@NotNull String reversedUrl) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        boolean bl = false;
        try {
            object = Result.Companion;
            boolean bl2 = false;
            String string = Urls.unreverseUrl(reversedUrl);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        return (String)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    @JvmStatic
    @NotNull
    public static final String unreverseUrl(int tenantId, @NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        TenantedUrl tenantedUrl = TenantedUrl.Companion.split(reversedUrl);
        return TenantedUrl.Companion.combine(tenantId, Urls.unreverseUrl(tenantedUrl.getUrl()));
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId);
        }
        String startKey = Urls.decodeKeyLowerBound(unreversedUrl);
        return Urls.reverseUrl(tenantId, startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getStartKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String startKey = Urls.decodeKeyLowerBound(unreversedUrl);
        return Urls.reverseUrl(startKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(@Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return null;
        }
        String endKey = Urls.decodeKeyUpperBound(unreversedUrl);
        return Urls.reverseUrl(endKey);
    }

    @JvmStatic
    @Nullable
    public static final String getEndKey(int tenantId, @Nullable String unreversedUrl) {
        if (unreversedUrl == null) {
            return tenantId == 0 ? null : String.valueOf(tenantId + 1);
        }
        String endKey = Urls.decodeKeyUpperBound(unreversedUrl);
        return Urls.reverseUrl(tenantId, endKey);
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyLowerBound(@NotNull String startKey) {
        Intrinsics.checkNotNullParameter((Object)startKey, (String)"startKey");
        String startKey2 = startKey;
        CharSequence charSequence = startKey2;
        String string = "\\\\u0001";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "\u0001";
        boolean bl2 = false;
        startKey2 = string.replace(charSequence, string2);
        charSequence = startKey2;
        string = "\\u0001";
        boolean bl3 = false;
        string = new Regex(string);
        String string3 = "\u0001";
        bl2 = false;
        startKey2 = string.replace(charSequence, string3);
        return startKey2;
    }

    @JvmStatic
    @NotNull
    public static final String decodeKeyUpperBound(@NotNull String endKey) {
        Intrinsics.checkNotNullParameter((Object)endKey, (String)"endKey");
        String endKey2 = endKey;
        CharSequence charSequence = endKey2;
        String string = "\\\\uFFFF";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "\uffff";
        boolean bl2 = false;
        endKey2 = string.replace(charSequence, string2);
        charSequence = endKey2;
        string = "\\uFFFF";
        boolean bl3 = false;
        string = new Regex(string);
        String string3 = "\uffff";
        bl2 = false;
        endKey2 = string.replace(charSequence, string3);
        return endKey2;
    }

    @JvmStatic
    @NotNull
    public static final String getReversedHost(@NotNull String reversedUrl) {
        Intrinsics.checkNotNullParameter((Object)reversedUrl, (String)"reversedUrl");
        String string = reversedUrl;
        int n = 0;
        int n2 = StringsKt.indexOf$default((CharSequence)reversedUrl, (char)':', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void reverseAppendSplits(String string, StringBuilder buf) {
        String[] splits = StringUtils.split((String)string, (char)'.');
        Intrinsics.checkNotNullExpressionValue((Object)splits, (String)"splits");
        String[] stringArray = splits;
        int n = 0;
        String[] stringArray2 = stringArray;
        boolean bl = false;
        if (!(stringArray2.length == 0)) {
            int n2 = splits.length - 1;
            n = 1;
            while (n2 >= n) {
                void i;
                buf.append(splits[i]);
                buf.append('.');
                --i;
            }
            buf.append(splits[0]);
        } else {
            buf.append(string);
        }
    }

    @JvmStatic
    @NotNull
    public static final String reverseHost(@NotNull String hostName) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        StringBuilder buf = new StringBuilder();
        INSTANCE.reverseAppendSplits(hostName, buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String unreverseHost(@NotNull String reversedHostName) {
        Intrinsics.checkNotNullParameter((Object)reversedHostName, (String)"reversedHostName");
        return Urls.reverseHost(reversedHostName);
    }

    @JvmStatic
    @Nullable
    public static final String toString(@Nullable CharSequence utf8) {
        return utf8 == null ? null : Strings.cleanField(((Object)utf8).toString());
    }

    private Urls() {
    }

    static {
        Urls urls;
        INSTANCE = urls = new Urls();
    }
}

