/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.HtmlsKt;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a$\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0003\u00a8\u0006\u0016"}, d2={"DEFAULT_CHARSET_PATTERN", "Ljava/util/regex/Pattern;", "getDEFAULT_CHARSET_PATTERN", "()Ljava/util/regex/Pattern;", "DEFAULT_SUPPORTED_CHARSETS", "", "SYSTEM_AVAILABLE_CHARSETS", "getSYSTEM_AVAILABLE_CHARSETS", "()Ljava/lang/String;", "SYSTEM_AVAILABLE_CHARSET_PATTERN", "getSYSTEM_AVAILABLE_CHARSET_PATTERN", "hasBodyTags", "", "htmlContent", "hasHeadTags", "hasHtmlTags", "isBlankBody", "replaceHTMLCharset", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "charsetPattern", "targetCharset", "pulsar-common"})
public final class HtmlsKt {
    @NotNull
    public static final String DEFAULT_SUPPORTED_CHARSETS = "UTF-8|GB2312|GB18030|GBK|Big5|ISO-8859-1|windows-1250|windows-1251|windows-1252|windows-1253|windows-1254|windows-1257";
    @NotNull
    private static final Pattern DEFAULT_CHARSET_PATTERN;
    @NotNull
    private static final String SYSTEM_AVAILABLE_CHARSETS;
    @NotNull
    private static final Pattern SYSTEM_AVAILABLE_CHARSET_PATTERN;

    @NotNull
    public static final Pattern getDEFAULT_CHARSET_PATTERN() {
        return DEFAULT_CHARSET_PATTERN;
    }

    @NotNull
    public static final String getSYSTEM_AVAILABLE_CHARSETS() {
        return SYSTEM_AVAILABLE_CHARSETS;
    }

    @NotNull
    public static final Pattern getSYSTEM_AVAILABLE_CHARSET_PATTERN() {
        return SYSTEM_AVAILABLE_CHARSET_PATTERN;
    }

    @NotNull
    public static final StringBuilder replaceHTMLCharset(@NotNull String htmlContent, @NotNull Pattern charsetPattern, @NotNull String targetCharset) {
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        Intrinsics.checkNotNullParameter((Object)charsetPattern, (String)"charsetPattern");
        Intrinsics.checkNotNullParameter((Object)targetCharset, (String)"targetCharset");
        int pos = StringsKt.indexOf$default((CharSequence)htmlContent, (String)"</head>", (int)0, (boolean)false, (int)6, null);
        if (pos < 0) {
            return new StringBuilder();
        }
        String head = StringsKt.take((String)htmlContent, (int)pos);
        String string = charsetPattern.matcher(head).replaceAll(targetCharset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"charsetPattern.matcher(h\u2026replaceAll(targetCharset)");
        head = string;
        StringBuilder sb = new StringBuilder(head);
        sb.append(htmlContent, pos, htmlContent.length());
        return sb;
    }

    public static /* synthetic */ StringBuilder replaceHTMLCharset$default(String string, Pattern pattern, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "UTF-8";
        }
        return HtmlsKt.replaceHTMLCharset(string, pattern, string2);
    }

    public static final boolean hasHtmlTags(@NotNull String htmlContent) {
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        return StringsKt.indexOf$default((CharSequence)htmlContent, (String)"<html", (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.lastIndexOf$default((CharSequence)htmlContent, (String)"</html>", (int)0, (boolean)false, (int)6, null) != -1;
    }

    public static final boolean hasHeadTags(@NotNull String htmlContent) {
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        return StringsKt.indexOf$default((CharSequence)htmlContent, (String)"<head", (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.lastIndexOf$default((CharSequence)htmlContent, (String)"</head>", (int)0, (boolean)false, (int)6, null) != -1;
    }

    public static final boolean hasBodyTags(@NotNull String htmlContent) {
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        return StringsKt.indexOf$default((CharSequence)htmlContent, (String)"<body", (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.lastIndexOf$default((CharSequence)htmlContent, (String)"</body>", (int)0, (boolean)false, (int)6, null) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isBlankBody(@NotNull String htmlContent) {
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        String tagStart = "<body";
        String tagEnd = "</body>";
        String h = htmlContent;
        int p = 0;
        p = StringsKt.indexOf$default((CharSequence)h, (String)tagStart, (int)0, (boolean)false, (int)6, null);
        for (p = StringsKt.indexOf$default((CharSequence)h, (String)">", (int)p, (boolean)false, (int)4, null) + 1; CharsKt.isWhitespace((char)h.charAt(p)) && p < h.length(); ++p) {
        }
        if (p + tagEnd.length() > h.length()) {
            return false;
        }
        CharSequence $this$forEachIndexed$iv = tagEnd;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        CharSequence charSequence = $this$forEachIndexed$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void c;
            char item$iv = charSequence.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            boolean bl = false;
            if (c == h.charAt(p + i2)) continue;
            return false;
        }
        return true;
    }

    static {
        Object object = StringsKt.replace$default((String)DEFAULT_SUPPORTED_CHARSETS, (String)"UTF-8\\|?", (String)"", (boolean)false, (int)4, null);
        int n = 2;
        boolean bl = false;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        DEFAULT_CHARSET_PATTERN = pattern;
        object = Charset.availableCharsets().values();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"availableCharsets().values");
        SYSTEM_AVAILABLE_CHARSETS = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"|", null, null, (int)0, null, (Function1)SYSTEM_AVAILABLE_CHARSETS.1.INSTANCE, (int)30, null);
        object = StringsKt.replace$default((String)SYSTEM_AVAILABLE_CHARSETS, (String)"UTF-8\\|?", (String)"", (boolean)false, (int)4, null);
        n = 2;
        bl = false;
        Pattern pattern2 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"java.util.regex.Pattern.compile(this, flags)");
        SYSTEM_AVAILABLE_CHARSET_PATTERN = pattern2;
    }
}

