/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.concurrent.ConcurrentPassiveExpiringSet;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 M2\u00020\u0001:\u0001MB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010?\u001a\u00020@H\u0016J>\u0010A\u001a\b\u0012\u0004\u0012\u0002HC0B\"\u0004\b\u0000\u0010C2\u0006\u0010D\u001a\u00020#2\u0006\u0010E\u001a\u00020\u00162\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0B0GH\u0004J\b\u0010H\u001a\u0004\u0018\u00010IJ\u0006\u0010J\u001a\u00020@J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020I0B2\u0006\u0010L\u001a\u00020\u0016H&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\n \u0017*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010)\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0019\"\u0004\b+\u0010\u001dR\u001a\u0010,\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010\u001dR\u001c\u0010/\u001a\n \u0017*\u0004\u0018\u00010$0$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010 \"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\b\"\u0004\b>\u0010\n\u00a8\u0006N"}, d2={"Lai/platon/pulsar/common/proxy/ProxyLoader;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "banStrategy", "", "getBanStrategy", "()Ljava/lang/String;", "setBanStrategy", "(Ljava/lang/String;)V", "bannedIps", "Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "getBannedIps", "()Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "bannedSegments", "getBannedSegments", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "fileWatchInterval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getFileWatchInterval", "()Ljava/time/Duration;", "ipTimeToBan", "getIpTimeToBan", "setIpTimeToBan", "(Ljava/time/Duration;)V", "isActive", "", "()Z", "lastModifiedTimes", "", "Ljava/nio/file/Path;", "Ljava/time/Instant;", "getLastModifiedTimes", "()Ljava/util/Map;", "log", "Lorg/slf4j/Logger;", "minimumProxyTTL", "getMinimumProxyTTL", "setMinimumProxyTTL", "segmentTimeToBan", "getSegmentTimeToBan", "setSegmentTimeToBan", "startTime", "getStartTime", "()Ljava/time/Instant;", "testIpRate", "", "getTestIpRate", "()D", "setTestIpRate", "(D)V", "testProxyBeforeUse", "getTestProxyBeforeUse", "setTestProxyBeforeUse", "(Z)V", "testUrl", "getTestUrl", "setTestUrl", "close", "", "loadIfModified", "", "O", "path", "expires", "loader", "Lkotlin/Function1;", "loadTestProxyIfAbsent", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "updateBanStrategy", "updateProxies", "reloadInterval", "Companion", "pulsar-common"})
public abstract class ProxyLoader
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log;
    private final Instant startTime;
    @NotNull
    private final AtomicBoolean closed;
    private Duration minimumProxyTTL;
    private boolean testProxyBeforeUse;
    @NotNull
    private String testUrl;
    private final Duration fileWatchInterval;
    @NotNull
    private final Map<Path, Instant> lastModifiedTimes;
    @NotNull
    private String banStrategy;
    @NotNull
    private Duration ipTimeToBan;
    @NotNull
    private Duration segmentTimeToBan;
    @NotNull
    private final ConcurrentPassiveExpiringSet<String> bannedIps;
    @NotNull
    private final ConcurrentPassiveExpiringSet<String> bannedSegments;
    private double testIpRate;
    private static final Path TEST_PROXY_FILE = AppPaths.INSTANCE.getPROXY_BASE_DIR().resolve("test-ip");

    public ProxyLoader(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.log = LoggerFactory.getLogger(ProxyLoader.class);
        this.startTime = Instant.now();
        this.closed = new AtomicBoolean();
        this.minimumProxyTTL = Duration.ofMinutes(5L);
        this.testUrl = "https://www.amazon.com/";
        this.fileWatchInterval = Duration.ofSeconds(30L);
        boolean bl = false;
        this.lastModifiedTimes = new LinkedHashMap();
        this.banStrategy = conf.get("proxy.ban.strategy", "segment");
        Duration duration = Duration.ofHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(1)");
        this.ipTimeToBan = conf.getDuration("proxy.ip.time.to.ban", duration);
        duration = Duration.ofHours(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(2)");
        this.segmentTimeToBan = conf.getDuration("proxy.segment.time.to.ban", duration);
        this.bannedIps = new ConcurrentPassiveExpiringSet(this.ipTimeToBan);
        this.bannedSegments = new ConcurrentPassiveExpiringSet(this.segmentTimeToBan);
        this.testIpRate = 0.3;
    }

    protected final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    public final Duration getMinimumProxyTTL() {
        return this.minimumProxyTTL;
    }

    public final void setMinimumProxyTTL(Duration duration) {
        this.minimumProxyTTL = duration;
    }

    public final boolean getTestProxyBeforeUse() {
        return this.testProxyBeforeUse;
    }

    public final void setTestProxyBeforeUse(boolean bl) {
        this.testProxyBeforeUse = bl;
    }

    @NotNull
    public final String getTestUrl() {
        return this.testUrl;
    }

    public final void setTestUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.testUrl = string;
    }

    public final Duration getFileWatchInterval() {
        return this.fileWatchInterval;
    }

    @NotNull
    public final Map<Path, Instant> getLastModifiedTimes() {
        return this.lastModifiedTimes;
    }

    @NotNull
    public final String getBanStrategy() {
        return this.banStrategy;
    }

    public final void setBanStrategy(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.banStrategy = string;
    }

    @NotNull
    public final Duration getIpTimeToBan() {
        return this.ipTimeToBan;
    }

    public final void setIpTimeToBan(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.ipTimeToBan = duration;
    }

    @NotNull
    public final Duration getSegmentTimeToBan() {
        return this.segmentTimeToBan;
    }

    public final void setSegmentTimeToBan(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.segmentTimeToBan = duration;
    }

    @NotNull
    public final ConcurrentPassiveExpiringSet<String> getBannedIps() {
        return this.bannedIps;
    }

    @NotNull
    public final ConcurrentPassiveExpiringSet<String> getBannedSegments() {
        return this.bannedSegments;
    }

    public final double getTestIpRate() {
        return this.testIpRate;
    }

    public final void setTestIpRate(double d) {
        this.testIpRate = d;
    }

    public final boolean isActive() {
        return !this.closed.get();
    }

    @NotNull
    public abstract List<ProxyEntry> updateProxies(@NotNull Duration var1) throws ProxyException;

    public final synchronized void updateBanStrategy() {
        Path path = AppPaths.INSTANCE.getPROXY_BAN_STRATEGY();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        Duration duration = this.fileWatchInterval;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"fileWatchInterval");
        String string = (String)CollectionsKt.firstOrNull(this.loadIfModified(path, duration, updateBanStrategy.1.INSTANCE));
        if (string != null) {
            Object object = string;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.setBanStrategy((String)it);
            duration = Unit.INSTANCE;
            object = duration;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            this.log.info("Proxy ban strategy: " + (Unit)it);
        }
    }

    @Nullable
    public final ProxyEntry loadTestProxyIfAbsent() {
        Object object;
        Path path;
        Path path2 = TEST_PROXY_FILE;
        boolean bl = false;
        boolean bl2 = false;
        Path it = path2;
        boolean bl3 = false;
        Path path3 = path = this.isActive() && this.getTestIpRate() > 0.0 && ThreadLocalRandom.current().nextDouble() <= this.getTestIpRate() ? path2 : null;
        if (path == null) {
            object = null;
        } else {
            Object object2 = path;
            bl2 = false;
            boolean bl4 = false;
            Path it2 = object2;
            boolean bl5 = false;
            Path path4 = path2 = Files.exists(it2, new LinkOption[0]) ? object2 : null;
            if (path2 == null) {
                object = null;
            } else {
                Comparable<Path> comparable = path2;
                bl4 = false;
                boolean bl6 = false;
                Path it3 = comparable;
                boolean bl7 = false;
                String string = Files.readString(it3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(it)");
                boolean bl8 = false;
                object2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (object2 == null) {
                    object = null;
                } else {
                    Object object3 = object2;
                    bl6 = false;
                    boolean bl9 = false;
                    Object it4 = object3;
                    boolean bl10 = false;
                    comparable = ProxyEntry.Companion.parse((String)it4);
                    if (comparable == null) {
                        object = null;
                    } else {
                        object3 = comparable;
                        bl6 = false;
                        bl9 = false;
                        it4 = object3;
                        boolean bl11 = false;
                        ((ProxyEntry)it4).setTestIp(true);
                        object = object3;
                    }
                }
            }
        }
        return object;
    }

    @NotNull
    protected final <O> List<O> loadIfModified(@NotNull Path path, @NotNull Duration expires, @NotNull Function1<? super Path, ? extends List<? extends O>> loader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        Instant instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
        Instant lastModified = this.lastModifiedTimes.getOrDefault(path, instant);
        Instant modified = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        Duration elapsed = Duration.between(lastModified, modified);
        if (elapsed.compareTo(expires) > 0) {
            Object object = new Object[3];
            object[0] = lastModified;
            Intrinsics.checkNotNullExpressionValue((Object)elapsed, (String)"elapsed");
            object[1] = DateTimesKt.readable(elapsed);
            object[2] = path;
            this.log.info("Reload from file, last modified: {}, elapsed: {} | {}", object);
            object = loader.invoke((Object)path);
            boolean bl = false;
            boolean bl2 = false;
            List it = (List)object;
            boolean bl3 = false;
            Map<Path, Instant> map = this.getLastModifiedTimes();
            Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"modified");
            Instant instant2 = modified;
            boolean bl4 = false;
            map.put(path, instant2);
            return (List)object;
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/common/proxy/ProxyLoader$Companion;", "", "()V", "TEST_PROXY_FILE", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getTEST_PROXY_FILE", "()Ljava/nio/file/Path;", "pulsar-common"})
    public static final class Companion {
        private Companion() {
        }

        public final Path getTEST_PROXY_FILE() {
            return TEST_PROXY_FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

