/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls.sites.amazon;

import ai.platon.pulsar.common.config.AppConstants;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\nJ$\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/common/urls/sites/amazon/AmazonUrls;", "", "()V", "charset", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getCharset", "()Ljava/nio/charset/Charset;", "indexPageUrlContains", "", "", "getIndexPageUrlContains", "()[Ljava/lang/String;", "[Ljava/lang/String;", "findAsin", "url", "findAsinDeprecated", "open", "close", "isAmazon", "", "isAmazonIndexPage", "isAmazonItemPage", "isAmazonReviewPage", "pulsar-common"})
public final class AmazonUrls {
    @NotNull
    public static final AmazonUrls INSTANCE = new AmazonUrls();
    private static final Charset charset = Charset.defaultCharset();
    @NotNull
    private static final String[] indexPageUrlContains;

    private AmazonUrls() {
    }

    public final Charset getCharset() {
        return charset;
    }

    @NotNull
    public final String[] getIndexPageUrlContains() {
        return indexPageUrlContains;
    }

    public final boolean isAmazon(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.contains$default((CharSequence)url, (CharSequence)".amazon.", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAmazonIndexPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!this.isAmazon(url)) return false;
        String[] $this$any$iv = indexPageUrlContains;
        boolean $i$f$any = false;
        String[] stringArray = $this$any$iv;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element$iv;
            String it = element$iv = stringArray[n2];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)it, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final boolean isAmazonItemPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/dp/", (boolean)false, (int)2, null);
    }

    public final boolean isAmazonReviewPage(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.isAmazon(url) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/product-reviews/", (boolean)false, (int)2, null);
    }

    @Nullable
    public final String findAsin(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int pos = StringsKt.indexOf$default((CharSequence)url, (String)"/dp/", (int)0, (boolean)false, (int)6, null) + "/dp/".length();
        if (pos > AppConstants.SHORTEST_VALID_URL_LENGTH) {
            boolean bl;
            int pos2;
            for (pos2 = pos; pos2 < url.length(); ++pos2) {
                char c = url.charAt(pos2);
                bl = false;
                if (!Character.isLetterOrDigit(c)) break;
            }
            if (pos2 <= url.length()) {
                String string = url;
                bl = false;
                String string2 = string.substring(pos, pos2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string2;
            }
        }
        return null;
    }

    @Nullable
    public final String findAsinDeprecated(@NotNull String url, @NotNull String open, @NotNull String close) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)open, (String)"open");
        Intrinsics.checkNotNullParameter((Object)close, (String)"close");
        CharSequence open0 = open;
        CharSequence close0 = close;
        String asin = StringsKt.substringAfterLast((String)url, (String)open0, (String)"");
        if (asin != null) {
            charSequence = asin;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence) && StringsKt.indexOf$default((CharSequence)asin, (char)'/', (int)0, (boolean)false, (int)6, null) == -1) {
                return asin;
            }
        }
        if ((asin = StringUtils.substringBetween((String)url, (String)open0, (String)close0)) != null) {
            return asin;
        }
        close0 = "?ref=";
        asin = StringUtils.substringBetween((String)url, (String)open0, (String)close0);
        if (asin != null) {
            return asin;
        }
        charSequence = URLEncoder.encode(open0, charset);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"encode(open0, charset)");
        open0 = charSequence;
        charSequence = URLEncoder.encode("/ref=", charset);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"encode(\"/ref=\", charset)");
        close0 = charSequence;
        asin = StringUtils.substringBetween((String)url, (String)open0, (String)close0);
        if (asin != null) {
            return asin;
        }
        charSequence = URLEncoder.encode("?ref=", charset);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"encode(\"?ref=\", charset)");
        close0 = charSequence;
        asin = StringUtils.substringBetween((String)url, (String)open0, (String)close0);
        if (asin != null) {
            return asin;
        }
        return asin;
    }

    public static /* synthetic */ String findAsinDeprecated$default(AmazonUrls amazonUrls, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "/dp/";
        }
        if ((n & 4) != 0) {
            string3 = "/ref=";
        }
        return amazonUrls.findAsinDeprecated(string, string2, string3);
    }

    static {
        String[] stringArray = new String[]{"/zgbs/", "/most-wished-for/", "/new-releases/", "/movers-and-shakers/"};
        indexPageUrlContains = stringArray;
    }
}

