/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.DateTimeDetector;
import ai.platon.pulsar.common.LogsKt;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010D\u001a\u0004\u0018\u00010\u00042\b\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020HH\u0007J\u0006\u0010I\u001a\u00020HJ\u000e\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020\u0010J\u0006\u0010K\u001a\u00020LJ\u000e\u0010K\u001a\u00020L2\u0006\u0010J\u001a\u00020\u0010J\u0006\u0010M\u001a\u00020\u0007J\u0006\u0010N\u001a\u00020'J\u001a\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020\u00102\b\b\u0002\u0010P\u001a\u00020\u0010H\u0007J\u000e\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020\u0007J\u0006\u0010Q\u001a\u00020\u0010J\u0006\u0010R\u001a\u00020\u0010J\u000e\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0010J\u0016\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u00102\u0006\u0010S\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020\u00042\u0006\u0010U\u001a\u000201J\u0016\u0010S\u001a\u00020\u00042\u0006\u0010U\u001a\u0002012\u0006\u0010S\u001a\u00020\u0004J\u0016\u0010S\u001a\u00020\u00042\u0006\u0010U\u001a\u00020V2\u0006\u0010S\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0007J\u0016\u0010S\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u0004J\u0010\u0010X\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0010H\u0007J\u000e\u0010X\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0007J\u000e\u0010Y\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u0004J\u0018\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020V2\u0006\u0010]\u001a\u00020HH\u0007J\u0010\u0010^\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0010H\u0007J\u000e\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020`J\u000e\u0010^\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u0007J\b\u0010a\u001a\u00020\u0004H\u0007J\u000e\u0010a\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u0004J\u001a\u0010b\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u00042\b\b\u0002\u0010d\u001a\u00020\u0010H\u0007J\u0012\u0010e\u001a\u0004\u0018\u00010\u00102\u0006\u0010c\u001a\u00020\u0004H\u0007J\u0018\u0010f\u001a\u00020'2\u0006\u0010g\u001a\u00020\u00042\u0006\u0010d\u001a\u00020'H\u0007J\u0018\u0010h\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u0010H\u0007J\u001a\u0010i\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u00042\b\b\u0002\u0010d\u001a\u00020\u0010H\u0007J\u001a\u0010j\u001a\u00020\u00042\u0006\u0010g\u001a\u00020'2\b\b\u0002\u0010k\u001a\u00020lH\u0007J\u000e\u0010j\u001a\u00020\u00042\u0006\u0010g\u001a\u00020\u0004J\u0006\u0010m\u001a\u00020\u0010J\u0006\u00104\u001a\u00020\u0010J\"\u0010n\u001a\u00020\u00102\u0006\u0010o\u001a\u00020H2\b\b\u0002\u0010p\u001a\u00020H2\b\b\u0002\u0010q\u001a\u00020HJ\u000e\u0010r\u001a\u00020s2\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010t\u001a\u0002012\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010u\u001a\u00020V2\u0006\u0010J\u001a\u00020\u0010J\u000e\u0010v\u001a\u0002092\u0006\u0010w\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010#\u001a\n $*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u0019\u0010&\u001a\n $*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\n $*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0019\u0010,\u001a\n $*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0016\u0010.\u001a\n $*\u0004\u0018\u00010/0/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u00100\u001a\n $*\u0004\u0018\u000101018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0019\u00104\u001a\n $*\u0004\u0018\u000101018F\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u0019\u00106\u001a\n $*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0012R\"\u00108\u001a\n $*\u0004\u0018\u00010909X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010>\u001a\n $*\u0004\u0018\u00010?0?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006x"}, d2={"Lai/platon/pulsar/common/DateTimes;", "", "()V", "DATE_REGEX", "", "DATE_TIME_REGEX", "HOURS_OF_DAY", "", "HOURS_OF_MONTH", "HOURS_OF_YEAR", "MILLIS_OF_DAY", "MILLIS_OF_HOUR", "MILLIS_OF_MINUTE", "MILLIS_OF_SECOND", "MINUTES_OF_HOUR", "ONE_YEAR_LATER", "Ljava/time/Instant;", "getONE_YEAR_LATER", "()Ljava/time/Instant;", "PATH_SAFE_FORMAT_1", "Ljava/text/SimpleDateFormat;", "getPATH_SAFE_FORMAT_1", "()Ljava/text/SimpleDateFormat;", "PATH_SAFE_FORMAT_2", "getPATH_SAFE_FORMAT_2", "PATH_SAFE_FORMAT_3", "getPATH_SAFE_FORMAT_3", "PATH_SAFE_FORMAT_4", "getPATH_SAFE_FORMAT_4", "PULSAR_ZONE_ID", "PULSAR_ZONE_OFFSET", "SECONDS_OF_DAY", "SECONDS_OF_HOUR", "SECONDS_OF_MINUTE", "SIMPLE_DATE_TIME_REGEX", "doomsday", "kotlin.jvm.PlatformType", "getDoomsday", "elapsed", "Ljava/time/Duration;", "getElapsed", "()Ljava/time/Duration;", "elapsedThisHour", "getElapsedThisHour", "elapsedToday", "getElapsedToday", "logger", "Lorg/slf4j/Logger;", "midnight", "Ljava/time/LocalDateTime;", "getMidnight", "()Ljava/time/LocalDateTime;", "startOfHour", "getStartOfHour", "startTime", "getStartTime", "zoneId", "Ljava/time/ZoneId;", "getZoneId", "()Ljava/time/ZoneId;", "setZoneId", "(Ljava/time/ZoneId;)V", "zoneOffset", "Ljava/time/ZoneOffset;", "getZoneOffset", "()Ljava/time/ZoneOffset;", "setZoneOffset", "(Ljava/time/ZoneOffset;)V", "constructTimeHistory", "timeHistory", "fetchTime", "maxRecords", "", "dayOfMonth", "instant", "dayOfWeek", "Ljava/time/DayOfWeek;", "elapsedSeconds", "elapsedTime", "start", "end", "endOfDay", "endOfHour", "format", "time", "localTime", "Ljava/time/OffsetDateTime;", "epochMilli", "formatHttpDateTime", "formatNow", "isDaysBefore", "", "dateTime", "days", "isoInstantFormat", "date", "Ljava/util/Date;", "now", "parseBestInstant", "text", "defaultValue", "parseBestInstantOrNull", "parseDuration", "duration", "parseHttpDateTime", "parseInstant", "readableDuration", "truncatedToUnit", "Ljava/time/temporal/ChronoUnit;", "startOfDay", "timePointOfDay", "hour", "minute", "second", "toLocalDate", "Ljava/time/LocalDate;", "toLocalDateTime", "toOffsetDateTime", "zoneIdOrDefault", "name", "pulsar-common"})
public final class DateTimes {
    @NotNull
    public static final DateTimes INSTANCE = new DateTimes();
    private static final Logger logger = LogsKt.getLogger(Reflection.getOrCreateKotlinClass(DateTimes.class));
    @NotNull
    private static final SimpleDateFormat PATH_SAFE_FORMAT_1 = new SimpleDateFormat("MMdd");
    @NotNull
    private static final SimpleDateFormat PATH_SAFE_FORMAT_2 = new SimpleDateFormat("MMdd.HH");
    @NotNull
    private static final SimpleDateFormat PATH_SAFE_FORMAT_3 = new SimpleDateFormat("MMdd.HHmm");
    @NotNull
    private static final SimpleDateFormat PATH_SAFE_FORMAT_4 = new SimpleDateFormat("MMdd.HHmmss");
    public static final long HOURS_OF_DAY = 24L;
    public static final long HOURS_OF_MONTH = 720L;
    public static final long HOURS_OF_YEAR = 8760L;
    public static final long MILLIS_OF_SECOND = 1000L;
    public static final long MILLIS_OF_MINUTE = 60000L;
    public static final long MILLIS_OF_HOUR = 3600000L;
    public static final long MILLIS_OF_DAY = 86400000L;
    public static final long MINUTES_OF_HOUR = 60L;
    public static final long SECONDS_OF_MINUTE = 60L;
    public static final long SECONDS_OF_HOUR = 3600L;
    public static final long SECONDS_OF_DAY = 86400L;
    @NotNull
    private static final Instant ONE_YEAR_LATER;
    @NotNull
    public static final String DATE_REGEX = "\\d{4}-\\d{2}-\\d{2}";
    @NotNull
    public static final String DATE_TIME_REGEX = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:.+";
    @NotNull
    public static final String SIMPLE_DATE_TIME_REGEX = "\\d{4}-\\d{2}-\\d{2}\\s+\\d{2}:.+";
    @NotNull
    public static final String PULSAR_ZONE_ID = "pulsar.zone.id";
    @NotNull
    public static final String PULSAR_ZONE_OFFSET = "pulsar.zone.offset";
    private static ZoneId zoneId;
    private static ZoneOffset zoneOffset;
    private static final Instant startTime;
    private static final Instant doomsday;

    private DateTimes() {
    }

    @NotNull
    public final SimpleDateFormat getPATH_SAFE_FORMAT_1() {
        return PATH_SAFE_FORMAT_1;
    }

    @NotNull
    public final SimpleDateFormat getPATH_SAFE_FORMAT_2() {
        return PATH_SAFE_FORMAT_2;
    }

    @NotNull
    public final SimpleDateFormat getPATH_SAFE_FORMAT_3() {
        return PATH_SAFE_FORMAT_3;
    }

    @NotNull
    public final SimpleDateFormat getPATH_SAFE_FORMAT_4() {
        return PATH_SAFE_FORMAT_4;
    }

    @NotNull
    public final Instant getONE_YEAR_LATER() {
        return ONE_YEAR_LATER;
    }

    public final ZoneId getZoneId() {
        return zoneId;
    }

    public final void setZoneId(ZoneId zoneId) {
        DateTimes.zoneId = zoneId;
    }

    public final ZoneOffset getZoneOffset() {
        return zoneOffset;
    }

    public final void setZoneOffset(ZoneOffset zoneOffset) {
        DateTimes.zoneOffset = zoneOffset;
    }

    public final Instant getStartTime() {
        return startTime;
    }

    public final Instant getDoomsday() {
        return doomsday;
    }

    public final LocalDateTime getMidnight() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.DAYS);
    }

    public final LocalDateTime getStartOfHour() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.HOURS);
    }

    public final Duration getElapsed() {
        return Duration.between(startTime, Instant.now());
    }

    public final Duration getElapsedToday() {
        return Duration.between(this.getMidnight(), LocalDateTime.now());
    }

    public final Duration getElapsedThisHour() {
        return Duration.between(this.getStartOfHour(), LocalDateTime.now());
    }

    @NotNull
    public final ZoneId zoneIdOrDefault(@NotNull String name) {
        ZoneId zoneId;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (ZoneId.getAvailableZoneIds().contains(name)) {
            ZoneId zoneId2 = ZoneId.of(name);
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"{\n            ZoneId.of(name)\n        }");
            zoneId = zoneId2;
        } else {
            ZoneId zoneId3 = DateTimes.zoneId;
            Intrinsics.checkNotNullExpressionValue((Object)zoneId3, (String)"{\n            zoneId\n        }");
            zoneId = zoneId3;
        }
        return zoneId;
    }

    @NotNull
    public final String format(long time) {
        String string = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(zoneId).format(Instant.ofEpochMilli(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_LOCAL_DATE_TIME.with\u2026stant.ofEpochMilli(time))");
        return string;
    }

    @NotNull
    public final String format(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(zoneId).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_LOCAL_DATE_TIME.withZone(zoneId).format(time)");
        return string;
    }

    @NotNull
    public final String format(@NotNull Instant time, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = DateTimeFormatter.ofPattern(format).withZone(zoneId).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofPattern(format).withZone(zoneId).format(time)");
        return string;
    }

    @NotNull
    public final String format(@NotNull LocalDateTime localTime) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        String string = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_LOCAL_DATE_TIME.format(localTime)");
        return string;
    }

    @NotNull
    public final String format(@NotNull LocalDateTime localTime, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = DateTimeFormatter.ofPattern(format).format(localTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofPattern(format).format(localTime)");
        return string;
    }

    @NotNull
    public final String format(@NotNull OffsetDateTime localTime, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = DateTimeFormatter.ofPattern(format).format(localTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofPattern(format).format(localTime)");
        return string;
    }

    @NotNull
    public final String format(long epochMilli, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Instant instant = Instant.ofEpochMilli(epochMilli);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(epochMilli)");
        return this.format(instant, format);
    }

    @NotNull
    public final String formatNow(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.format(instant, format);
    }

    @JvmOverloads
    @NotNull
    public final String readableDuration(@NotNull Duration duration, @NotNull ChronoUnit truncatedToUnit) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)truncatedToUnit, (String)"truncatedToUnit");
        String string = StringUtils.removeStart((String)duration.truncatedTo(truncatedToUnit).toString(), (String)"PT");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeStart(duration.tru\u2026ToUnit).toString(), \"PT\")");
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    public static /* synthetic */ String readableDuration$default(DateTimes dateTimes, Duration duration, ChronoUnit chronoUnit, int n, Object object) {
        if ((n & 2) != 0) {
            chronoUnit = ChronoUnit.SECONDS;
        }
        return dateTimes.readableDuration(duration, chronoUnit);
    }

    @NotNull
    public final String readableDuration(@NotNull String duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        String string = StringUtils.removeStart((String)duration, (String)"PT");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeStart(duration, \"PT\")");
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public final String isoInstantFormat(long time) {
        String string = DateTimeFormatter.ISO_INSTANT.format(new Date(time).toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_INSTANT.format(Date(time).toInstant())");
        return string;
    }

    @NotNull
    public final String isoInstantFormat(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateTimeFormatter.ISO_INSTANT.format(date.toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_INSTANT.format(date.toInstant())");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String isoInstantFormat(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = DateTimeFormatter.ISO_INSTANT.format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ISO_INSTANT.format(time)");
        return string;
    }

    @NotNull
    public final String now(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.format(System.currentTimeMillis(), format);
    }

    @JvmStatic
    @NotNull
    public static final String now() {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
        return INSTANCE.format(localDateTime);
    }

    @NotNull
    public final LocalDate toLocalDate(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"instant.atZone(zoneId).toLocalDate()");
        return localDate;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"instant.atZone(zoneId).toLocalDateTime()");
        return localDateTime;
    }

    @NotNull
    public final OffsetDateTime toOffsetDateTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        OffsetDateTime offsetDateTime = instant.atZone(zoneId).toOffsetDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"instant.atZone(zoneId).toOffsetDateTime()");
        return offsetDateTime;
    }

    @NotNull
    public final Instant startOfHour() {
        Instant instant = Instant.now().truncatedTo(ChronoUnit.HOURS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().truncatedTo(ChronoUnit.HOURS)");
        return instant;
    }

    @NotNull
    public final Instant endOfHour() {
        Instant instant = Instant.now().truncatedTo(ChronoUnit.HOURS).plus(Duration.ofHours(1L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().truncatedTo(Chrono\u2026plus(Duration.ofHours(1))");
        return instant;
    }

    @NotNull
    public final Instant startOfDay() {
        Instant instant = LocalDate.now().atStartOfDay().toInstant(zoneOffset);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().atStartOfDay().toInstant(zoneOffset)");
        return instant;
    }

    @NotNull
    public final Instant endOfDay() {
        Instant instant = LocalDate.now().atStartOfDay().toInstant(zoneOffset).plus(Duration.ofHours(24L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().atStartOfDay().toI\u2026lus(Duration.ofHours(24))");
        return instant;
    }

    @NotNull
    public final Instant timePointOfDay(int hour, int minute, int second) {
        Instant instant = LocalDate.now().atTime(hour, minute, second).toInstant(zoneOffset);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().atTime(hour, minut\u2026nd).toInstant(zoneOffset)");
        return instant;
    }

    public static /* synthetic */ Instant timePointOfDay$default(DateTimes dateTimes, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return dateTimes.timePointOfDay(n, n2, n3);
    }

    @NotNull
    public final DayOfWeek dayOfWeek() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.dayOfWeek(instant);
    }

    @NotNull
    public final DayOfWeek dayOfWeek(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        DayOfWeek dayOfWeek = instant.atZone(zoneId).getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"instant.atZone(zoneId).dayOfWeek");
        return dayOfWeek;
    }

    public final int dayOfMonth() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.dayOfMonth(instant);
    }

    public final int dayOfMonth(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return instant.atZone(zoneId).getDayOfMonth();
    }

    @NotNull
    public final Duration elapsedTime() {
        Instant instant = startTime;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"startTime");
        Instant instant2 = instant;
        instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.elapsedTime(instant2, instant);
    }

    @NotNull
    public final Duration elapsedTime(long start2) {
        Instant instant = Instant.ofEpochMilli(start2);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(start)");
        Instant instant2 = instant;
        instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return this.elapsedTime(instant2, instant);
    }

    public final long elapsedSeconds() {
        return RangesKt.coerceAtLeast((long)this.elapsedTime().getSeconds(), (long)1L);
    }

    @JvmOverloads
    @NotNull
    public final Duration elapsedTime(@NotNull Instant start2, @NotNull Instant end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Duration duration = Duration.between(start2, end);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(start, end)");
        return duration;
    }

    public static /* synthetic */ Duration elapsedTime$default(DateTimes dateTimes, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant3 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now()");
            instant2 = instant3;
        }
        return dateTimes.elapsedTime(instant, instant2);
    }

    @JvmStatic
    @NotNull
    public static final Instant parseHttpDateTime(@NotNull String text, @NotNull Instant defaultValue) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            Date d = DateUtils.parseDate((String)text);
            instant = d.toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"{\n            val d = Da\u2026  d.toInstant()\n        }");
        }
        catch (Throwable e) {
            instant = defaultValue;
        }
        return instant;
    }

    @NotNull
    public final String formatHttpDateTime(long time) {
        String string = DateUtils.formatDate((Date)new Date(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDate(Date(time))");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String formatHttpDateTime(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = DateUtils.formatDate((Date)Date.from(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDate(Date.from(time))");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Instant parseInstant(@NotNull String text, @NotNull Instant defaultValue) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            Instant instant = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)text, DateTimes::parseInstant$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ISO_INSTANT.parse(text) \u2026 Instant.from(temporal) }");
            return instant;
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static /* synthetic */ Instant parseInstant$default(String string, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.EPOCH;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"EPOCH");
            instant = instant2;
        }
        return DateTimes.parseInstant(string, instant);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Instant parseBestInstant(@NotNull String text, @NotNull Instant defaultValue) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Instant instant = DateTimes.parseBestInstantOrNull(text);
        return instant == null ? defaultValue : instant;
    }

    public static /* synthetic */ Instant parseBestInstant$default(String string, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.EPOCH;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"EPOCH");
            instant = instant2;
        }
        return DateTimes.parseBestInstant(string, instant);
    }

    @JvmStatic
    @Nullable
    public static final Instant parseBestInstantOrNull(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            Instant instant;
            if (StringsKt.isBlank((CharSequence)text)) {
                instant = null;
            } else {
                CharSequence charSequence = text;
                Object object = DATE_REGEX + "T\\d{2}.+Z";
                boolean bl = false;
                object = new Regex((String)object);
                bl = false;
                if (object.matches(charSequence)) {
                    instant = Instant.parse(text);
                } else {
                    CharSequence pattern;
                    charSequence = text;
                    object = SIMPLE_DATE_TIME_REGEX;
                    bl = false;
                    object = new Regex((String)object);
                    bl = false;
                    if (object.matches(charSequence)) {
                        pattern = "yyyy-MM-dd HH[:mm][:ss]";
                        instant = DateTimeFormatter.ofPattern(pattern).parse((CharSequence)text, DateTimes::parseBestInstantOrNull$lambda-1).atZone(zoneId).toInstant();
                    } else {
                        pattern = text;
                        object = DATE_TIME_REGEX;
                        bl = false;
                        object = new Regex((String)object);
                        bl = false;
                        if (object.matches(pattern)) {
                            pattern = "yyyy-MM-dd'T'HH[:mm][:ss]";
                            instant = DateTimeFormatter.ofPattern(pattern).parse((CharSequence)text, DateTimes::parseBestInstantOrNull$lambda-2).atZone(zoneId).toInstant();
                        } else {
                            pattern = text;
                            object = DATE_REGEX;
                            bl = false;
                            object = new Regex((String)object);
                            bl = false;
                            if (object.matches(pattern)) {
                                pattern = "yyyy-MM-dd";
                                instant = DateTimeFormatter.ofPattern(pattern).parse((CharSequence)text, DateTimes::parseBestInstantOrNull$lambda-3).atStartOfDay().atZone(zoneId).toInstant();
                            } else {
                                instant = null;
                            }
                        }
                    }
                }
            }
            return instant;
        }
        catch (Throwable e) {
            logger.warn("Failed to parse " + text + " | {}", e);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final Duration parseDuration(@NotNull String duration, @NotNull Duration defaultValue) {
        Duration duration2;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            duration2 = Duration.parse(duration);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"{\n            Duration.parse(duration)\n        }");
        }
        catch (Throwable ignored) {
            duration2 = defaultValue;
        }
        return duration2;
    }

    @JvmStatic
    @Nullable
    public static final String constructTimeHistory(@Nullable String timeHistory, @NotNull Instant fetchTime, int maxRecords) {
        Intrinsics.checkNotNullParameter((Object)fetchTime, (String)"fetchTime");
        Object history = timeHistory;
        String dateStr = DateTimes.isoInstantFormat(fetchTime);
        if (history == null) {
            history = dateStr;
        } else {
            String[] stringArray = new String[]{","};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)history), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] fetchTimes = objectArray;
            if (fetchTimes.length > maxRecords) {
                String firstFetchTime = fetchTimes[0];
                int start2 = fetchTimes.length - maxRecords;
                int end = fetchTimes.length;
                history = firstFetchTime + "," + StringUtils.join((Object[])fetchTimes, (char)',', (int)start2, (int)end);
            }
            history = (String)history + ",";
            history = (String)history + dateStr;
        }
        return history;
    }

    @JvmStatic
    public static final boolean isDaysBefore(@NotNull OffsetDateTime dateTime, int days) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return DateTimeDetector.CURRENT_DATE_EPOCH_DAYS - dateTime.toLocalDate().toEpochDay() > (long)days;
    }

    @JvmOverloads
    @NotNull
    public final String readableDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return DateTimes.readableDuration$default(this, duration, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Duration elapsedTime(@NotNull Instant start2) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        return DateTimes.elapsedTime$default(this, start2, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Instant parseInstant(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return DateTimes.parseInstant$default(text, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Instant parseBestInstant(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return DateTimes.parseBestInstant$default(text, null, 2, null);
    }

    private static final Instant parseInstant$lambda-0(TemporalAccessor temporal) {
        return Instant.from(temporal);
    }

    private static final LocalDateTime parseBestInstantOrNull$lambda-1(TemporalAccessor it) {
        return LocalDateTime.from(it);
    }

    private static final LocalDateTime parseBestInstantOrNull$lambda-2(TemporalAccessor it) {
        return LocalDateTime.from(it);
    }

    private static final LocalDate parseBestInstantOrNull$lambda-3(TemporalAccessor it) {
        return LocalDate.from(it);
    }

    static {
        Instant instant = Instant.now().plus(Duration.ofDays(365L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.now() + Duration.ofDays(365)");
        ONE_YEAR_LATER = instant;
        zoneId = ZoneId.of(System.getProperty(PULSAR_ZONE_ID, "Asia/Shanghai"));
        zoneOffset = ZoneOffset.of(System.getProperty(PULSAR_ZONE_OFFSET, "+08:00"));
        startTime = Instant.now();
        doomsday = Instant.parse("2200-01-01T00:00:00Z");
    }
}

