/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.config.Params;
import javax.annotation.Nonnull;

public class ScoreEntry
implements Comparable<ScoreEntry> {
    public static final int DEFAULT_DIGITS = 5;
    private String name;
    private int priority;
    private int value;
    private int digits = 5;

    public ScoreEntry(String name, int value) {
        this(name, 0, value, 5);
    }

    public ScoreEntry(String name, int priority, int value) {
        this(name, priority, value, 5);
    }

    public ScoreEntry(String name, int priority, int value, int digits) {
        this.name = name;
        this.priority = priority;
        this.value = value;
        this.digits = digits;
    }

    public ScoreEntry(ScoreEntry other) {
        this.name = other.name;
        this.priority = other.priority;
        this.value = other.value;
        this.digits = other.digits;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public ScoreEntry clone() {
        return new ScoreEntry(this.name, this.priority, this.value, this.digits);
    }

    public String toString() {
        return Params.formatAsLine("name", this.name, "priority", this.priority, "value", this.value, "digits", this.digits);
    }

    public boolean equals(Object other) {
        return other instanceof ScoreEntry && this.compareTo((ScoreEntry)other) == 0;
    }

    @Override
    public int compareTo(@Nonnull ScoreEntry scoreEntry) {
        int diff = this.priority - scoreEntry.priority;
        if (diff != 0) {
            return diff;
        }
        return this.value - scoreEntry.value;
    }
}

