/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.proxy;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.concurrent.ConcurrentPassiveExpiringSet;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.LoadingProxyPool;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyLoader;
import ai.platon.pulsar.common.proxy.ProxyPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lai/platon/pulsar/common/proxy/LoadingProxyPool;", "Lai/platon/pulsar/common/proxy/ProxyPool;", "proxyLoader", "Lai/platon/pulsar/common/proxy/ProxyLoader;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/proxy/ProxyLoader;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bannedIps", "Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "", "getBannedIps", "()Lai/platon/pulsar/common/concurrent/ConcurrentPassiveExpiringSet;", "bannedSegments", "getBannedSegments", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProxyLoader", "()Lai/platon/pulsar/common/proxy/ProxyLoader;", "ban", "", "proxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "dump", "handleBanState", "Lai/platon/pulsar/common/proxy/ProxyEntry$BanState;", "load", "poll0", "report", "retire", "take", "toString", "pulsar-common"})
public final class LoadingProxyPool
extends ProxyPool {
    @NotNull
    private final ProxyLoader proxyLoader;
    private final Logger log;

    public LoadingProxyPool(@NotNull ProxyLoader proxyLoader, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)proxyLoader, (String)"proxyLoader");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.proxyLoader = proxyLoader;
        this.log = LoggerFactory.getLogger(LoadingProxyPool.class);
    }

    @NotNull
    public final ProxyLoader getProxyLoader() {
        return this.proxyLoader;
    }

    private final ConcurrentPassiveExpiringSet<String> getBannedIps() {
        return this.proxyLoader.getBannedIps();
    }

    private final ConcurrentPassiveExpiringSet<String> getBannedSegments() {
        return this.proxyLoader.getBannedSegments();
    }

    @Override
    @Nullable
    public ProxyEntry take() throws ProxyException {
        this.setLastActiveTime(Instant.now());
        int i = 0;
        int maxRetry = 5;
        ProxyEntry proxy = null;
        while (this.isActive() && proxy == null) {
            int n = i;
            i = n + 1;
            if (n >= maxRetry || Thread.currentThread().isInterrupted()) break;
            if (this.getFreeProxies().isEmpty()) {
                this.load();
            }
            proxy = this.poll0();
        }
        return proxy;
    }

    @Override
    public void retire(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        proxyEntry.retire();
        if (proxyEntry.isBanned()) {
            this.ban(proxyEntry);
        }
    }

    @Override
    public void report(@NotNull ProxyEntry proxyEntry) {
        Intrinsics.checkNotNullParameter((Object)proxyEntry, (String)"proxyEntry");
        Object[] objectArray = new Object[6];
        objectArray[0] = proxyEntry.getOutIp();
        objectArray[1] = proxyEntry.getNumSuccessPages();
        Duration duration = proxyEntry.getElapsedTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"proxyEntry.elapsedTime");
        objectArray[2] = DateTimesKt.readable(duration);
        objectArray[3] = this.getNumProxyBanned();
        objectArray[4] = this.getBannedIps().size();
        objectArray[5] = proxyEntry;
        this.log.info("Ban proxy <{}> after {} pages served in {} | total ban: {}, banned ips: {} | {}", objectArray);
        String s2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.chunked((Iterable)this.getBannedSegments(), (int)20), (CharSequence)"\n", null, null, (int)0, null, (Function1)report.s.1.INSTANCE, (int)30, null);
        this.log.info("Banned segments ({}): {}", (Object)this.getBannedSegments().size(), (Object)s2);
    }

    private final void ban(ProxyEntry proxyEntry) {
        if (Intrinsics.areEqual((Object)proxyEntry.getHost(), (Object)"127.0.0.1")) {
            return;
        }
        boolean banned = false;
        if (!this.getBannedIps().contains(proxyEntry.getOutIp())) {
            this.getBannedIps().add(proxyEntry.getOutIp());
            banned = true;
        }
        if (!this.getBannedSegments().contains(proxyEntry.getOutSegment())) {
            this.getBannedSegments().add(proxyEntry.getOutSegment());
            banned = true;
        }
        if (banned) {
            LoadingProxyPool loadingProxyPool = this;
            loadingProxyPool.setNumProxyBanned(loadingProxyPool.getNumProxyBanned() + 1);
            loadingProxyPool.getNumProxyBanned();
            this.report(proxyEntry);
        }
    }

    private final void load() throws ProxyException {
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)this.proxyLoader.updateProxies(duration)), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getProxyEntries().contains(it);
            }
        })), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LoadingProxyPool.access$getBannedIps(this.this$0).contains(it.getOutIp());
            }
        })), (Function1)((Function1)new Function1<ProxyEntry, Boolean>(this){
            final /* synthetic */ LoadingProxyPool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ProxyEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LoadingProxyPool.access$getBannedSegments(this.this$0).contains(it.getOutSegment());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProxyEntry it = (ProxyEntry)element$iv;
            boolean bl = false;
            this.offer(it);
        }
    }

    private final ProxyEntry poll0() {
        Object object;
        Object object2;
        try {
            object2 = this.getFreeProxies().poll(this.getPollingTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            object2 = null;
        }
        ProxyEntry proxyEntry = object2;
        if (proxyEntry == null) {
            return null;
        }
        ProxyEntry proxy = proxyEntry;
        Object object3 = this.handleBanState(proxy);
        boolean bl = false;
        boolean bl2 = false;
        ProxyEntry.BanState it = object3;
        boolean bl3 = false;
        Object object4 = object2 = it.isBanned() ? object3 : null;
        if (object2 == null) {
            object = null;
        } else {
            object3 = object2;
            bl = false;
            bl2 = false;
            it = object3;
            boolean bl4 = false;
            Object[] objectArray = this;
            int n = objectArray.getNumProxyBanned();
            objectArray.setNumProxyBanned(n + 1);
            objectArray = new Object[]{it, this.getNumProxyBanned(), super.getBannedIps().size(), super.getBannedSegments().size(), proxy.getDisplay()};
            this.log.info("Proxy is banned <{}> | bp: {}, bh: {}, bs: {} | {}", objectArray);
            object = object3;
        }
        Object banState = object;
        object2 = proxy;
        boolean bl5 = false;
        bl = false;
        Object it2 = object2;
        boolean bl6 = false;
        return banState == null ? object2 : null;
    }

    private final ProxyEntry.BanState handleBanState(ProxyEntry proxyEntry) {
        Object object;
        Object object2 = this.proxyLoader.getBanStrategy();
        String banStrategy = object2 == null ? "" : object2;
        if (Intrinsics.areEqual((Object)banStrategy, (Object)"")) {
            object = ProxyEntry.BanState.OK;
        } else if (Intrinsics.areEqual((Object)banStrategy, (Object)"none")) {
            object = ProxyEntry.BanState.OK;
        } else if (Intrinsics.areEqual((Object)banStrategy, (Object)"clear")) {
            object2 = ProxyEntry.BanState.OK;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.getBannedSegments().clear();
            this.getBannedIps().clear();
            object = object2;
        } else {
            object = StringsKt.startsWith$default((String)banStrategy, (String)"segment", (boolean)false, (int)2, null) && this.getBannedSegments().contains(proxyEntry.getOutSegment()) ? ProxyEntry.BanState.SEGMENT : (StringsKt.startsWith$default((String)banStrategy, (String)"host", (boolean)false, (int)2, null) && this.getBannedIps().contains(proxyEntry.getOutIp()) ? ProxyEntry.BanState.HOST : (proxyEntry.isBanned() ? ProxyEntry.BanState.OTHER : ProxyEntry.BanState.OK));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() {
        Path path = AppPaths.INSTANCE.getPROXY_ARCHIVE_DIR();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"AppPaths.PROXY_ARCHIVE_DIR");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (path) {
            Object object;
            boolean bl3 = false;
            try {
                Files.writeString(AppPaths.INSTANCE.getPROXY_BANNED_HOSTS_FILE(), (CharSequence)CollectionsKt.joinToString$default((Iterable)this.getBannedIps(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new OpenOption[0]);
                object = Files.writeString(AppPaths.INSTANCE.getPROXY_BANNED_SEGMENTS_FILE(), (CharSequence)CollectionsKt.joinToString$default((Iterable)this.getBannedSegments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new OpenOption[0]);
            }
            catch (IOException e) {
                this.log.warn(e.toString());
                object = Unit.INSTANCE;
            }
            Unit unit = object;
        }
        super.dump();
    }

    @Override
    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "total %d, free: %d, banH: %d banS: %d";
        Object[] objectArray = new Object[]{this.getProxyEntries().size(), this.getFreeProxies().size(), this.getBannedIps().size(), this.getBannedSegments().size()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public static final /* synthetic */ ConcurrentPassiveExpiringSet access$getBannedIps(LoadingProxyPool $this) {
        return $this.getBannedIps();
    }

    public static final /* synthetic */ ConcurrentPassiveExpiringSet access$getBannedSegments(LoadingProxyPool $this) {
        return $this.getBannedSegments();
    }
}

