/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.urls;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.options.OptionsKt;
import ai.platon.pulsar.common.urls.ComparableUrlAware;
import ai.platon.pulsar.common.urls.UrlAware;
import java.net.URL;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u0011\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0001H\u0096\u0002J\u0013\u00100\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u00020%H\u0016J\b\u00103\u001a\u00020\u0004H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u001a\u0010!\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR\u001a\u0010$\u001a\u00020%X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\n\"\u0004\b+\u0010\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\n\"\u0004\b-\u0010\f\u00a8\u00064"}, d2={"Lai/platon/pulsar/common/urls/AbstractUrl;", "Lai/platon/pulsar/common/urls/UrlAware;", "Lai/platon/pulsar/common/urls/ComparableUrlAware;", "url", "", "args", "referer", "href", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "configuredUrl", "getConfiguredUrl", "country", "getCountry", "setCountry", "deadTime", "Ljava/time/Instant;", "getDeadTime", "()Ljava/time/Instant;", "district", "getDistrict", "setDistrict", "getHref", "setHref", "isNil", "", "()Z", "isPersistable", "label", "getLabel", "lang", "getLang", "setLang", "maxRetry", "", "getMaxRetry", "()I", "setMaxRetry", "(I)V", "getReferer", "setReferer", "getUrl", "setUrl", "compareTo", "other", "equals", "", "hashCode", "toString", "pulsar-common"})
public abstract class AbstractUrl
implements UrlAware,
ComparableUrlAware {
    @NotNull
    private String url;
    @Nullable
    private String args;
    @Nullable
    private String referer;
    @Nullable
    private String href;
    private final boolean isPersistable;
    @NotNull
    private String lang;
    @NotNull
    private String country;
    @NotNull
    private String district;
    private int maxRetry;

    public AbstractUrl(@NotNull String url, @Nullable String args, @Nullable String referer, @Nullable String href) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.args = args;
        this.referer = referer;
        this.href = href;
        this.isPersistable = true;
        this.lang = "*";
        this.country = "*";
        this.district = "*";
        this.maxRetry = 3;
    }

    public /* synthetic */ AbstractUrl(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4);
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @Override
    @Nullable
    public String getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @Override
    @Nullable
    public String getReferer() {
        return this.referer;
    }

    @Override
    public void setReferer(@Nullable String string) {
        this.referer = string;
    }

    @Override
    @Nullable
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(@Nullable String string) {
        this.href = string;
    }

    @Override
    @NotNull
    public String getConfiguredUrl() {
        return this.getArgs() != null ? this.getUrl() + " " + this.getArgs() : this.getUrl();
    }

    @Override
    public boolean isNil() {
        return Intrinsics.areEqual((Object)this.getUrl(), (Object)"http://internal.pulsar.platon.ai/nil");
    }

    @Override
    public boolean isPersistable() {
        return this.isPersistable;
    }

    @Override
    @NotNull
    public String getLabel() {
        Object[] objectArray = new String[]{"-l", "-label", "--label"};
        String string = OptionsKt.findOption(this.getArgs(), CollectionsKt.listOf((Object[])objectArray));
        return string == null ? "" : string;
    }

    @Override
    @NotNull
    public String getLang() {
        return this.lang;
    }

    public void setLang(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lang = string;
    }

    @Override
    @NotNull
    public String getCountry() {
        return this.country;
    }

    public void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @Override
    @NotNull
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.district = string;
    }

    @Override
    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int n) {
        this.maxRetry = n;
    }

    @Override
    @NotNull
    public Instant getDeadTime() {
        Object object;
        Object object2 = new String[]{"-deadTime", "--dead-time"};
        Object object3 = OptionsKt.findOption(this.getArgs(), CollectionsKt.listOf((Object[])object2));
        Object deadTime = object3 == null ? "" : object3;
        object3 = DateTimes.parseBestInstantOrNull((String)deadTime);
        if (object3 == null) {
            object2 = DateTimes.INSTANCE.getDoomsday();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DateTimes.doomsday");
            object = object2;
        } else {
            object = object3;
        }
        return object;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        Object object = other;
        return object instanceof String ? Intrinsics.areEqual((Object)this.getUrl(), (Object)other) : (object instanceof URL ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((URL)other).toString()) : (object instanceof UrlAware ? Intrinsics.areEqual((Object)this.getUrl(), (Object)((UrlAware)other).getUrl()) : false));
    }

    @Override
    public int compareTo(@NotNull UrlAware other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getUrl().compareTo(other.getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }
}

